/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.configuration;

import com.bmc.thirdparty.org.apache.commons.configuration.Configuration;
import com.bmc.thirdparty.org.apache.commons.configuration.ConfigurationRuntimeException;
import com.bmc.thirdparty.org.apache.commons.configuration.HierarchicalConfiguration;
import com.bmc.thirdparty.org.apache.commons.lang.StringUtils;
import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Iterator;

public final class ConfigurationUtils {
    static final String PROTOCOL_FILE = "file";
    static final String RESOURCE_PATH_SEPARATOR = "/";
    private static final String METHOD_CLONE = "clone";
    private static Log log = LogFactory.getLog(class$org$apache$commons$configuration$ConfigurationUtils == null ? (class$org$apache$commons$configuration$ConfigurationUtils = ConfigurationUtils.class$("com.bmc.thirdparty.org.apache.commons.configuration.ConfigurationUtils")) : class$org$apache$commons$configuration$ConfigurationUtils);
    static /* synthetic */ Class class$org$apache$commons$configuration$ConfigurationUtils;

    private ConfigurationUtils() {
    }

    public static void dump(Configuration configuration, PrintStream out) {
        ConfigurationUtils.dump(configuration, new PrintWriter(out));
    }

    public static void dump(Configuration configuration, PrintWriter out) {
        Iterator keys = configuration.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = configuration.getProperty(key);
            out.print(key);
            out.print("=");
            out.print(value);
            if (!keys.hasNext()) continue;
            out.println();
        }
        out.flush();
    }

    public static String toString(Configuration configuration) {
        StringWriter writer = new StringWriter();
        ConfigurationUtils.dump(configuration, new PrintWriter(writer));
        return writer.toString();
    }

    public static void copy(Configuration source, Configuration target) {
        Iterator keys = source.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            target.setProperty(key, source.getProperty(key));
        }
    }

    public static void append(Configuration source, Configuration target) {
        Iterator keys = source.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            target.addProperty(key, source.getProperty(key));
        }
    }

    public static HierarchicalConfiguration convertToHierarchical(Configuration conf) {
        if (conf == null) {
            return null;
        }
        if (conf instanceof HierarchicalConfiguration) {
            return (HierarchicalConfiguration)conf;
        }
        HierarchicalConfiguration hc = new HierarchicalConfiguration();
        ConfigurationUtils.copy(conf, hc);
        return hc;
    }

    public static Configuration cloneConfiguration(Configuration config) throws ConfigurationRuntimeException {
        if (config == null) {
            return null;
        }
        try {
            return (Configuration)ConfigurationUtils.clone(config);
        }
        catch (CloneNotSupportedException cnex) {
            throw new ConfigurationRuntimeException(cnex);
        }
    }

    static Object clone(Object obj) throws CloneNotSupportedException {
        if (obj instanceof Cloneable) {
            try {
                Method m2 = obj.getClass().getMethod(METHOD_CLONE, null);
                return m2.invoke(obj, null);
            }
            catch (NoSuchMethodException nmex) {
                throw new CloneNotSupportedException("No clone() method found for class" + obj.getClass().getName());
            }
            catch (IllegalAccessException iaex) {
                throw new ConfigurationRuntimeException(iaex);
            }
            catch (InvocationTargetException itex) {
                throw new ConfigurationRuntimeException(itex);
            }
        }
        throw new CloneNotSupportedException(obj.getClass().getName() + " does not implement Cloneable");
    }

    public static URL getURL(String basePath, String file) throws MalformedURLException {
        File f2 = new File(file);
        if (f2.isAbsolute()) {
            return f2.toURL();
        }
        try {
            if (basePath == null) {
                return new URL(file);
            }
            URL base = new URL(basePath);
            return new URL(base, file);
        }
        catch (MalformedURLException uex) {
            return ConfigurationUtils.constructFile(basePath, file).toURL();
        }
    }

    static File constructFile(String basePath, String fileName) {
        File file = null;
        File absolute = null;
        if (fileName != null) {
            absolute = new File(fileName);
        }
        if (StringUtils.isEmpty(basePath) || absolute != null && absolute.isAbsolute()) {
            file = new File(fileName);
        } else {
            StringBuffer fName = new StringBuffer();
            fName.append(basePath);
            if (!basePath.endsWith(File.separator)) {
                fName.append(File.separator);
            }
            if (fileName.startsWith("." + File.separator)) {
                fName.append(fileName.substring(2));
            } else {
                fName.append(fileName);
            }
            file = new File(fName.toString());
        }
        return file;
    }

    public static URL locate(String name) {
        return ConfigurationUtils.locate(null, name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static URL locate(String base, String name) {
        File file;
        if (name == null) {
            return null;
        }
        URL url = null;
        try {
            block20: {
                if (base == null) {
                    url = new URL(name);
                } else {
                    URL baseURL = new URL(base);
                    url = new URL(baseURL, name);
                    InputStream in = null;
                    try {
                        in = url.openStream();
                        Object var6_9 = null;
                        if (in == null) break block20;
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        if (in == null) throw throwable;
                        in.close();
                        throw throwable;
                    }
                    in.close();
                }
            }
            log.debug("Configuration loaded from the URL " + url);
        }
        catch (IOException e2) {
            url = null;
        }
        if (url == null && (file = new File(name)).isAbsolute() && file.exists()) {
            try {
                url = file.toURL();
                log.debug("Configuration loaded from the absolute path " + name);
            }
            catch (MalformedURLException e3) {
                e3.printStackTrace();
            }
        }
        if (url == null) {
            try {
                file = ConfigurationUtils.constructFile(base, name);
                if (file != null && file.exists()) {
                    url = file.toURL();
                }
                if (url != null) {
                    log.debug("Configuration loaded from the base path " + name);
                }
            }
            catch (IOException e4) {
                e4.printStackTrace();
            }
        }
        if (url == null) {
            try {
                file = ConfigurationUtils.constructFile(System.getProperty("user.home"), name);
                if (file != null && file.exists()) {
                    url = file.toURL();
                }
                if (url != null) {
                    log.debug("Configuration loaded from the home path " + name);
                }
            }
            catch (IOException e5) {
                e5.printStackTrace();
            }
        }
        if (url != null) return url;
        return ConfigurationUtils.locateFromClasspath(name);
    }

    static URL locateFromClasspath(String resourceName) {
        URL url = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null && (url = loader.getResource(resourceName)) != null) {
            log.debug("Configuration loaded from the context classpath (" + resourceName + ")");
        }
        if (url == null && (url = ClassLoader.getSystemResource(resourceName)) != null) {
            log.debug("Configuration loaded from the system classpath (" + resourceName + ")");
        }
        return url;
    }

    static String getBasePath(URL url) {
        if (url == null) {
            return null;
        }
        String s = url.toString();
        if (s.endsWith(RESOURCE_PATH_SEPARATOR) || StringUtils.isEmpty(url.getPath())) {
            return s;
        }
        return s.substring(0, s.lastIndexOf(RESOURCE_PATH_SEPARATOR) + 1);
    }

    static String getFileName(URL url) {
        if (url == null) {
            return null;
        }
        String path = url.getPath();
        if (path.endsWith(RESOURCE_PATH_SEPARATOR) || StringUtils.isEmpty(path)) {
            return null;
        }
        return path.substring(path.lastIndexOf(RESOURCE_PATH_SEPARATOR) + 1);
    }

    public static File getFile(String basePath, String fileName) {
        URL url;
        try {
            url = new URL(new URL(basePath), fileName);
        }
        catch (MalformedURLException mex1) {
            try {
                url = new URL(fileName);
            }
            catch (MalformedURLException mex2) {
                url = null;
            }
        }
        if (url != null) {
            return ConfigurationUtils.fileFromURL(url);
        }
        return ConfigurationUtils.constructFile(basePath, fileName);
    }

    public static File fileFromURL(URL url) {
        if (PROTOCOL_FILE.equals(url.getProtocol())) {
            return new File(URLDecoder.decode(url.getPath()));
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

