/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.session;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apitransport.session.AREncryptAPISessionNodeBase;
import com.bmc.arsys.apitransport.session.ARRpcKeyExchangeBase;
import com.bmc.arsys.apitransport.session.ARServerContext;
import com.bmc.arsys.apitransport.session.ApiRpcClientStubBase;
import com.bmc.arsys.apitransport.session.ArRpcCallContext;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARPublicKey;
import com.bmc.arsys.arrpc.ArControlStruct12;
import com.bmc.arsys.arrpc.ArGetServerInfo12In;
import com.bmc.arsys.arrpc.ArGetServerInfo12Out;
import com.bmc.arsys.arrpc.ArKeyExchangeBegin12In;
import com.bmc.arsys.arrpc.ArKeyExchangeBegin12Out;
import com.bmc.arsys.arrpc.ArKeyExchangeFinal12In;
import com.bmc.arsys.arrpc.ArKeyExchangeFinal12Out;
import com.bmc.arsys.arrpc.ArRandomBytes;
import com.bmc.arsys.arrpc.ArServerInfoList;
import com.bmc.arsys.arrpc.xdr.ArRpcControlStruct;
import com.bmc.arsys.arrpc.xdr.ArRpcXdrIn;
import com.bmc.arsys.arrpc.xdr.ArRpcXdrOut;
import com.bmc.arsys.utils.StringByteUtil;
import java.io.IOException;
import org.acplt.oncrpc.OncRpcException;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class ARKeyExchanger
extends ARRpcKeyExchangeBase {
    private transient ApiRpcClientStubBase int;
    private transient int for;
    protected transient ARPublicKey _svrPublicKey;
    private static Logger do = Logger.getLogger(ARKeyExchanger.class);

    protected ARKeyExchanger(ApiRpcClientStubBase apiRpcClientStubBase) {
        this.int = apiRpcClientStubBase;
        this.for = 2;
        this._svrPublicKey = new ARPublicKey();
    }

    @Override
    protected void keyExchangeHandler() throws OncRpcException, IOException, ARException, AREncryptionException {
        ArRpcControlStruct arRpcControlStruct = this.createRpcControlStruct();
        this.a(arRpcControlStruct);
        if (this.encryptionIsAllowed()) {
            this.int.getArRpcCallContext().setEncryptAPICalls(true);
            try {
                this.keyExchange(arRpcControlStruct);
            }
            catch (AREncryptionException aREncryptionException) {
                if (this.for == 0 && (aREncryptionException.getErrorNum() == 9010 || aREncryptionException.getErrorNum() == 9011)) {
                    this.int.getArRpcCallContext().setEncryptAPICalls(false);
                    String string = "";
                    ARServerContext aRServerContext = this.int.getArRpcCallContext().getServerContext();
                    if (aRServerContext != null) {
                        string = aRServerContext.getServer();
                    }
                    do.info("Error " + aREncryptionException.getErrorNum() + " turns off encrytion on the connection since Encrypt-Security-Policy is optional on server " + string);
                }
                throw aREncryptionException;
            }
        }
    }

    private void a(ArRpcControlStruct arRpcControlStruct) throws OncRpcException, ARException, AREncryptionException {
        ArRpcXdrIn arRpcXdrIn = this.createServerInfoIn(arRpcControlStruct);
        ArRpcXdrOut arRpcXdrOut = this.createServerInfoOut();
        ArRpcCallContext arRpcCallContext = this.int.getArRpcCallContext();
        arRpcCallContext.setSkipXdrEncryption(true);
        this.int.arCall(this.getProcNumEncryptInfo(), arRpcXdrIn, arRpcXdrOut);
        arRpcCallContext.setSkipXdrEncryption(false);
        ApiRpcClientStubBase.verifyStatus(arRpcXdrOut);
        String string = "";
        ARServerContext aRServerContext = arRpcCallContext.getServerContext();
        if (aRServerContext != null) {
            string = aRServerContext.getServer();
        }
        ArServerInfoList arServerInfoList = this.getServerInfoList(arRpcXdrOut);
        if (arServerInfoList.value.length > 0 && arServerInfoList.value[0].operation == 133) {
            this.for = arServerInfoList.value[0].value.intVal;
        }
        if (arServerInfoList.value.length > 1 && arServerInfoList.value[1].operation == 129) {
            this._svrPublicKey.setKey(arServerInfoList.value[1].value.byteListVal.bytes);
        }
        if (arServerInfoList.value.length > 2 && arServerInfoList.value[2].operation == 132) {
            arRpcCallContext.getEncCtx().setDataEncryptAlg(arServerInfoList.value[2].value.intVal, this.for, string);
        }
        if (this.for != 2 && arServerInfoList.value.length > 3 && arServerInfoList.value[3].operation == 168) {
            this._svrPublicKey.setAlgorithmParam(arServerInfoList.value[3].value.intVal);
        }
    }

    protected void keyExchange(ArRpcControlStruct arRpcControlStruct) throws ARException, AREncryptionException, OncRpcException, IOException {
        ArRpcCallContext arRpcCallContext = this.int.getArRpcCallContext();
        arRpcCallContext.setSkipXdrEncryption(true);
        this.keyExchangePrepare();
        this.keyExchangeBegin(arRpcControlStruct);
        this.keyExchangeFinal(arRpcControlStruct);
        arRpcCallContext.setSkipXdrEncryption(false);
    }

    protected void keyExchangePrepare() throws AREncryptionException {
        AREncryptAPISessionNodeBase aREncryptAPISessionNodeBase = this.int.getArRpcCallContext().getEncCtx();
        aREncryptAPISessionNodeBase.setClientRandBytes(StringByteUtil.generateRandomBytes(20));
        aREncryptAPISessionNodeBase.setPreMasterKey(StringByteUtil.generateRandomBytes(40));
    }

    protected boolean encryptionIsAllowed() {
        boolean bl = true;
        bl = this.for != 2;
        ARServerContext aRServerContext = this.int.getArRpcCallContext().getServerContext();
        if (aRServerContext != null) {
            aRServerContext.setEncryptionEnabled(bl);
        }
        return bl;
    }

    protected void keyExchangeBegin(ArRpcControlStruct arRpcControlStruct) throws ARException, OncRpcException {
        AREncryptAPISessionNodeBase aREncryptAPISessionNodeBase = this.int.getArRpcCallContext().getEncCtx();
        ArRpcXdrIn arRpcXdrIn = this.createKeyExchangeBeginIn(arRpcControlStruct, aREncryptAPISessionNodeBase);
        ArRpcXdrOut arRpcXdrOut = this.createKeyExchangeBeginOut();
        this.int.arCall(this.getProcNumKeyExchangeBegin(), arRpcXdrIn, arRpcXdrOut);
        ApiRpcClientStubBase.verifyStatus(arRpcXdrOut);
        this.setInEncCtx(aREncryptAPISessionNodeBase, arRpcXdrOut);
    }

    protected void keyExchangeFinal(ArRpcControlStruct arRpcControlStruct) throws AREncryptionException, ARException, OncRpcException, IOException {
        AREncryptAPISessionNodeBase aREncryptAPISessionNodeBase = this.int.getArRpcCallContext().getEncCtx();
        ArRpcXdrIn arRpcXdrIn = this.createKeyExchangeFinalIn(arRpcControlStruct, aREncryptAPISessionNodeBase);
        ArRpcXdrOut arRpcXdrOut = this.createKeyExchangeFinalOut();
        this.int.arCall(this.getProcNumKeyExchangeFinal(), arRpcXdrIn, arRpcXdrOut);
        ApiRpcClientStubBase.verifyStatus(arRpcXdrOut);
        aREncryptAPISessionNodeBase.getClintKeyInfo().genDataEncKeys(aREncryptAPISessionNodeBase.getDataEncRandomBytesObj());
        aREncryptAPISessionNodeBase.resetDataEncRandomBytesObj();
        int n2 = this.unxdrAndDecryptSessionId(aREncryptAPISessionNodeBase.getClintKeyInfo().getSvrDataKey(), this.getEncSessionId(arRpcXdrOut));
        do.debug("compare to org sessionId = " + aREncryptAPISessionNodeBase.getClintKeyInfo().getSessionId());
        if (aREncryptAPISessionNodeBase.getClintKeyInfo().getSessionId() != n2) {
            throw new ARException(2, 9002);
        }
        aREncryptAPISessionNodeBase.getClintKeyInfo().setSessionId(n2);
        aREncryptAPISessionNodeBase.setSessionId(n2);
    }

    protected ArRpcControlStruct createRpcControlStruct() {
        return new ArControlStruct12();
    }

    protected ArRpcXdrOut createServerInfoOut() {
        return new ArGetServerInfo12Out();
    }

    protected ArServerInfoList getServerInfoList(ArRpcXdrOut arRpcXdrOut) {
        return ((ArGetServerInfo12Out)arRpcXdrOut).getServerInfoList();
    }

    protected ArRpcXdrIn createServerInfoIn(ArRpcControlStruct arRpcControlStruct) {
        ArGetServerInfo12In arGetServerInfo12In = new ArGetServerInfo12In();
        arGetServerInfo12In.setControl((ArControlStruct12)arRpcControlStruct);
        arGetServerInfo12In.requestList.value = new int[4];
        arGetServerInfo12In.requestList.value[0] = 133;
        arGetServerInfo12In.requestList.value[1] = 129;
        arGetServerInfo12In.requestList.value[2] = 132;
        arGetServerInfo12In.requestList.value[3] = 168;
        return arGetServerInfo12In;
    }

    protected void setInEncCtx(AREncryptAPISessionNodeBase aREncryptAPISessionNodeBase, ArRpcXdrOut arRpcXdrOut) {
        aREncryptAPISessionNodeBase.setServerRandBytes(((ArKeyExchangeBegin12Out)arRpcXdrOut).serverRandBytes.value);
        aREncryptAPISessionNodeBase.getClintKeyInfo().setSessionId(((ArKeyExchangeBegin12Out)arRpcXdrOut).sessionId);
    }

    protected ArRpcXdrIn createKeyExchangeBeginIn(ArRpcControlStruct arRpcControlStruct, AREncryptAPISessionNodeBase aREncryptAPISessionNodeBase) {
        ArKeyExchangeBegin12In arKeyExchangeBegin12In = new ArKeyExchangeBegin12In();
        arKeyExchangeBegin12In.setControl((ArControlStruct12)arRpcControlStruct);
        arKeyExchangeBegin12In.clientRandBytes = new ArRandomBytes(aREncryptAPISessionNodeBase.getClientRandBytes());
        return arKeyExchangeBegin12In;
    }

    protected ArRpcXdrOut createKeyExchangeBeginOut() {
        return new ArKeyExchangeBegin12Out();
    }

    protected byte[] getEncSessionId(ArRpcXdrOut arRpcXdrOut) {
        return ((ArKeyExchangeFinal12Out)arRpcXdrOut).getEncSessionId();
    }

    protected ArRpcXdrOut createKeyExchangeFinalOut() {
        return new ArKeyExchangeFinal12Out();
    }

    protected ArRpcXdrIn createKeyExchangeFinalIn(ArRpcControlStruct arRpcControlStruct, AREncryptAPISessionNodeBase aREncryptAPISessionNodeBase) throws AREncryptionException, ARException, OncRpcException, IOException {
        ArKeyExchangeFinal12In arKeyExchangeFinal12In = new ArKeyExchangeFinal12In();
        arKeyExchangeFinal12In.control = (ArControlStruct12)arRpcControlStruct;
        arKeyExchangeFinal12In.sessionId = aREncryptAPISessionNodeBase.getClintKeyInfo().getSessionId();
        do.debug("sessionID before encryption = " + arKeyExchangeFinal12In.sessionId);
        byte[] byArray = this.xdrAndEncrypPreMasterKey(this._svrPublicKey, aREncryptAPISessionNodeBase.getPreMasterKey());
        arKeyExchangeFinal12In.setEncPreMasterKey(byArray);
        return arKeyExchangeFinal12In;
    }

    protected int getProcNumEncryptInfo() {
        return 97;
    }

    protected int getProcNumKeyExchangeBegin() {
        return 95;
    }

    protected int getProcNumKeyExchangeFinal() {
        return 96;
    }
}

