/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcException;

public abstract class XdrDecodingStream {
    private String characterEncoding = null;

    public abstract InetAddress getSenderAddress();

    public abstract int getSenderPort();

    public abstract void beginDecoding() throws OncRpcException, IOException;

    public void endDecoding() throws OncRpcException, IOException {
    }

    public void close() throws OncRpcException, IOException {
    }

    public abstract int xdrDecodeInt() throws OncRpcException, IOException;

    public abstract byte[] xdrDecodeOpaque(int var1) throws OncRpcException, IOException;

    public abstract void xdrDecodeOpaque(byte[] var1, int var2, int var3) throws OncRpcException, IOException;

    public final void xdrDecodeOpaque(byte[] byArray) throws OncRpcException, IOException {
        this.xdrDecodeOpaque(byArray, 0, byArray.length);
    }

    public final byte[] xdrDecodeDynamicOpaque() throws OncRpcException, IOException {
        int n = this.xdrDecodeInt();
        byte[] byArray = new byte[n];
        if (n != 0) {
            this.xdrDecodeOpaque(byArray);
        }
        return byArray;
    }

    public final byte[] xdrDecodeByteVector() throws OncRpcException, IOException {
        int n = this.xdrDecodeInt();
        if (n > 0) {
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = (byte)this.xdrDecodeInt();
            }
            return byArray;
        }
        return new byte[0];
    }

    public final byte[] xdrDecodeByteFixedVector(int n) throws OncRpcException, IOException {
        if (n > 0) {
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = (byte)this.xdrDecodeInt();
            }
            return byArray;
        }
        return new byte[0];
    }

    public final byte xdrDecodeByte() throws OncRpcException, IOException {
        return (byte)this.xdrDecodeInt();
    }

    public final short xdrDecodeShort() throws OncRpcException, IOException {
        return (short)this.xdrDecodeInt();
    }

    public final long xdrDecodeLong() throws OncRpcException, IOException {
        return ((long)this.xdrDecodeInt() << 32) + ((long)this.xdrDecodeInt() & 0xFFFFFFFFL);
    }

    public final float xdrDecodeFloat() throws OncRpcException, IOException {
        return Float.intBitsToFloat(this.xdrDecodeInt());
    }

    public final double xdrDecodeDouble() throws OncRpcException, IOException {
        return Double.longBitsToDouble(this.xdrDecodeLong());
    }

    public final boolean xdrDecodeBoolean() throws OncRpcException, IOException {
        return this.xdrDecodeInt() != 0;
    }

    public String xdrDecodeString() throws OncRpcException, IOException {
        int n = this.xdrDecodeInt();
        if (n > 0) {
            byte[] byArray = new byte[n];
            this.xdrDecodeOpaque(byArray, 0, n);
            return this.characterEncoding != null ? new String(byArray, this.characterEncoding) : new String(byArray);
        }
        return new String();
    }

    public final short[] xdrDecodeShortVector() throws OncRpcException, IOException {
        int n = this.xdrDecodeInt();
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = this.xdrDecodeShort();
        }
        return sArray;
    }

    public final short[] xdrDecodeShortFixedVector(int n) throws OncRpcException, IOException {
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = this.xdrDecodeShort();
        }
        return sArray;
    }

    public final int[] xdrDecodeIntVector() throws OncRpcException, IOException {
        int n = this.xdrDecodeInt();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.xdrDecodeInt();
        }
        return nArray;
    }

    public final int[] xdrDecodeIntFixedVector(int n) throws OncRpcException, IOException {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.xdrDecodeInt();
        }
        return nArray;
    }

    public final long[] xdrDecodeLongVector() throws OncRpcException, IOException {
        int n = this.xdrDecodeInt();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.xdrDecodeLong();
        }
        return lArray;
    }

    public final long[] xdrDecodeLongFixedVector(int n) throws OncRpcException, IOException {
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.xdrDecodeLong();
        }
        return lArray;
    }

    public final float[] xdrDecodeFloatVector() throws OncRpcException, IOException {
        int n = this.xdrDecodeInt();
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = this.xdrDecodeFloat();
        }
        return fArray;
    }

    public final float[] xdrDecodeFloatFixedVector(int n) throws OncRpcException, IOException {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = this.xdrDecodeFloat();
        }
        return fArray;
    }

    public final double[] xdrDecodeDoubleVector() throws OncRpcException, IOException {
        int n = this.xdrDecodeInt();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.xdrDecodeDouble();
        }
        return dArray;
    }

    public final double[] xdrDecodeDoubleFixedVector(int n) throws OncRpcException, IOException {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.xdrDecodeDouble();
        }
        return dArray;
    }

    public final boolean[] xdrDecodeBooleanVector() throws OncRpcException, IOException {
        int n = this.xdrDecodeInt();
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = this.xdrDecodeBoolean();
        }
        return blArray;
    }

    public final boolean[] xdrDecodeBooleanFixedVector(int n) throws OncRpcException, IOException {
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = this.xdrDecodeBoolean();
        }
        return blArray;
    }

    public final String[] xdrDecodeStringVector() throws OncRpcException, IOException {
        int n = this.xdrDecodeInt();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.xdrDecodeString();
        }
        return stringArray;
    }

    public final String[] xdrDecodeStringFixedVector(int n) throws OncRpcException, IOException {
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.xdrDecodeString();
        }
        return stringArray;
    }

    public void setCharacterEncoding(String string) {
        this.characterEncoding = string;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }
}

