/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.scripting.bsh;

import bsh.EvalError;
import com.bmc.thirdparty.org.springframework.scripting.ScriptCompilationException;
import com.bmc.thirdparty.org.springframework.scripting.ScriptFactory;
import com.bmc.thirdparty.org.springframework.scripting.ScriptSource;
import com.bmc.thirdparty.org.springframework.scripting.bsh.BshScriptUtils;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.io.IOException;

public class BshScriptFactory
implements ScriptFactory {
    private final String scriptSourceLocator;
    private final Class[] scriptInterfaces;

    public BshScriptFactory(String scriptSourceLocator, Class[] scriptInterfaces) {
        Assert.hasText(scriptSourceLocator);
        Assert.notEmpty(scriptInterfaces);
        this.scriptSourceLocator = scriptSourceLocator;
        this.scriptInterfaces = scriptInterfaces;
    }

    public String getScriptSourceLocator() {
        return this.scriptSourceLocator;
    }

    public Class[] getScriptInterfaces() {
        return this.scriptInterfaces;
    }

    public boolean requiresConfigInterface() {
        return true;
    }

    public Object getScriptedObject(ScriptSource actualScriptSource, Class[] actualInterfaces) throws IOException, ScriptCompilationException {
        try {
            return BshScriptUtils.createBshObject(actualScriptSource.getScriptAsString(), actualInterfaces);
        }
        catch (EvalError ex) {
            throw new ScriptCompilationException("Could not compile BeanShell script: " + actualScriptSource, ex);
        }
    }
}

