/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans.factory.support;

import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.beans.MutablePropertyValues;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanDefinitionStoreException;
import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanDefinitionHolder;
import com.bmc.thirdparty.org.springframework.beans.factory.config.ConstructorArgumentValues;
import com.bmc.thirdparty.org.springframework.beans.factory.support.AbstractBeanDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.support.BeanDefinitionRegistry;
import com.bmc.thirdparty.org.springframework.beans.factory.support.ChildBeanDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.support.RootBeanDefinition;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import com.bmc.thirdparty.org.springframework.util.ObjectUtils;
import com.bmc.thirdparty.org.springframework.util.StringUtils;

public class BeanDefinitionReaderUtils {
    public static final String GENERATED_BEAN_NAME_SEPARATOR = "#";

    public static AbstractBeanDefinition createBeanDefinition(String className, String parent, ConstructorArgumentValues cargs, MutablePropertyValues pvs, ClassLoader classLoader) throws ClassNotFoundException {
        AbstractBeanDefinition bd = BeanDefinitionReaderUtils.createBeanDefinition(parent, className, classLoader);
        bd.setConstructorArgumentValues(cargs);
        bd.setPropertyValues(pvs);
        return bd;
    }

    public static AbstractBeanDefinition createBeanDefinition(String parent, String className, ClassLoader classLoader) throws ClassNotFoundException {
        AbstractBeanDefinition bd = null;
        bd = parent != null ? new ChildBeanDefinition(parent) : new RootBeanDefinition();
        if (className != null) {
            if (classLoader != null) {
                bd.setBeanClass(ClassUtils.forName(className, classLoader));
            } else {
                bd.setBeanClassName(className);
            }
        }
        return bd;
    }

    public static String generateBeanName(AbstractBeanDefinition beanDefinition, BeanDefinitionRegistry beanFactory, boolean isInnerBean) throws BeanDefinitionStoreException {
        String generatedId = beanDefinition.getBeanClassName();
        if (generatedId == null) {
            if (beanDefinition instanceof ChildBeanDefinition) {
                generatedId = ((ChildBeanDefinition)beanDefinition).getParentName() + "$child";
            } else if (beanDefinition.getFactoryBeanName() != null) {
                generatedId = beanDefinition.getFactoryBeanName() + "$created";
            }
        }
        if (!StringUtils.hasText(generatedId)) {
            throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), "", "Unnamed bean definition specifies neither 'class' nor 'parent' nor 'factory-bean' - can't generate bean name");
        }
        String id = generatedId;
        if (isInnerBean) {
            id = generatedId + GENERATED_BEAN_NAME_SEPARATOR + ObjectUtils.getIdentityHexString(beanDefinition);
        } else {
            int counter = 0;
            while (beanFactory.containsBeanDefinition(id)) {
                id = generatedId + GENERATED_BEAN_NAME_SEPARATOR + ++counter;
            }
        }
        return id;
    }

    public static String generateBeanName(AbstractBeanDefinition beanDefinition, BeanDefinitionRegistry beanFactory) throws BeanDefinitionStoreException {
        return BeanDefinitionReaderUtils.generateBeanName(beanDefinition, beanFactory, false);
    }

    public static void registerBeanDefinition(BeanDefinitionHolder bdHolder, BeanDefinitionRegistry beanFactory) throws BeansException {
        String beanName = bdHolder.getBeanName();
        beanFactory.registerBeanDefinition(beanName, bdHolder.getBeanDefinition());
        String[] aliases = bdHolder.getAliases();
        if (aliases != null) {
            for (int i2 = 0; i2 < aliases.length; ++i2) {
                beanFactory.registerAlias(beanName, aliases[i2]);
            }
        }
    }

    public static String registerWithGeneratedName(AbstractBeanDefinition beanDefinition, BeanDefinitionRegistry beanFactory) throws BeanDefinitionStoreException {
        String generatedName = BeanDefinitionReaderUtils.generateBeanName(beanDefinition, beanFactory, false);
        beanFactory.registerBeanDefinition(generatedName, beanDefinition);
        return generatedName;
    }
}

