/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.beanutils;

import com.bmc.thirdparty.org.apache.commons.beanutils.PropertyUtils;
import com.bmc.thirdparty.org.apache.commons.collections.Predicate;
import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import java.lang.reflect.InvocationTargetException;

public class BeanPredicate
implements Predicate {
    private final Log log = LogFactory.getLog(this.getClass());
    private String propertyName;
    private Predicate predicate;

    public BeanPredicate(String propertyName, Predicate predicate) {
        this.propertyName = propertyName;
        this.predicate = predicate;
    }

    public boolean evaluate(Object object) {
        boolean evaluation = false;
        try {
            Object propValue = PropertyUtils.getProperty(object, this.propertyName);
            evaluation = this.predicate.evaluate(propValue);
        }
        catch (IllegalArgumentException e2) {
            String errorMsg = "Problem during evaluation.";
            this.log.error("ERROR: Problem during evaluation.", e2);
            throw e2;
        }
        catch (IllegalAccessException e3) {
            String errorMsg = "Unable to access the property provided.";
            this.log.error("Unable to access the property provided.", e3);
            throw new IllegalArgumentException("Unable to access the property provided.");
        }
        catch (InvocationTargetException e4) {
            String errorMsg = "Exception occurred in property's getter";
            this.log.error("Exception occurred in property's getter", e4);
            throw new IllegalArgumentException("Exception occurred in property's getter");
        }
        catch (NoSuchMethodException e5) {
            String errorMsg = "Property not found.";
            this.log.error("Property not found.", e5);
            throw new IllegalArgumentException("Property not found.");
        }
        return evaluation;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public void setPredicate(Predicate predicate) {
        this.predicate = predicate;
    }
}

