/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.commons.collections.iterators.SingletonIterator;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

public final class PropertyConverter {
    static final String LIST_ESCAPE = "\\";
    private static final String HEX_PREFIX = "0x";
    private static final int HEX_RADIX = 16;
    private static final Class[] CONSTR_ARGS = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PropertyConverter.class$("java.lang.String")) : class$java$lang$String};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;

    private PropertyConverter() {
    }

    public static Boolean toBoolean(Object value) throws ConversionException {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            Boolean b = BooleanUtils.toBooleanObject((String)((String)value));
            if (b == null) {
                throw new ConversionException("The value " + value + " can't be converted to a Boolean object");
            }
            return b;
        }
        throw new ConversionException("The value " + value + " can't be converted to a Boolean object");
    }

    public static Byte toByte(Object value) throws ConversionException {
        Number n = PropertyConverter.toNumber(value, class$java$lang$Byte == null ? (class$java$lang$Byte = PropertyConverter.class$("java.lang.Byte")) : class$java$lang$Byte);
        if (n instanceof Byte) {
            return (Byte)n;
        }
        return new Byte(n.byteValue());
    }

    public static Short toShort(Object value) throws ConversionException {
        Number n = PropertyConverter.toNumber(value, class$java$lang$Short == null ? (class$java$lang$Short = PropertyConverter.class$("java.lang.Short")) : class$java$lang$Short);
        if (n instanceof Short) {
            return (Short)n;
        }
        return new Short(n.shortValue());
    }

    public static Integer toInteger(Object value) throws ConversionException {
        Number n = PropertyConverter.toNumber(value, class$java$lang$Integer == null ? (class$java$lang$Integer = PropertyConverter.class$("java.lang.Integer")) : class$java$lang$Integer);
        if (n instanceof Integer) {
            return (Integer)n;
        }
        return new Integer(n.intValue());
    }

    public static Long toLong(Object value) throws ConversionException {
        Number n = PropertyConverter.toNumber(value, class$java$lang$Long == null ? (class$java$lang$Long = PropertyConverter.class$("java.lang.Long")) : class$java$lang$Long);
        if (n instanceof Long) {
            return (Long)n;
        }
        return new Long(n.longValue());
    }

    public static Float toFloat(Object value) throws ConversionException {
        Number n = PropertyConverter.toNumber(value, class$java$lang$Float == null ? (class$java$lang$Float = PropertyConverter.class$("java.lang.Float")) : class$java$lang$Float);
        if (n instanceof Float) {
            return (Float)n;
        }
        return new Float(n.floatValue());
    }

    public static Double toDouble(Object value) throws ConversionException {
        Number n = PropertyConverter.toNumber(value, class$java$lang$Double == null ? (class$java$lang$Double = PropertyConverter.class$("java.lang.Double")) : class$java$lang$Double);
        if (n instanceof Double) {
            return (Double)n;
        }
        return new Double(n.doubleValue());
    }

    public static BigInteger toBigInteger(Object value) throws ConversionException {
        Number n = PropertyConverter.toNumber(value, class$java$math$BigInteger == null ? (class$java$math$BigInteger = PropertyConverter.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        if (n instanceof BigInteger) {
            return (BigInteger)n;
        }
        return BigInteger.valueOf(n.longValue());
    }

    public static BigDecimal toBigDecimal(Object value) throws ConversionException {
        Number n = PropertyConverter.toNumber(value, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = PropertyConverter.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        return new BigDecimal(n.doubleValue());
    }

    static Number toNumber(Object value, Class targetClass) throws ConversionException {
        if (value instanceof Number) {
            return (Number)value;
        }
        String str = value.toString();
        if (str.startsWith(HEX_PREFIX)) {
            try {
                return new BigInteger(str.substring(HEX_PREFIX.length()), 16);
            }
            catch (NumberFormatException nex) {
                throw new ConversionException("Could not convert " + str + " to " + targetClass.getName() + "! Invalid hex number.", nex);
            }
        }
        try {
            Constructor constr = targetClass.getConstructor(CONSTR_ARGS);
            return (Number)constr.newInstance(str);
        }
        catch (InvocationTargetException itex) {
            throw new ConversionException("Could not convert " + str + " to " + targetClass.getName(), itex.getTargetException());
        }
        catch (Exception ex) {
            throw new ConversionException("Conversion error when trying to convert " + str + " to " + targetClass.getName(), ex);
        }
    }

    public static URL toURL(Object value) throws ConversionException {
        if (value instanceof URL) {
            return (URL)value;
        }
        if (value instanceof String) {
            try {
                return new URL((String)value);
            }
            catch (MalformedURLException e) {
                throw new ConversionException("The value " + value + " can't be converted to an URL", e);
            }
        }
        throw new ConversionException("The value " + value + " can't be converted to an URL");
    }

    public static Locale toLocale(Object value) throws ConversionException {
        if (value instanceof Locale) {
            return (Locale)value;
        }
        if (value instanceof String) {
            List elements = PropertyConverter.split((String)value, '_');
            int size = elements.size();
            if (size >= 1 && (((String)elements.get(0)).length() == 2 || ((String)elements.get(0)).length() == 0)) {
                String language = (String)elements.get(0);
                String country = size >= 2 ? elements.get(1) : "";
                String variant = size >= 3 ? elements.get(2) : "";
                return new Locale(language, country, variant);
            }
            throw new ConversionException("The value " + value + " can't be converted to a Locale");
        }
        throw new ConversionException("The value " + value + " can't be converted to a Locale");
    }

    public static List split(String s, char delimiter) {
        if (s == null) {
            return new ArrayList();
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer token = new StringBuffer();
        int begin = 0;
        int end = 0;
        while (begin <= s.length()) {
            int index = s.indexOf(delimiter, end);
            String chunk = s.substring(begin, end = index != -1 ? index : s.length());
            if (chunk.endsWith(LIST_ESCAPE) && end != s.length()) {
                token.append(chunk.substring(0, chunk.length() - 1));
                token.append(delimiter);
            } else {
                token.append(chunk);
                list.add(token.toString().trim());
                token = new StringBuffer();
            }
            begin = ++end;
        }
        return list;
    }

    public static String escapeDelimiters(String s, char delimiter) {
        return StringUtils.replace((String)s, (String)String.valueOf(delimiter), (String)(LIST_ESCAPE + delimiter));
    }

    public static Color toColor(Object value) throws ConversionException {
        if (value instanceof Color) {
            return (Color)value;
        }
        if (value instanceof String && !StringUtils.isBlank((String)((String)value))) {
            String color = ((String)value).trim();
            int[] components = new int[3];
            int minlength = components.length * 2;
            if (color.length() < minlength) {
                throw new ConversionException("The value " + value + " can't be converted to a Color");
            }
            if (color.startsWith("#")) {
                color = color.substring(1);
            }
            try {
                int i = 0;
                while (i < components.length) {
                    components[i] = Integer.parseInt(color.substring(2 * i, 2 * i + 2), 16);
                    ++i;
                }
                int alpha = color.length() >= minlength + 2 ? Integer.parseInt(color.substring(minlength, minlength + 2), 16) : Color.black.getAlpha();
                return new Color(components[0], components[1], components[2], alpha);
            }
            catch (Exception e) {
                throw new ConversionException("The value " + value + " can't be converted to a Color", e);
            }
        }
        throw new ConversionException("The value " + value + " can't be converted to a Color");
    }

    public static Date toDate(Object value, String format) throws ConversionException {
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        if (value instanceof String) {
            try {
                return new SimpleDateFormat(format).parse((String)value);
            }
            catch (ParseException e) {
                throw new ConversionException("The value " + value + " can't be converted to a Date", e);
            }
        }
        throw new ConversionException("The value " + value + " can't be converted to a Date");
    }

    public static Calendar toCalendar(Object value, String format) throws ConversionException {
        if (value instanceof Calendar) {
            return (Calendar)value;
        }
        if (value instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)value);
            return calendar;
        }
        if (value instanceof String) {
            try {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new SimpleDateFormat(format).parse((String)value));
                return calendar;
            }
            catch (ParseException e) {
                throw new ConversionException("The value " + value + " can't be converted to a Calendar", e);
            }
        }
        throw new ConversionException("The value " + value + " can't be converted to a Calendar");
    }

    public static Iterator toIterator(Object value, char delimiter) {
        if (value == null) {
            return IteratorUtils.emptyIterator();
        }
        if (value instanceof String) {
            String s = (String)value;
            if (s.indexOf(delimiter) > 0) {
                return PropertyConverter.split((String)value, delimiter).iterator();
            }
            return new SingletonIterator(value);
        }
        if (value instanceof Collection) {
            return PropertyConverter.toIterator(((Collection)value).iterator(), delimiter);
        }
        if (value.getClass().isArray()) {
            return PropertyConverter.toIterator(IteratorUtils.arrayIterator((Object)value), delimiter);
        }
        if (value instanceof Iterator) {
            Iterator iterator = (Iterator)value;
            IteratorChain chain = new IteratorChain();
            while (iterator.hasNext()) {
                chain.addIterator(PropertyConverter.toIterator(iterator.next(), delimiter));
            }
            return chain;
        }
        return new SingletonIterator(value);
    }

    public static Object interpolate(Object value, AbstractConfiguration config) {
        if (value instanceof String) {
            return PropertyConverter.interpolateHelper((String)value, null, config);
        }
        return value;
    }

    private static String interpolateHelper(String base, List priorVariables, AbstractConfiguration config) {
        if (base == null) {
            return null;
        }
        if (priorVariables == null) {
            priorVariables = new ArrayList<String>();
            priorVariables.add(base);
        }
        int begin = -1;
        int end = -1;
        int prec = 0 - "}".length();
        StringBuffer result = new StringBuffer();
        while ((begin = base.indexOf("${", prec + "}".length())) > -1 && (end = base.indexOf("}", begin)) > -1) {
            result.append(base.substring(prec + "}".length(), begin));
            String variable = base.substring(begin + "${".length(), end);
            if (priorVariables.contains(variable)) {
                String initialBase = priorVariables.remove(0).toString();
                priorVariables.add(variable);
                StringBuffer priorVariableSb = new StringBuffer();
                Iterator it = priorVariables.iterator();
                while (it.hasNext()) {
                    priorVariableSb.append(it.next());
                    if (!it.hasNext()) continue;
                    priorVariableSb.append("->");
                }
                throw new IllegalStateException("infinite loop in property interpolation of " + initialBase + ": " + priorVariableSb.toString());
            }
            priorVariables.add(variable);
            Object value = config.resolveContainerStore(variable);
            if (value != null) {
                result.append(PropertyConverter.interpolateHelper(value.toString(), priorVariables, config));
                priorVariables.remove(priorVariables.size() - 1);
            } else {
                result.append("${");
                result.append(variable);
                result.append("}");
            }
            prec = end;
        }
        result.append(base.substring(prec + "}".length(), base.length()));
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

