/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.struts;

import com.bmc.thirdparty.org.apache.commons.beanutils.BeanUtilsBean;
import com.bmc.thirdparty.org.apache.commons.beanutils.ConvertUtilsBean;
import com.bmc.thirdparty.org.apache.commons.beanutils.PropertyUtilsBean;
import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.context.MessageSourceResolvable;
import com.bmc.thirdparty.org.springframework.validation.Errors;
import com.bmc.thirdparty.org.springframework.validation.FieldError;
import com.bmc.thirdparty.org.springframework.validation.ObjectError;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;

public class SpringBindingActionForm
extends ActionForm {
    private static final Log logger = LogFactory.getLog(class$org$springframework$web$struts$SpringBindingActionForm == null ? (class$org$springframework$web$struts$SpringBindingActionForm = SpringBindingActionForm.class$("com.bmc.thirdparty.org.springframework.web.struts.SpringBindingActionForm")) : class$org$springframework$web$struts$SpringBindingActionForm);
    private static boolean defaultActionMessageAvailable = true;
    private Errors errors;
    private Locale locale;
    private MessageResources messageResources;
    static /* synthetic */ Class class$org$springframework$web$struts$SpringBindingActionForm;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$struts$action$ActionMessage;

    public void expose(Errors errors, HttpServletRequest request) {
        this.errors = errors;
        this.locale = (Locale)request.getSession().getAttribute("org.apache.struts.action.LOCALE");
        this.messageResources = (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
        if (errors != null && errors.hasErrors()) {
            ActionMessages actionMessages = (ActionMessages)request.getAttribute("org.apache.struts.action.ERROR");
            if (actionMessages == null) {
                request.setAttribute("org.apache.struts.action.ERROR", (Object)this.getActionMessages());
            } else {
                actionMessages.add(this.getActionMessages());
            }
        }
    }

    private ActionMessages getActionMessages() {
        ActionMessages actionMessages = new ActionMessages();
        Iterator it = this.errors.getAllErrors().iterator();
        while (it.hasNext()) {
            ActionMessage message;
            ObjectError objectError = (ObjectError)it.next();
            String effectiveMessageKey = this.findEffectiveMessageKey(objectError);
            if (effectiveMessageKey == null && !defaultActionMessageAvailable) {
                effectiveMessageKey = objectError.getCode();
            }
            ActionMessage actionMessage = message = effectiveMessageKey != null ? new ActionMessage(effectiveMessageKey, this.resolveArguments(objectError.getArguments())) : new ActionMessage(objectError.getDefaultMessage(), false);
            if (objectError instanceof FieldError) {
                FieldError fieldError = (FieldError)objectError;
                actionMessages.add(fieldError.getField(), message);
                continue;
            }
            actionMessages.add("org.apache.struts.action.GLOBAL_MESSAGE", message);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Final ActionMessages used for binding: " + actionMessages);
        }
        return actionMessages;
    }

    private Object[] resolveArguments(Object[] arguments) {
        if (arguments == null || arguments.length == 0) {
            return arguments;
        }
        for (int i2 = 0; i2 < arguments.length; ++i2) {
            Object arg = arguments[i2];
            if (!(arg instanceof MessageSourceResolvable)) continue;
            MessageSourceResolvable resolvable = (MessageSourceResolvable)arg;
            String[] codes = resolvable.getCodes();
            boolean resolved = false;
            if (this.messageResources != null) {
                for (int j2 = 0; j2 < codes.length; ++j2) {
                    String code = codes[j2];
                    if (!this.messageResources.isPresent(this.locale, code)) continue;
                    arguments[i2] = this.messageResources.getMessage(this.locale, code, this.resolveArguments(resolvable.getArguments()));
                    resolved = true;
                    break;
                }
            }
            if (resolved) continue;
            arguments[i2] = resolvable.getDefaultMessage();
        }
        return arguments;
    }

    private String findEffectiveMessageKey(ObjectError error) {
        if (this.messageResources != null) {
            String[] possibleMatches = error.getCodes();
            for (int i2 = 0; i2 < possibleMatches.length; ++i2) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Looking for error code '" + possibleMatches[i2] + "'");
                }
                if (!this.messageResources.isPresent(this.locale, possibleMatches[i2])) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Found error code '" + possibleMatches[i2] + "' in resource bundle");
                }
                return possibleMatches[i2];
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Could not find a suitable message error code, returning default message");
        }
        return null;
    }

    private Object getFieldValue(String propertyPath) throws NoSuchMethodException {
        if (this.errors == null) {
            throw new NoSuchMethodException("No bean properties exposed to Struts binding - performing Spring binding later on");
        }
        return this.errors.getFieldValue(propertyPath);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ConvertUtilsBean convUtils = new ConvertUtilsBean();
        SpringBindingAwarePropertyUtilsBean propUtils = new SpringBindingAwarePropertyUtilsBean();
        BeanUtilsBean beanUtils = new BeanUtilsBean(convUtils, propUtils);
        BeanUtilsBean.setInstance(beanUtils);
        try {
            (class$org$apache$struts$action$ActionMessage == null ? (class$org$apache$struts$action$ActionMessage = SpringBindingActionForm.class$("org.apache.struts.action.ActionMessage")) : class$org$apache$struts$action$ActionMessage).getConstructor(class$java$lang$String == null ? (class$java$lang$String = SpringBindingActionForm.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE);
        }
        catch (NoSuchMethodException ex) {
            defaultActionMessageAvailable = false;
        }
    }

    private static class SpringBindingAwarePropertyUtilsBean
    extends PropertyUtilsBean {
        private SpringBindingAwarePropertyUtilsBean() {
        }

        public Object getNestedProperty(Object bean, String propertyPath) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            if (bean instanceof SpringBindingActionForm) {
                SpringBindingActionForm form = (SpringBindingActionForm)((Object)bean);
                return form.getFieldValue(propertyPath);
            }
            return super.getNestedProperty(bean, propertyPath);
        }
    }
}

