/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jms.connection;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.DisposableBean;
import com.bmc.thirdparty.org.springframework.beans.factory.InitializingBean;
import com.bmc.thirdparty.org.springframework.jms.connection.ChainedExceptionListener;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;

public class SingleConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
ExceptionListener,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ConnectionFactory targetConnectionFactory;
    private String clientId;
    private ExceptionListener exceptionListener;
    private boolean reconnectOnException = false;
    private Connection target;
    private Connection connection;
    private final Object connectionMonitor = new Object();
    static /* synthetic */ Class class$javax$jms$Connection;
    static /* synthetic */ Class class$javax$jms$QueueConnection;
    static /* synthetic */ Class class$javax$jms$TopicConnection;

    public SingleConnectionFactory() {
    }

    public SingleConnectionFactory(Connection target) {
        Assert.notNull(target, "Target Connection must not be null");
        this.target = target;
        this.connection = this.getSharedConnectionProxy(target);
    }

    public SingleConnectionFactory(ConnectionFactory targetConnectionFactory) {
        Assert.notNull(targetConnectionFactory, "Target ConnectionFactory must not be null");
        this.targetConnectionFactory = targetConnectionFactory;
    }

    public void setTargetConnectionFactory(ConnectionFactory targetConnectionFactory) {
        this.targetConnectionFactory = targetConnectionFactory;
    }

    public ConnectionFactory getTargetConnectionFactory() {
        return this.targetConnectionFactory;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    protected String getClientId() {
        return this.clientId;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    protected ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setReconnectOnException(boolean reconnectOnException) {
        this.reconnectOnException = reconnectOnException;
    }

    protected boolean isReconnectOnException() {
        return this.reconnectOnException;
    }

    public void afterPropertiesSet() {
        if (this.connection == null && this.getTargetConnectionFactory() == null) {
            throw new IllegalArgumentException("Connection or targetConnectionFactory is required");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection createConnection() throws JMSException {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.connection == null) {
                this.initConnection();
            }
            return this.connection;
        }
    }

    public Connection createConnection(String username, String password) throws JMSException {
        throw new IllegalStateException("SingleConnectionFactory does not support custom username and password");
    }

    public QueueConnection createQueueConnection() throws JMSException {
        Connection con = this.createConnection();
        if (!(con instanceof QueueConnection)) {
            throw new IllegalStateException("This SingleConnectionFactory does not hold a QueueConnection but rather: " + con);
        }
        return (QueueConnection)con;
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        throw new IllegalStateException("SingleConnectionFactory does not support custom username and password");
    }

    public TopicConnection createTopicConnection() throws JMSException {
        Connection con = this.createConnection();
        if (!(con instanceof TopicConnection)) {
            throw new IllegalStateException("This SingleConnectionFactory does not hold a TopicConnection but rather: " + con);
        }
        return (TopicConnection)con;
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        throw new IllegalStateException("SingleConnectionFactory does not support custom username and password");
    }

    public void onException(JMSException ex) {
        this.resetConnection();
    }

    public void destroy() {
        this.resetConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initConnection() throws JMSException {
        if (this.getTargetConnectionFactory() == null) {
            throw new java.lang.IllegalStateException("targetConnectionFactory is required for lazily initializing a Connection");
        }
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.target != null) {
                this.closeConnection(this.target);
            }
            this.target = this.doCreateConnection();
            this.prepareConnection(this.target);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Established shared JMS Connection: " + this.target);
            }
            this.connection = this.getSharedConnectionProxy(this.target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetConnection() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.target != null) {
                this.closeConnection(this.target);
            }
            this.target = null;
            this.connection = null;
        }
    }

    protected Connection doCreateConnection() throws JMSException {
        return this.getTargetConnectionFactory().createConnection();
    }

    protected void prepareConnection(Connection con) throws JMSException {
        if (this.getExceptionListener() != null || this.isReconnectOnException()) {
            ExceptionListener listenerToUse = this.getExceptionListener();
            if (this.isReconnectOnException()) {
                listenerToUse = new InternalChainedExceptionListener(this, listenerToUse);
            }
            con.setExceptionListener(listenerToUse);
        }
        if (this.getClientId() != null) {
            con.setClientID(this.getClientId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection(Connection con) {
        try {
            try {
                con.stop();
            }
            finally {
                con.close();
            }
        }
        catch (Throwable ex) {
            this.logger.warn("Could not close shared JMS Connection", ex);
        }
    }

    protected Connection getSharedConnectionProxy(Connection target) {
        ArrayList<Class> classes = new ArrayList<Class>(3);
        classes.add(class$javax$jms$Connection == null ? (class$javax$jms$Connection = SingleConnectionFactory.class$("javax.jms.Connection")) : class$javax$jms$Connection);
        if (target instanceof QueueConnection) {
            classes.add(class$javax$jms$QueueConnection == null ? (class$javax$jms$QueueConnection = SingleConnectionFactory.class$("javax.jms.QueueConnection")) : class$javax$jms$QueueConnection);
        }
        if (target instanceof TopicConnection) {
            classes.add(class$javax$jms$TopicConnection == null ? (class$javax$jms$TopicConnection = SingleConnectionFactory.class$("javax.jms.TopicConnection")) : class$javax$jms$TopicConnection);
        }
        return (Connection)Proxy.newProxyInstance((class$javax$jms$Connection == null ? (class$javax$jms$Connection = SingleConnectionFactory.class$("javax.jms.Connection")) : class$javax$jms$Connection).getClassLoader(), classes.toArray(new Class[classes.size()]), (InvocationHandler)new SharedConnectionInvocationHandler(target));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class InternalChainedExceptionListener
    extends ChainedExceptionListener {
        public InternalChainedExceptionListener(ExceptionListener internalListener, ExceptionListener userListener) {
            this.addDelegate(internalListener);
            if (userListener != null) {
                this.addDelegate(userListener);
            }
        }

        public ExceptionListener getUserListener() {
            ExceptionListener[] delegates = this.getDelegates();
            return delegates.length > 1 ? delegates[1] : null;
        }
    }

    private static class SharedConnectionInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        private SharedConnectionInvocationHandler(Connection target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("setExceptionListener")) {
                throw new IllegalStateException("setExceptionListener call not supported on proxy for shared Connection. Set the 'exceptionListener' property on the SingleConnectionFactory instead.");
            }
            if (method.getName().equals("setClientID")) {
                throw new IllegalStateException("setClientID call not supported on proxy for shared Connection. Set the 'clientId' property on the SingleConnectionFactory instead.");
            }
            if (method.getName().equals("stop")) {
                return null;
            }
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                Object retVal = method.invoke((Object)this.target, args);
                if (method.getName().equals("getExceptionListener") && retVal instanceof InternalChainedExceptionListener) {
                    InternalChainedExceptionListener listener = (InternalChainedExceptionListener)retVal;
                    return listener.getUserListener();
                }
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

