/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.common;

import com.bmc.arsys.common.CommonErrors;
import com.bmc.arsys.common.LoggerHelper;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class SignalLockFileHelper {
    private static final Locale defLocale = Locale.getDefault();
    private static final String emptyString = "";
    private static final String dateFormatPat = "EEE MMM dd HH:mm:ss yyyy";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", defLocale);
    private static final String pidLineMsg = "started {0} by pid {1}";
    public static final String READ_WRITE_MODE = "rw";
    private String lockFileFullName;
    private RandomAccessFile lockFile;
    private FileLock lock;
    private LoggerHelper loggerHelper;
    private Logger logger;
    private boolean debugMode;

    public SignalLockFileHelper(String string, LoggerHelper loggerHelper, Logger logger, boolean bl) {
        this.lockFileFullName = string;
        this.loggerHelper = loggerHelper;
        this.logger = logger;
        this.debugMode = bl;
    }

    public SignalLockFileHelper(String string, LoggerHelper loggerHelper, Logger logger) {
        this(string, loggerHelper, logger, true);
    }

    public int checkForMultipleServers(String string) {
        if (this.lockFileFullName == null || string == null) {
            return -1;
        }
        try {
            this.lockFile = new RandomAccessFile(this.lockFileFullName, READ_WRITE_MODE);
            this.lock = this.lockFile.getChannel().tryLock();
            if (this.lock == null || !this.lock.isValid()) {
                String string2 = null;
                try {
                    string2 = this.lockFile.readLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.loggerHelper != null && this.logger != null) {
                    Object[] objectArray = new Object[]{string2 != null ? string2 : emptyString};
                    this.loggerHelper.logFormattedErrorMessage(this.debugMode, this.logger, CommonErrors.AR_MSG_SET.toDefMsg(), CommonErrors.ARDS_ERROR_DUPLICATE_SERVER.toIntValue(), objectArray, CommonErrors.ARDS_ERROR_DUPLICATE_SERVER.toDefMsg(), defLocale);
                }
                return -1;
            }
            this.lockFile.writeBytes(string);
        }
        catch (Exception exception) {
            if (this.loggerHelper != null && this.logger != null) {
                this.loggerHelper.logFormattedErrorMessage(this.debugMode, this.logger, CommonErrors.AR_MSG_SET.toDefMsg(), CommonErrors.AR_ERROR_LOCK_FILE_OPEN.toIntValue(), null, CommonErrors.AR_ERROR_LOCK_FILE_OPEN.toDefMsg(), defLocale);
                this.loggerHelper.logException(this.debugMode, this.logger, exception);
            }
            return -1;
        }
        return 0;
    }

    public int removeServerLock() {
        if (this.lockFile == null) {
            return -1;
        }
        try {
            this.lockFile.close();
            this.deleteLockFile();
        }
        catch (Exception exception) {
            this.loggerHelper.logException(this.debugMode, this.logger, exception);
            return -1;
        }
        return 0;
    }

    private int deleteLockFile() {
        if (this.lockFileFullName == null) {
            return -1;
        }
        if (new File(this.lockFileFullName).delete()) {
            return 0;
        }
        return -1;
    }

    public String generatePidLine(int n) {
        Date date = new Date();
        Object[] objectArray = new Object[]{dateFormat.format(date), new Integer(n).toString()};
        String string = MessageFormat.format(pidLineMsg, objectArray);
        return string;
    }

    public String generatePidLine(long l) {
        Date date = new Date();
        Object[] objectArray = new Object[]{dateFormat.format(date), new Long(l)};
        String string = MessageFormat.format(pidLineMsg, objectArray);
        return string;
    }
}

