/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.servlet.mvc.multiaction;

import com.bmc.thirdparty.org.springframework.beans.factory.InitializingBean;
import com.bmc.thirdparty.org.springframework.util.AntPathMatcher;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.PathMatcher;
import com.bmc.thirdparty.org.springframework.web.servlet.mvc.multiaction.AbstractUrlMethodNameResolver;
import java.util.Iterator;
import java.util.Properties;

public class PropertiesMethodNameResolver
extends AbstractUrlMethodNameResolver
implements InitializingBean {
    private Properties mappings;
    private PathMatcher pathMatcher = new AntPathMatcher();

    public void setMappings(Properties mappings) {
        this.mappings = mappings;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull(pathMatcher, "PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public void afterPropertiesSet() {
        if (this.mappings == null || this.mappings.isEmpty()) {
            throw new IllegalArgumentException("'mappings' property is required");
        }
    }

    protected String getHandlerMethodNameForUrlPath(String urlPath) {
        String methodName = this.mappings.getProperty(urlPath);
        if (methodName != null) {
            return methodName;
        }
        Iterator<Object> it = this.mappings.keySet().iterator();
        while (it.hasNext()) {
            String registeredPath = (String)it.next();
            if (!this.pathMatcher.match(registeredPath, urlPath)) continue;
            return (String)this.mappings.get(registeredPath);
        }
        return null;
    }
}

