/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARTimeUnit;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.DefaultProxyManager;
import com.bmc.arsys.api.PoolingProxyManager;
import com.bmc.arsys.api.ProxyPool;
import com.bmc.arsys.apitransport.ApiProxyI;
import com.bmc.arsys.apitransport.ApiUserContextI;
import com.bmc.arsys.apitransport.connection.ApiProxyManagerI;
import com.bmc.arsys.apitransport.connection.b;
import com.bmc.arsys.apitransport.session.ARServerContext;
import com.bmc.arsys.utils.ProcessUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ProxyManager
extends b {
    protected static final ReentrantLock lock = new ReentrantLock();
    private static Map<String, ARServerContext> long = new Hashtable<String, ARServerContext>();
    private static Logger void = Logger.getLogger(ProxyManager.class);

    ProxyManager() {
    }

    ProxyManager(int n2, int n3, long l2, long l3, ARTimeUnit aRTimeUnit) {
        super(n2, n3, l2, l3, aRTimeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApiProxyManagerI getProxyManager() {
        if (currentManager == null) {
            lock.lock();
            try {
                if (currentManager == null) {
                    currentManager = ProxyManager.isUseConnectionPooling() ? new PoolingProxyManager(b.maxProxiesPerServer, b.idleConnectionsPerServer, b.connectionTimeout, b.connectionLifespan, ARTimeUnit.MILLISECONDS) : new DefaultProxyManager();
                }
            }
            finally {
                lock.unlock();
            }
        }
        return currentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConnectionLimits(int n2) {
        lock.lock();
        try {
            maxProxiesPerServer = n2;
            if (void.isInfoEnabled()) {
                void.info("Currently, connection pooling " + ProxyManager.isUseConnectionPooling());
                void.info("Client sets connection limits per server to :" + n2);
            }
            if (currentManager != null && currentManager instanceof PoolingProxyManager) {
                ((b)currentManager).adjustProxyPoolVariables(n2, idleConnectionsPerServer, connectionTimeout, ARTimeUnit.MILLISECONDS);
            }
            if (void.isInfoEnabled()) {
                ProxyManager.getPoolInformation();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void adjustConnectionPoolVariables(PoolInfo poolInfo) {
        if (void.isInfoEnabled()) {
            void.info("Currently, connection pooling " + ProxyManager.isUseConnectionPooling());
        }
        if (poolInfo == null) {
            if (void.isInfoEnabled()) {
                void.info("adjustConnectionPoolVariable with poolsetting null. No change");
            }
        } else {
            int n2 = poolInfo.getIdleConnectionsPerServer();
            int n3 = poolInfo.getPoolMaxProxyPerServer();
            long l2 = poolInfo.getPoolConnectionTimeout();
            ARTimeUnit aRTimeUnit = poolInfo.getPoolUnit();
            if (void.isInfoEnabled()) {
                void.info("Client adjusts connection variables maximumPoolSize = " + n3 + " minIdleProxySize = " + n2 + " connectionTimeout = " + l2 + " timeUnit = " + (Object)((Object)poolInfo.getPoolUnit()));
            }
            if (n2 > n3) {
                n2 = n3 / 2;
                void.info("idleConnectionsPerServer value cannot be more than maxProxiesPerServer. idleConnectionsPerServer reverted to " + n2);
            }
            lock.lock();
            try {
                b.idleConnectionsPerServer = n2;
                b.maxProxiesPerServer = n3;
                long l3 = b.connectionTimeout = aRTimeUnit == null ? l2 : aRTimeUnit.toMillis(l2);
                if (currentManager != null && currentManager instanceof b) {
                    ((b)currentManager).adjustProxyPoolVariables(n3, n2, b.connectionTimeout, ARTimeUnit.MILLISECONDS);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static long getConnectionLifespan(ARTimeUnit aRTimeUnit) {
        if (aRTimeUnit == null) {
            return b.connectionLifespan;
        }
        return ARTimeUnit.MILLISECONDS.convert(b.connectionLifespan, aRTimeUnit);
    }

    public static void setConnectionLifespan(long l2, ARTimeUnit aRTimeUnit) {
        if (void.isInfoEnabled()) {
            void.info("Client set connectionLifespan = " + l2 + " timeUnit = " + (Object)((Object)aRTimeUnit));
        }
        b.setConnectionLifespan(l2, aRTimeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUseConnectionPooling(boolean bl) {
        void.info("Client sets useConnectionPooling to : " + bl);
        if (useConnectionPooling == bl) {
            return;
        }
        if (currentManager != null) {
            void.debug("ProxyManager setUseConnectionPooling usePooling = " + bl + "; current thread = " + Thread.currentThread() + "; total activeThread = " + Thread.activeCount());
            lock.lock();
            try {
                useConnectionPooling = bl;
                currentManager.clear();
                currentManager = null;
                currentManager = ProxyManager.getProxyManager();
            }
            finally {
                lock.unlock();
            }
        } else {
            void.debug("ProxyManager directly setUseConnectionPooling usePooling = " + bl + "; current thread = " + Thread.currentThread() + "; total activeThread = " + Thread.activeCount());
            useConnectionPooling = bl;
        }
    }

    public static boolean isUseConnectionPooling() {
        return useConnectionPooling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PoolInfo[] getPoolInformation() {
        PoolInfo[] poolInfoArray;
        block9: {
            poolInfoArray = new PoolInfo[]{};
            try {
                if (!lock.tryLock(30L, TimeUnit.SECONDS)) break block9;
                try {
                    void.info("UsePooling: " + ProxyManager.isUseConnectionPooling());
                    if (currentManager != null && currentManager instanceof ProxyManager && (poolInfoArray = ((ProxyManager)currentManager).getInfo()) != null && void.isInfoEnabled()) {
                        for (int i2 = 0; i2 <= poolInfoArray.length - 1; ++i2) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append(", Pool info: server- " + poolInfoArray[i2].getPoolServerName()).append(", # free proxy- " + poolInfoArray[i2].getPoolFree()).append(", # in used- " + poolInfoArray[i2].getPoolInUse()).append(", # not created- " + poolInfoArray[i2].getPoolNotCreated()).append(", establish- " + poolInfoArray[i2].getPoolEstablishTimeFormated()).append(", last used- " + poolInfoArray[i2].getPoolLastUsedTimeFormated()).append(", # ever reached pool size- " + poolInfoArray[i2].getPoolLargestReachedPoolSize()).append(", # maxProxyPerServer- " + poolInfoArray[i2].getPoolMaxProxyPerServer()).append(", # idleConnectionsPerServer- " + poolInfoArray[i2].getIdleConnectionsPerServer()).append(", connectionTimeout setting- " + poolInfoArray[i2].getPoolConnectionTimeoutElapsedTimeFormated()).append(", connectionLifespan setting- " + poolInfoArray[i2].getPoolConnectionLifespanElapsedTimeFormated());
                            void.info(stringBuilder);
                        }
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            catch (InterruptedException interruptedException) {
                void.info("Skipped the getPoolInformation after waiting for 30 seconds");
            }
        }
        if (poolInfoArray == null || poolInfoArray.length == 0) {
            poolInfoArray = new PoolInfo[1];
            long l2 = System.currentTimeMillis();
            poolInfoArray[0] = new PoolInfo("", 0, 0, ProxyManager.getMaxProxiesPerServer(), l2, l2, 0, ProxyManager.getMaxProxiesPerServer(), ProxyManager.getIdleConnectionsPerServer(), ProxyManager.getConnectionTimeout(ARTimeUnit.MILLISECONDS), ProxyManager.getConnectionLifespan(ARTimeUnit.MILLISECONDS), ARTimeUnit.MILLISECONDS);
            if (poolInfoArray != null && void.isInfoEnabled()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(", Pool setting info: ").append(", # maxProxyPerServer- " + maxProxiesPerServer).append(", # idleConnectionsPerServer- " + idleConnectionsPerServer).append(", connectionTimeout setting- " + ProcessUtil.getElapsedTimeToFormatedString(connectionTimeout)).append(", connectionLifespan setting- " + ProcessUtil.getElapsedTimeToFormatedString(connectionLifespan));
                void.info(stringBuilder);
            }
        }
        return poolInfoArray;
    }

    PoolInfo[] getInfo() {
        PoolInfo[] poolInfoArray = new PoolInfo[this.serverProxyPools.size()];
        Iterator iterator = this.serverProxyPools.keySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ProxyPool proxyPool = (ProxyPool)this.serverProxyPools.get(string);
            poolInfoArray[n2] = proxyPool.getInfo(string);
            if (!void.isDebugEnabled()) continue;
            void.debug(string);
            void.debug(poolInfoArray[n2].toString());
        }
        return poolInfoArray;
    }

    public static Map<String, ARServerContext> getServerContextMap() {
        return long;
    }

    public static ARServerContext getARServerContext(String string, int n2) {
        String string2 = string + ":" + n2;
        return long.get(string2);
    }

    @Override
    public ApiProxyI createProxy(ApiUserContextI apiUserContextI) throws ARException {
        return this.getProxyFactory().createProxy(apiUserContextI);
    }

    public static class PoolInfo {
        protected String mServerKey;
        protected int mFree;
        protected int mInUse;
        protected int mNotCreated;
        protected int mMaxProxyPerServer;
        protected int mIdleConnection;
        protected int mLargestReachedPoolSize;
        protected long mConnectionTimeout;
        protected long mConnectionLifespan;
        protected long mLastUsed;
        protected long mEstablished;
        protected ARTimeUnit mUnit;

        public PoolInfo(int n2, int n3, long l2, ARTimeUnit aRTimeUnit) {
            this("", 0, 0, b.getMaxProxiesPerServer(), System.currentTimeMillis(), System.currentTimeMillis(), 0, n2, n3, l2, 0L, aRTimeUnit);
        }

        PoolInfo(String string, int n2, int n3, int n4, long l2, long l3, int n5, int n6, int n7, long l4, long l5, ARTimeUnit aRTimeUnit) {
            this.mServerKey = string;
            this.mInUse = n2;
            this.mFree = n3;
            this.mNotCreated = n4;
            this.mEstablished = l2;
            this.mLastUsed = l3;
            this.mMaxProxyPerServer = n6;
            this.mIdleConnection = n7;
            this.mConnectionTimeout = l4;
            this.mConnectionLifespan = l5;
            this.mLargestReachedPoolSize = n5;
            this.mUnit = aRTimeUnit;
        }

        public void setPoolMaxProxyPerServer(int n2) {
            this.mMaxProxyPerServer = n2;
        }

        public void setIdleConnectionsPerServer(int n2) {
            this.mIdleConnection = n2;
        }

        public long getPoolConnectionTimeout() {
            return this.mConnectionTimeout;
        }

        public void setPoolConnectionTimeout(long l2) {
            this.mConnectionTimeout = l2;
        }

        public long getPoolConnectionLifespan() {
            return this.mConnectionLifespan;
        }

        public void setPoolConnectionLifespan(long l2) {
            this.mConnectionLifespan = l2;
        }

        public String getPoolServerName() {
            return this.mServerKey;
        }

        public int getPoolInUse() {
            return this.mInUse;
        }

        public int getPoolFree() {
            return this.mFree;
        }

        public int getPoolNotCreated() {
            return this.mNotCreated;
        }

        public long getPoolLastUsed() {
            return this.mLastUsed;
        }

        public String getPoolLastUsedTimeFormated() {
            if (this.mUnit == null) {
                return ProcessUtil.getFormatedTimeUsed(this.mLastUsed);
            }
            return ProcessUtil.getFormatedTimeUsed(this.mUnit.toMillis(this.mLastUsed));
        }

        public String getPoolConnectionTimeoutElapsedTimeFormated() {
            if (this.mUnit == null) {
                return ProcessUtil.getElapsedTimeToFormatedString(this.mConnectionTimeout);
            }
            return ProcessUtil.getElapsedTimeToFormatedString(this.mUnit.toMillis(this.mConnectionTimeout));
        }

        public String getPoolEstablishTimeFormated() {
            if (this.mUnit == null) {
                return ProcessUtil.getFormatedTimeUsed(this.mEstablished);
            }
            return ProcessUtil.getFormatedTimeUsed(this.mUnit.toMillis(this.mEstablished));
        }

        public String getPoolConnectionLifespanElapsedTimeFormated() {
            if (this.mUnit == null) {
                return ProcessUtil.getElapsedTimeToFormatedString(this.mConnectionLifespan);
            }
            return ProcessUtil.getElapsedTimeToFormatedString(this.mUnit.toMillis(this.mConnectionLifespan));
        }

        public int getPoolMaxProxyPerServer() {
            return this.mMaxProxyPerServer;
        }

        public int getIdleConnectionsPerServer() {
            return this.mIdleConnection;
        }

        public long getPoolEstablish() {
            return this.mEstablished;
        }

        public int getPoolLargestReachedPoolSize() {
            return this.mLargestReachedPoolSize;
        }

        public ARTimeUnit getPoolUnit() {
            return this.mUnit;
        }

        public String toString() {
            String string = new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("ServerKey", this.mServerKey).append(" # free proxy", this.mFree).append(" # in used", this.mInUse).append(" # not created", this.mNotCreated).append(" establish at", this.getPoolEstablishTimeFormated()).append(" last used at", this.getPoolLastUsedTimeFormated()).append(" # ever reached pool size", this.mLargestReachedPoolSize).append(" # maxProxyPerServer", this.mMaxProxyPerServer).append(" # idleConnectionsPerServer", this.mIdleConnection).append(" connectionTimeout", this.getPoolConnectionTimeoutElapsedTimeFormated()).append(" connectionLifespan", this.getPoolConnectionLifespanElapsedTimeFormated()).toString();
            if (void.isTraceEnabled()) {
                void.trace(string);
            }
            return string;
        }
    }
}

