/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*   Copyright  2009  2012 BMC Software, Inc.                              */
/*   BMC, BMC Software, the BMC logos and other BMC marks are trademarks or  */
/*   registered trademarks of BMC Software, Inc. in the U.S. and /or         */
/*   certain other countries.                                                */
/*****************************************************************************/

package com.bmc.arsys.demo.javadriver;

class Commands
{
   public static final int UNKNOWN_COMMAND                    = -2;
   public static final int COMMAND_EXIT                       = -1;
   public static final int COMMAND_LOGIN                      =  0;
   public static final int COMMAND_GET_ENTRY                  =  1;
   public static final int COMMAND_SET_ENTRY                  =  2;
   public static final int COMMAND_CREATE_ENTRY               =  3;
   public static final int COMMAND_DELETE_ENTRY               =  4;
   public static final int COMMAND_GETLIST_ENTRY              =  5;
   public static final int COMMAND_GET_FILTER                 =  6;
   public static final int COMMAND_SET_FILTER                 =  7;
   public static final int COMMAND_CREATE_FILTER              =  8;
   public static final int COMMAND_DELETE_FILTER              =  9;
   public static final int COMMAND_GETLIST_FILTER             = 10;
   public static final int COMMAND_GETLIST_GROUP              = 11;
   public static final int COMMAND_GET_SCHEMA                 = 12;
   public static final int COMMAND_SET_SCHEMA                 = 13;
   public static final int COMMAND_CREATE_SCHEMA              = 14;
   public static final int COMMAND_DELETE_SCHEMA              = 15;
   public static final int COMMAND_GETLIST_SCHEMA             = 16;
   public static final int COMMAND_GETMULT_SCHEMA             = 17;
   public static final int COMMAND_GET_SCH_FIELD              = 18;
   public static final int COMMAND_SET_SCH_FIELD              = 19;
   public static final int COMMAND_CREATE_SCH_FIELD           = 20;
   public static final int COMMAND_DELETE_SCH_FIELD           = 21;
   public static final int COMMAND_GETLIST_SCH_FIELD          = 22;
   public static final int COMMAND_GET_CHAR_MENU              = 23;
   public static final int COMMAND_SET_CHAR_MENU              = 24;
   public static final int COMMAND_CREATE_CHAR_MENU           = 25;
   public static final int COMMAND_DELETE_CHAR_MENU           = 26;
   public static final int COMMAND_GETLIST_CHAR_MENU          = 27;
   public static final int COMMAND_EXPORT                     = 28;
   public static final int COMMAND_IMPORT                     = 29;
   public static final int COMMAND_GET_SERVER_INFO            = 30;
   public static final int COMMAND_VERIFY_USER                = 31;
   public static final int COMMAND_EXECUTE                    = 32;
   public static final int COMMAND_OPEN_OUT                   = 33;
   public static final int COMMAND_CLOSE_OUT                  = 34;
   public static final int COMMAND_RECORD                     = 35;
   public static final int COMMAND_STOP_RECORD                = 36;
   public static final int COMMAND_GETLIST_SERVER             = 37;
   public static final int COMMAND_INITIALIZATION             = 38;
   public static final int COMMAND_TERMINATION                = 39;
   public static final int COMMAND_GET_ACTIVE_LINK            = 40;
   public static final int COMMAND_SET_ACTIVE_LINK            = 41;
   public static final int COMMAND_CREATE_ACTIVE_LINK         = 42;
   public static final int COMMAND_DELETE_ACTIVE_LINK         = 43;
   public static final int COMMAND_GETLIST_ACTIVE_LINK        = 44;
   public static final int COMMAND_GET_MULTIPLE_ACTIVE_LINKS  = 45;
   public static final int COMMAND_MERGE_ENTRY                = 46;
   public static final int COMMAND_LOAD_AR_QUAL_STRUCT        = 47;
   public static final int COMMAND_EXPAND_CHAR_MENU           = 48;
   public static final int COMMAND_SET_SERVER_INFO            = 49;
   public static final int COMMAND_GETLIST_USER               = 50;
   public static final int COMMAND_GET_ESCALATION             = 51;
   public static final int COMMAND_SET_ESCALATION             = 52;
   public static final int COMMAND_CREATE_ESCALATION          = 53;
   public static final int COMMAND_DELETE_ESCALATION          = 54;
   public static final int COMMAND_GETLIST_ESCALATION         = 55;
   public static final int COMMAND_ENTRY_STATISTICS           = 56;
   public static final int COMMAND_GET_SERVER_STAT            = 59;
   public static final int COMMAND_GETLIST_SQL                = 60;
   public static final int COMMAND_DELETE_MULTI_FIELD         = 61;
   public static final int COMMAND_EXECUTE_PROCESS            = 62;
   public static final int COMMAND_GET_VUI                    = 63;
   public static final int COMMAND_SET_VUI                    = 64;
   public static final int COMMAND_CREATE_VUI                 = 65;
   public static final int COMMAND_DELETE_VUI                 = 66;
   public static final int COMMAND_GETLIST_VUI                = 67;
   public static final int COMMAND_SET_SERVER_PORT            = 68;
   public static final int COMMAND_GET_MULTIPLE_ENTRY         = 69;
   public static final int COMMAND_GET_SUPPORT_FILE           = 70;
   public static final int COMMAND_SET_SUPPORT_FILE           = 71;
   public static final int COMMAND_CREATE_SUPPORT_FILE        = 72;
   public static final int COMMAND_DELETE_SUPPORT_FILE        = 73;
   public static final int COMMAND_GETLIST_SUPPORT_FILE       = 74;
   public static final int COMMAND_LAUNCH_THREAD              = 75;
   public static final int COMMAND_LAUNCH_WAITING_THREAD      = 76;
   public static final int COMMAND_RELEASE_WAITING_THREADS    = 77;
   public static final int COMMAND_SLEEP_TIMER                = 78;
   public static final int COMMAND_RANDOM_SLEEP_TIMER         = 79;
   public static final int COMMAND_MILLISECOND_SLEEP_TIMER    = 80;
   public static final int COMMAND_BEGIN_LOOP                 = 81;
   public static final int COMMAND_END_LOOP                   = 82;
   public static final int COMMAND_GETLIST_ENTRY_WITH_FIELDS  = 83;
   public static final int COMMAND_GETENTRY_BLOB              = 84;
   public static final int COMMAND_GET_CONTAINER              = 85;
   public static final int COMMAND_SET_CONTAINER              = 86;
   public static final int COMMAND_CREATE_CONTAINER           = 87;
   public static final int COMMAND_DELETE_CONTAINER           = 88;
   public static final int COMMAND_GETLIST_CONTAINER          = 89;
   public static final int COMMAND_GET_MULTIPLE_CONTAINER     = 90;
   public static final int COMMAND_GET_ERROR_MESSAGE          = 91;
   public static final int COMMAND_SET_LOGGING                = 92;
   public static final int COMMAND_CLOSE_NET_CONNECTIONS      = 93;
   public static final int COMMAND_SIGNAL                     = 94;
   public static final int COMMAND_VALIDATE_FORM_CACHE        = 95;
   public static final int COMMAND_GET_MULTIPLE_FIELDS        = 96;
   public static final int COMMAND_GETLIST_SCHEMA_WITH_ALIAS  = 97;
   public static final int COMMAND_GET_LOCALIZED_VALUE        = 98;
   public static final int COMMAND_CREATE_ALERT_EVENT         = 99;
   public static final int COMMAND_REGISTER_ALERTS            = 100;
   public static final int COMMAND_DEREGISTER_ALERTS          = 101;
   public static final int COMMAND_GETLIST_ALERT_USER         = 102;
   public static final int COMMAND_GET_ALERT_COUNT            = 103;
   public static final int COMMAND_DECODE_ALERT_MESSAGE       = 104;
   public static final int COMMAND_ENCODE_QUALIFIER           = 105;
   public static final int COMMAND_DECODE_QUALIFIER           = 106;
   public static final int COMMAND_ENCODE_ASSIGN              = 107;
   public static final int COMMAND_DECODE_ASSIGN              = 108;
   public static final int COMMAND_ENCODE_HISTORY             = 109;
   public static final int COMMAND_ENCODE_DIARY               = 110;
   public static final int COMMAND_GETLIST_EXT_SCHEMA_CANDS   = 111;
   public static final int COMMAND_GET_MULT_EXT_FIELD_CANDS   = 112;
   public static final int COMMAND_EXPAND_SS_MENU             = 113;
   public static final int COMMAND_VALIDATE_LICENSE           = 114;
   public static final int COMMAND_VALIDATE_MULTIPLE_LICENSES = 115;
   public static final int COMMAND_GETLIST_LICENSE            = 116;
   public static final int COMMAND_CREATE_LICENSE             = 117;
   public static final int COMMAND_DELETE_LICENSE             = 118;
   public static final int COMMAND_GET_MULT_LOCALIZED_VALUES  = 119;
   public static final int COMMAND_GETLIST_SQL_FOR_AL         = 120;
   public static final int COMMAND_EXECUTE_PROCESS_FOR_AL     = 121;
   public static final int COMMAND_DRIVER_VERSION             = 122;
   public static final int COMMAND_GET_SESSION_CONFIGURATION  = 123;
   public static final int COMMAND_SET_SESSION_CONFIGURATION  = 124;
   public static final int COMMAND_ENCODE_DATE                = 125;
   public static final int COMMAND_DECODE_DATE                = 126;
   public static final int COMMAND_XML_CREATE_ENTRY           = 127;
   public static final int COMMAND_XML_GET_ENTRY              = 128;
   public static final int COMMAND_XML_SET_ENTRY              = 129;
   public static final int COMMAND_GET_CLIENT_TYPE            = 130;
   public static final int COMMAND_SET_CLIENT_TYPE            = 131;
   public static final int COMMAND_GET_MULT_CURR_RATIO_SETS   = 132;
   public static final int COMMAND_GET_CURRENCY_RATIO         = 133;
   public static final int COMMAND_GET_MULTIPLE_ENTRYPOINTS   = 134;
   public static final int COMMAND_GET_LIST_ROLE              = 135;
   public static final int COMMAND_BEGIN_BULK_ENTRY_TRANS     = 136;
   public static final int COMMAND_END_BULK_ENTRY_TRANS       = 137;
   public static final int COMMAND_COMPACT_GETLIST_ENTRY      = 999;
   public static final int COMMAND_GETLIST_ENTRY_BLOCKS       = 138;
   public static final int COMMAND_DUMP_PROXY_INFO            = 139;
   public static final int COMMAND_USE_CONNECTION_POOLING     = 140;
   public static final int COMMAND_SET_IMPERSONATED_USER      = 141;
   public static final int COMMAND_GET_SERVER_CHARSET         = 142;
   public static final int COMMAND_BEGIN_API_RECORDING        = 143;
   public static final int COMMAND_STOP_API_RECORDING         = 144;
   public static final int COMMAND_EXECUTE_SERVICE            = 145;
   public static final int COMMAND_GETLIST_APP_STATE          = 146;
   public static final int COMMAND_GET_APP_STATE              = 147;
   public static final int COMMAND_SET_APP_STATE              = 148;
   public static final int COMMAND_XML_EXECUTE_SERVICE        = 149;
   public static final int COMMAND_SET_CONNECTION_LIMIT_PER_SERVER     = 150;
   public static final int COMMAND_GETMULT_CHAR_MENU          = 151;
   public static final int COMMAND_GETMULT_FILTER             = 152;
   public static final int COMMAND_GETMULT_ESCALATION         = 153;
   public static final int COMMAND_GET_OBJ_CHANGE_TIMES       = 154;
   public static final int COMMAND_GET_IMAGE                  = 155;
   public static final int COMMAND_SET_IMAGE                  = 156;
   public static final int COMMAND_CREATE_IMAGE               = 157;
   public static final int COMMAND_DELETE_IMAGE               = 158;
   public static final int COMMAND_GETLIST_IMAGE              = 159;
   public static final int COMMAND_GETMULT_IMAGE              = 160;
   public static final int COMMAND_DELETE_ALERT               = 161;
   public static final int COMMAND_WFD_GET_DEBUG_LOCATION     = 162;
   public static final int COMMAND_WFD_EXECUTE                = 163;
   public static final int COMMAND_WFD_GET_FIELD_VALUES       = 164;
   public static final int COMMAND_WFD_SET_FIELD_VALUES       = 165;
   public static final int COMMAND_WFD_GET_DEBUG_MODE         = 166;
   public static final int COMMAND_WFD_SET_DEBUG_MODE         = 167;
   public static final int COMMAND_WFD_GET_FILTER_QUAL        = 168;
   public static final int COMMAND_WFD_SET_QUALIFIER_RESULT   = 169;
   public static final int COMMAND_WFD_TERMINATE_API          = 170;
   public static final int COMMAND_RUN_ESCALATION             = 171;
   public static final int COMMAND_CLIENT_MANAGED_BEGIN_TXN   = 172;
   public static final int COMMAND_CLIENT_MANAGED_END_TXN     = 173;
   public static final int COMMAND_CLIENT_MANAGED_SET_TXN     = 174;
   public static final int COMMAND_CLIENT_MANAGED_REMOVE_TXN  = 175;
   public static final int COMMAND_GETONE_ENTRY_WITH_FIELDS   = 176;
   public static final int COMMAND_GETLIST_ENTRY_WITH_MS_FIELDS   = 177;
   public static final int COMMAND_GET_CACHE_EVENT   		  = 178;
   public static final int COMMAND_SETMULT_SCH_FIELD 		  = 179;
   public static final int COMMAND_SET_GET_ENTRY			  = 180;
   public static final int COMMAND_CREATE_OVERLAY			  = 181;
   public static final int COMMAND_GET_MULT_VIEWS   		  = 182;
   public static final int COMMAND_SET_OVERLAY_GROUPNAME      = 183;
   public static final int COMMAND_CREATE_OVERLAY_FROM_OBJECT = 184;
   public static final int COMMAND_ADJUST_CONNECTION_PARAMS_PER_SERVER  = 185;
   public static final int COMMAND_VERIFY_USER2               = 186;
   public static final int COMMAND_CREATEMULT_SCH_FIELD       = 187;
   
   static public  int getCommandCode(String command)
   {
      if(command.equals("log"))    return   COMMAND_LOGIN;
      if(command.equals("ge"))     return   COMMAND_GET_ENTRY;
      if(command.equals("se"))     return   COMMAND_SET_ENTRY;
      if(command.equals("ce"))     return   COMMAND_CREATE_ENTRY;
      if(command.equals("de"))     return   COMMAND_DELETE_ENTRY;
      if(command.equals("gle"))    return   COMMAND_GETLIST_ENTRY;
      if(command.equals("gcle"))   return   COMMAND_COMPACT_GETLIST_ENTRY;
      if(command.equals("gf"))     return   COMMAND_GET_FILTER;
      if(command.equals("sf"))     return   COMMAND_SET_FILTER;
      if(command.equals("cf"))     return   COMMAND_CREATE_FILTER;
      if(command.equals("df"))     return   COMMAND_DELETE_FILTER;
      if(command.equals("glf"))    return   COMMAND_GETLIST_FILTER;
      if(command.equals("gmf"))    return   COMMAND_GETMULT_FILTER;      
      if(command.equals("glg"))    return   COMMAND_GETLIST_GROUP;
      if(command.equals("gs"))     return   COMMAND_GET_SCHEMA;
      if(command.equals("ss"))     return   COMMAND_SET_SCHEMA;
      if(command.equals("cs"))     return   COMMAND_CREATE_SCHEMA;
      if(command.equals("ds"))     return   COMMAND_DELETE_SCHEMA;
      if(command.equals("gls"))    return   COMMAND_GETLIST_SCHEMA;
      if(command.equals("gms"))    return   COMMAND_GETMULT_SCHEMA;
      if(command.equals("gsf"))    return   COMMAND_GET_SCH_FIELD;
      if(command.equals("ssf"))    return   COMMAND_SET_SCH_FIELD;
      if(command.equals("smsf"))   return   COMMAND_SETMULT_SCH_FIELD;
      if(command.equals("csf"))    return   COMMAND_CREATE_SCH_FIELD;
      if(command.equals("cmsf"))   return   COMMAND_CREATEMULT_SCH_FIELD;
      if(command.equals("dsf"))    return   COMMAND_DELETE_SCH_FIELD;
      if(command.equals("glsf"))   return   COMMAND_GETLIST_SCH_FIELD;
      if(command.equals("gc"))     return   COMMAND_GET_CHAR_MENU;
      if(command.equals("sc"))     return   COMMAND_SET_CHAR_MENU;
      if(command.equals("cc"))     return   COMMAND_CREATE_CHAR_MENU;
      if(command.equals("dc"))     return   COMMAND_DELETE_CHAR_MENU;
      if(command.equals("glc"))    return   COMMAND_GETLIST_CHAR_MENU;
      if(command.equals("gmc"))    return   COMMAND_GETMULT_CHAR_MENU;
      if(command.equals("exp"))    return   COMMAND_EXPORT;
      if(command.equals("imp"))    return   COMMAND_IMPORT;
      if(command.equals("gsi"))    return   COMMAND_GET_SERVER_INFO;
      if(command.equals("ver"))    return   COMMAND_VERIFY_USER;
      if(command.equals("ex"))     return   COMMAND_EXECUTE;
      if(command.equals("oout"))   return   COMMAND_OPEN_OUT;
      if(command.equals("cout"))   return   COMMAND_CLOSE_OUT;
      if(command.equals("rec"))    return   COMMAND_RECORD;
      if(command.equals("srec"))   return   COMMAND_STOP_RECORD;
      if(command.equals("svr"))    return   COMMAND_GETLIST_SERVER;
      if(command.equals("init"))   return   COMMAND_INITIALIZATION;
      if(command.equals("term"))   return   COMMAND_TERMINATION;
      if(command.equals("gal"))    return   COMMAND_GET_ACTIVE_LINK;
      if(command.equals("sal"))    return   COMMAND_SET_ACTIVE_LINK;
      if(command.equals("cal"))    return   COMMAND_CREATE_ACTIVE_LINK;
      if(command.equals("dal"))    return   COMMAND_DELETE_ACTIVE_LINK;
      if(command.equals("glal"))   return   COMMAND_GETLIST_ACTIVE_LINK;
      if(command.equals("gmal"))   return   COMMAND_GET_MULTIPLE_ACTIVE_LINKS;
      if(command.equals("me"))     return   COMMAND_MERGE_ENTRY;
      if(command.equals("lqs"))    return   COMMAND_LOAD_AR_QUAL_STRUCT;
      if(command.equals("ec"))     return   COMMAND_EXPAND_CHAR_MENU;
      if(command.equals("ssi"))    return   COMMAND_SET_SERVER_INFO ;
      if(command.equals("glu"))    return   COMMAND_GETLIST_USER;
      if(command.equals("ges"))    return   COMMAND_GET_ESCALATION;
      if(command.equals("ses"))    return   COMMAND_SET_ESCALATION;
      if(command.equals("ces"))    return   COMMAND_CREATE_ESCALATION;
      if(command.equals("des"))    return   COMMAND_DELETE_ESCALATION;
      if(command.equals("gles"))   return   COMMAND_GETLIST_ESCALATION;
      if(command.equals("gmes"))   return   COMMAND_GETMULT_ESCALATION;
      if(command.equals("stat"))   return   COMMAND_ENTRY_STATISTICS;
      if(command.equals("gss"))    return   COMMAND_GET_SERVER_STAT;
      if(command.equals("glsql"))  return   COMMAND_GETLIST_SQL;
      if(command.equals("dmsf"))   return   COMMAND_DELETE_MULTI_FIELD;
      if(command.equals("proc"))   return   COMMAND_EXECUTE_PROCESS;
      if(command.equals("gv"))     return   COMMAND_GET_VUI;
      if(command.equals("sv"))     return   COMMAND_SET_VUI;
      if(command.equals("cv"))     return   COMMAND_CREATE_VUI;
      if(command.equals("dv"))     return   COMMAND_DELETE_VUI;
      if(command.equals("glsv"))   return   COMMAND_GETLIST_VUI;
      if(command.equals("ssp"))    return   COMMAND_SET_SERVER_PORT;
      if(command.equals("gme"))    return   COMMAND_GET_MULTIPLE_ENTRY;
      if(command.equals("gfl"))    return   COMMAND_GET_SUPPORT_FILE;
      if(command.equals("sfl"))    return   COMMAND_SET_SUPPORT_FILE;
      if(command.equals("cfl"))    return   COMMAND_CREATE_SUPPORT_FILE;
      if(command.equals("dfl"))    return   COMMAND_DELETE_SUPPORT_FILE;
      if(command.equals("glfl"))   return   COMMAND_GETLIST_SUPPORT_FILE;
      if(command.equals("lt"))     return   COMMAND_LAUNCH_THREAD;
      if(command.equals("lwt"))    return   COMMAND_LAUNCH_WAITING_THREAD;
      if(command.equals("rwt"))    return   COMMAND_RELEASE_WAITING_THREADS;
      if(command.equals("st"))     return   COMMAND_SLEEP_TIMER;
      if(command.equals("rst"))    return   COMMAND_RANDOM_SLEEP_TIMER;
      if(command.equals("msst"))   return   COMMAND_MILLISECOND_SLEEP_TIMER;
      if(command.equals("bl"))     return   COMMAND_BEGIN_LOOP;
      if(command.equals("el"))     return   COMMAND_END_LOOP;
      if(command.equals("glewf"))  return   COMMAND_GETLIST_ENTRY_WITH_FIELDS;
      if(command.equals("gleb"))   return   COMMAND_GETLIST_ENTRY_BLOCKS;
      if(command.equals("geb"))    return   COMMAND_GETENTRY_BLOB;
      if(command.equals("gco"))    return   COMMAND_GET_CONTAINER;
      if(command.equals("sco"))    return   COMMAND_SET_CONTAINER;
      if(command.equals("cco"))    return   COMMAND_CREATE_CONTAINER;
      if(command.equals("dco"))    return   COMMAND_DELETE_CONTAINER;
      if(command.equals("glco"))   return   COMMAND_GETLIST_CONTAINER;
      if(command.equals("gmco"))   return   COMMAND_GET_MULTIPLE_CONTAINER;
      if(command.equals("gem"))    return   COMMAND_GET_ERROR_MESSAGE;
      if(command.equals("slog"))   return   COMMAND_SET_LOGGING;
      if(command.equals("cnc"))    return   COMMAND_CLOSE_NET_CONNECTIONS;
      if(command.equals("sig"))    return   COMMAND_SIGNAL;
      if(command.equals("vfc"))    return   COMMAND_VALIDATE_FORM_CACHE;
      if(command.equals("gmsf"))   return   COMMAND_GET_MULTIPLE_FIELDS;
      if(command.equals("glsa"))   return   COMMAND_GETLIST_SCHEMA_WITH_ALIAS;
      if(command.equals("glv"))    return   COMMAND_GET_LOCALIZED_VALUE;
      if(command.equals("cae"))    return   COMMAND_CREATE_ALERT_EVENT;
      if(command.equals("rfa"))    return   COMMAND_REGISTER_ALERTS;
      if(command.equals("dfa"))    return   COMMAND_DEREGISTER_ALERTS;
      if(command.equals("glau"))   return   COMMAND_GETLIST_ALERT_USER;
      if(command.equals("gac"))    return   COMMAND_GET_ALERT_COUNT;
      if(command.equals("dae"))    return   COMMAND_DELETE_ALERT;
      if(command.equals("dcam"))   return   COMMAND_DECODE_ALERT_MESSAGE;
      if(command.equals("ecqal"))  return   COMMAND_ENCODE_QUALIFIER;
      if(command.equals("dcqal"))  return   COMMAND_DECODE_QUALIFIER;
      if(command.equals("ecasn"))  return   COMMAND_ENCODE_ASSIGN;
      if(command.equals("dcasn"))  return   COMMAND_DECODE_ASSIGN;
      if(command.equals("echst"))  return   COMMAND_ENCODE_HISTORY;
      if(command.equals("ecdia"))  return   COMMAND_ENCODE_DIARY;
      if(command.equals("glxsc"))  return   COMMAND_GETLIST_EXT_SCHEMA_CANDS;
      if(command.equals("gmxfc"))  return   COMMAND_GET_MULT_EXT_FIELD_CANDS;
      if(command.equals("essm"))   return   COMMAND_EXPAND_SS_MENU;
      if(command.equals("vl"))     return   COMMAND_VALIDATE_LICENSE;
      if(command.equals("vml"))    return   COMMAND_VALIDATE_MULTIPLE_LICENSES;
      if(command.equals("gll"))    return   COMMAND_GETLIST_LICENSE;
      if(command.equals("cl"))     return   COMMAND_CREATE_LICENSE;
      if(command.equals("dl"))     return   COMMAND_DELETE_LICENSE ;
      if(command.equals("gmlv"))   return   COMMAND_GET_MULT_LOCALIZED_VALUES;
      if(command.equals("sqlal"))  return   COMMAND_GETLIST_SQL_FOR_AL;
      if(command.equals("epal"))   return   COMMAND_EXECUTE_PROCESS_FOR_AL;
      if(command.equals("dver"))   return   COMMAND_DRIVER_VERSION;
      if(command.equals("gsc"))    return   COMMAND_GET_SESSION_CONFIGURATION;
      if(command.equals("ssc"))    return   COMMAND_SET_SESSION_CONFIGURATION ;
      if(command.equals("ecdat"))  return   COMMAND_ENCODE_DATE;
      if(command.equals("dcdat"))  return   COMMAND_DECODE_DATE;
      if(command.equals("xmlce"))  return   COMMAND_XML_CREATE_ENTRY;
      if(command.equals("xmlge"))  return   COMMAND_XML_GET_ENTRY;
      if(command.equals("xmlse"))  return   COMMAND_XML_SET_ENTRY;
      if(command.equals("gct"))    return   COMMAND_GET_CLIENT_TYPE;
      if(command.equals("sct"))    return   COMMAND_SET_CLIENT_TYPE;
      if(command.equals("gmcrs"))  return   COMMAND_GET_MULT_CURR_RATIO_SETS;
      if(command.equals("gcr"))    return   COMMAND_GET_CURRENCY_RATIO;
      if(command.equals("gmep"))   return   COMMAND_GET_MULTIPLE_ENTRYPOINTS;
      if(command.equals("glr"))    return   COMMAND_GET_LIST_ROLE;
      if(command.equals("bbet"))   return   COMMAND_BEGIN_BULK_ENTRY_TRANS;
      if(command.equals("ebet"))   return   COMMAND_END_BULK_ENTRY_TRANS;
      if(command.equals("dpi"))    return   COMMAND_DUMP_PROXY_INFO;
      if(command.equals("ucp"))    return   COMMAND_USE_CONNECTION_POOLING;
      if(command.equals("imusr"))  return   COMMAND_SET_IMPERSONATED_USER;
      if(command.equals("gscs"))   return   COMMAND_GET_SERVER_CHARSET;
      if(command.equals("bar"))    return   COMMAND_BEGIN_API_RECORDING;
      if(command.equals("sar"))    return   COMMAND_STOP_API_RECORDING;
      if(command.equals("sve"))    return   COMMAND_EXECUTE_SERVICE;
      if(command.equals("glas"))   return   COMMAND_GETLIST_APP_STATE;
      if(command.equals("gas"))    return   COMMAND_GET_APP_STATE;
      if(command.equals("sas"))    return   COMMAND_SET_APP_STATE;
      if(command.equals("xmlsve")) return   COMMAND_XML_EXECUTE_SERVICE;
      if(command.equals("scl"))    return   COMMAND_SET_CONNECTION_LIMIT_PER_SERVER;
      if(command.equals("acp"))    return   COMMAND_ADJUST_CONNECTION_PARAMS_PER_SERVER;
      if(command.equals("goct"))   return   COMMAND_GET_OBJ_CHANGE_TIMES;
      if(command.equals("gi"))     return   COMMAND_GET_IMAGE;
      if(command.equals("si"))     return   COMMAND_SET_IMAGE;
      if(command.equals("ci"))     return   COMMAND_CREATE_IMAGE;
      if(command.equals("di"))     return   COMMAND_DELETE_IMAGE;
      if(command.equals("gli"))    return   COMMAND_GETLIST_IMAGE;
      if(command.equals("gmi"))    return   COMMAND_GETMULT_IMAGE;
      if(command.equals("dbdl"))   return   COMMAND_WFD_GET_DEBUG_LOCATION;    
      if(command.equals("dbex"))   return   COMMAND_WFD_EXECUTE;
      if(command.equals("dbgf"))   return   COMMAND_WFD_GET_FIELD_VALUES;
      if(command.equals("dbsf"))   return   COMMAND_WFD_SET_FIELD_VALUES;
      if(command.equals("dbgm"))   return   COMMAND_WFD_GET_DEBUG_MODE;
      if(command.equals("dbsm"))   return   COMMAND_WFD_SET_DEBUG_MODE;
      if(command.equals("dbgq"))   return   COMMAND_WFD_GET_FILTER_QUAL;
      if(command.equals("dbsq"))   return   COMMAND_WFD_SET_QUALIFIER_RESULT;
      if(command.equals("dbta"))   return   COMMAND_WFD_TERMINATE_API;
      if(command.equals("resc"))   return   COMMAND_RUN_ESCALATION;
      if(command.equals("bcmt"))   return   COMMAND_CLIENT_MANAGED_BEGIN_TXN; 
      if(command.equals("ecmt"))   return   COMMAND_CLIENT_MANAGED_END_TXN;  
      if(command.equals("scmt"))   return   COMMAND_CLIENT_MANAGED_SET_TXN; 
      if(command.equals("rcmt"))   return   COMMAND_CLIENT_MANAGED_REMOVE_TXN;
      if(command.equals("goewf"))  return   COMMAND_GETONE_ENTRY_WITH_FIELDS;
      if(command.equals("glmsf"))  return   COMMAND_GETLIST_ENTRY_WITH_MS_FIELDS;
      if(command.equals("gce"))    return   COMMAND_GET_CACHE_EVENT;
      if(command.equals("sge"))    return   COMMAND_SET_GET_ENTRY;
      if(command.equals("co"))     return   COMMAND_CREATE_OVERLAY;
      if(command.equals("gmv"))    return   COMMAND_GET_MULT_VIEWS;
      if(command.equals("sogn"))    return 	COMMAND_SET_OVERLAY_GROUPNAME;
      if(command.equals("cofo"))    return 	COMMAND_CREATE_OVERLAY_FROM_OBJECT;
      if(command.equals("ver2"))   return   COMMAND_VERIFY_USER2;
      if(command.equals("q"))      return   COMMAND_EXIT;
    
      return UNKNOWN_COMMAND;
   }

}
