/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data;

import com.bmc.arsys.apiext.data.ImportErrors;
import com.bmc.arsys.apiext.data.ImportOptions;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JIThreadPoolExecutor {
    private ThreadPoolExecutor if;
    private LinkedBlockingQueue<Runnable> int;
    private static JIThreadPoolExecutor for = null;
    private Logger do = Logger.getLogger((String)"com.bmc.arsys.apiext.data");
    private List<Future<ImportOptions>> a;

    public List<Future<ImportOptions>> getFuture() {
        return this.a;
    }

    public void setFuture(List<Future<ImportOptions>> list) {
        this.a = list;
    }

    public void deleteFuture() {
        this.a.clear();
        this.do.debug((Object)ImportErrors.DELETE_FUTURE_OBJECTS.toDefMsg());
    }

    private JIThreadPoolExecutor() {
        this.int = new LinkedBlockingQueue();
        this.a = new LinkedList<Future<ImportOptions>>();
    }

    public void createPool(int n, long l, TimeUnit timeUnit) {
        this.if = new ThreadPoolExecutor(n, n, l, timeUnit, this.int);
        this.if.prestartAllCoreThreads();
        this.do.debug((Object)MessageFormat.format(ImportErrors.CREATING_THREADPOOL.toDefMsg(), n));
    }

    public void deletePool() {
        this.if.shutdownNow();
        this.int.clear();
        this.if = null;
        this.do.debug((Object)ImportErrors.DELETE_THREADPOOL.toDefMsg());
    }

    public static synchronized JIThreadPoolExecutor getInstance() {
        if (for == null) {
            for = new JIThreadPoolExecutor();
        }
        return for;
    }

    public boolean stop() {
        this.do.debug((Object)ImportErrors.STOP_THREADPOOL.toDefMsg());
        if (this.if != null) {
            this.if.shutdown();
            return true;
        }
        return false;
    }

    public void addTask(Runnable runnable) {
        Future<?> future = this.if.submit(runnable);
        this.a.add(future);
        this.do.debug((Object)ImportErrors.ADD_TASK.toDefMsg());
    }

    public void addMultipleTask(List<Callable<ImportOptions>> list) {
        for (Callable<ImportOptions> callable : list) {
            Future<ImportOptions> future = this.if.submit(callable);
            this.a.add(future);
        }
        this.do.debug((Object)MessageFormat.format(ImportErrors.ADD_MULTIPLE_TASK.toDefMsg(), list.size()));
    }

    public boolean join() {
        try {
            this.do.debug((Object)ImportErrors.JOIN_THREADS_IN_POOL.toDefMsg());
            this.if.shutdown();
            this.if.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            this.do.debug((Object)MessageFormat.format(ImportErrors.JOIN_THREADS_COMPLETED.toDefMsg(), "successfully"));
            return true;
        }
        catch (InterruptedException interruptedException) {
            this.do.debug((Object)MessageFormat.format(ImportErrors.JOIN_THREADS_COMPLETED.toDefMsg(), "with Error"));
            return false;
        }
    }
}

