/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcClientCallMessage;
import org.acplt.oncrpc.OncRpcClientReplyMessage;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcTimeoutException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrBufferEncodingStream;
import org.acplt.oncrpc.XdrHttpDecodingStream;
import org.acplt.oncrpc.web.Base64;
import org.acplt.oncrpc.web.HttpClientConnection;

public class OncRpcHttpClient
extends OncRpcClient {
    private String hostname;
    private int httpPort;
    private String cgiHandlerPath;
    private String oncrpcHostname;
    private int oncrpcProtocol;
    private HttpClientConnection httpClient;
    private XdrBufferEncodingStream sendingXdr;
    private XdrHttpDecodingStream receivingXdr;

    public OncRpcHttpClient(String string, String string2, String string3, int n2, int n3, int n4) throws OncRpcException, IOException {
        this(string, 80, string2, string3, n2, n3, n4, 6);
    }

    public OncRpcHttpClient(String string, String string2, String string3, int n2, int n3, int n4, int n5) throws OncRpcException, IOException {
        this(string, 80, string2, string3, n2, n3, n4, n5);
    }

    public OncRpcHttpClient(String string, int n2, String string2, String string3, int n3, int n4, int n5, int n6) throws OncRpcException, IOException {
        super(null, n3, n4, -1, -42);
        this.httpPort = n2;
        this.cgiHandlerPath = string2;
        this.oncrpcHostname = string3;
        this.oncrpcProtocol = n6;
        this.port = n5;
        this.hostname = string;
        this.httpClient = new HttpClientConnection(string, n2);
        this.sendingXdr = new XdrBufferEncodingStream(8192);
        this.receivingXdr = new XdrHttpDecodingStream(this.httpClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws OncRpcException {
        if (this.httpClient != null) {
            this.httpClient.close();
            this.httpClient = null;
        }
        if (this.sendingXdr != null) {
            try {
                this.sendingXdr.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.sendingXdr = null;
            }
        }
        if (this.receivingXdr != null) {
            try {
                this.receivingXdr.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.receivingXdr = null;
            }
        }
    }

    @Override
    public synchronized void call(int n2, int n3, XdrAble xdrAble, XdrAble xdrAble2) throws OncRpcException {
        for (int i2 = 1; i2 >= 0; --i2) {
            int n4;
            this.nextXid();
            OncRpcClientCallMessage oncRpcClientCallMessage = new OncRpcClientCallMessage(this.xid, this.program, n3, n2, this.auth);
            OncRpcClientReplyMessage oncRpcClientReplyMessage = new OncRpcClientReplyMessage(this.auth);
            try {
                this.sendingXdr.beginEncoding(null, 0);
                oncRpcClientCallMessage.xdrEncode(this.sendingXdr);
                xdrAble.xdrEncode(this.sendingXdr);
                this.sendingXdr.endEncoding();
            }
            catch (IOException iOException) {
                throw new OncRpcException(3, iOException.getLocalizedMessage());
            }
            StringBuffer stringBuffer = new StringBuffer(512);
            stringBuffer.append("CALL ");
            stringBuffer.append(this.oncrpcHostname);
            if (this.port > 0) {
                stringBuffer.append(":");
                stringBuffer.append(this.port);
            }
            stringBuffer.append(" ");
            stringBuffer.append(this.oncrpcProtocol);
            stringBuffer.append(" ");
            stringBuffer.append("TEA/1.0");
            stringBuffer.append("\r\n");
            stringBuffer.append("\r\n");
            int n5 = (n4 + 47) / 48;
            int n6 = stringBuffer.length() + (n4 + 2) / 3 * 4 + n5 * 2;
            byte[] byArray = this.sendingXdr.getXdrData();
            try {
                this.httpClient.beginPostRequest(this.cgiHandlerPath, "text/plain", n6);
                String string = stringBuffer.toString();
                this.httpClient.writeContentBytes(string.getBytes(), 0, string.length());
                byte[] byArray2 = new byte[6600];
                int n7 = 0;
                int n8 = 0;
                for (n4 = this.sendingXdr.getXdrLength(); n4 >= 48; n4 -= 48) {
                    if (n8 >= 6600) {
                        this.httpClient.writeContentBytes(byArray2, 0, n8);
                        n8 = 0;
                    }
                    n8 += Base64.encode((byte[])byArray, (int)n7, (int)48, (byte[])byArray2, (int)n8);
                    byArray2[n8++] = 13;
                    byArray2[n8++] = 10;
                    n7 += 48;
                }
                if (n4 > 0) {
                    if (n8 >= 6600) {
                        this.httpClient.writeContentBytes(byArray2, 0, n8);
                        n8 = 0;
                    }
                    n8 += Base64.encode((byte[])byArray, (int)n7, (int)n4, (byte[])byArray2, (int)n8);
                    byArray2[n8++] = 13;
                    byArray2[n8++] = 10;
                }
                if (n8 > 0) {
                    this.httpClient.writeContentBytes(byArray2, 0, n8);
                }
                this.httpClient.endPostRequest();
            }
            catch (IOException iOException) {
                throw new OncRpcException(3, iOException.getLocalizedMessage());
            }
            try {
                this.receivingXdr.beginDecoding();
                int n9 = this.httpClient.getResponseCode();
                if (n9 < 200 || n9 >= 300) {
                    throw new OncRpcException(16, "HTTP tunnel response error " + n9);
                }
                oncRpcClientReplyMessage.xdrDecode(this.receivingXdr);
                if (oncRpcClientReplyMessage.messageId != oncRpcClientCallMessage.messageId) {
                    this.receivingXdr.endDecoding();
                    throw new OncRpcException(44);
                }
                if (!oncRpcClientReplyMessage.successfullyAccepted()) {
                    this.receivingXdr.endDecoding();
                    if (i2 > 0 && oncRpcClientReplyMessage.replyStatus == 1 && oncRpcClientReplyMessage.rejectStatus == 1 && this.auth.canRefreshCred()) continue;
                    throw oncRpcClientReplyMessage.newException();
                }
                xdrAble2.xdrDecode(this.receivingXdr);
                this.receivingXdr.endDecoding();
                return;
            }
            catch (InterruptedIOException interruptedIOException) {
                throw new OncRpcTimeoutException();
            }
            catch (IOException iOException) {
                throw new OncRpcException(4, iOException.getLocalizedMessage());
            }
        }
    }

    @Override
    public void setCharacterEncoding(String string) {
        this.sendingXdr.setCharacterEncoding(string);
        this.receivingXdr.setCharacterEncoding(string);
    }

    @Override
    public String getCharacterEncoding() {
        return this.receivingXdr.getCharacterEncoding();
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getHttpPort() {
        return this.httpPort;
    }
}

