/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.framework;

import com.bmc.thirdparty.org.aopalliance.aop.Advice;
import com.bmc.thirdparty.org.aopalliance.intercept.Interceptor;
import com.bmc.thirdparty.org.aopalliance.intercept.MethodInterceptor;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.aop.Advisor;
import com.bmc.thirdparty.org.springframework.aop.DynamicIntroductionAdvice;
import com.bmc.thirdparty.org.springframework.aop.IntroductionAdvisor;
import com.bmc.thirdparty.org.springframework.aop.IntroductionInfo;
import com.bmc.thirdparty.org.springframework.aop.TargetSource;
import com.bmc.thirdparty.org.springframework.aop.framework.Advised;
import com.bmc.thirdparty.org.springframework.aop.framework.AdvisedSupportListener;
import com.bmc.thirdparty.org.springframework.aop.framework.AdvisorChainFactory;
import com.bmc.thirdparty.org.springframework.aop.framework.AopConfigException;
import com.bmc.thirdparty.org.springframework.aop.framework.AopProxy;
import com.bmc.thirdparty.org.springframework.aop.framework.HashMapCachingAdvisorChainFactory;
import com.bmc.thirdparty.org.springframework.aop.framework.ProxyConfig;
import com.bmc.thirdparty.org.springframework.aop.support.DefaultIntroductionAdvisor;
import com.bmc.thirdparty.org.springframework.aop.support.DefaultPointcutAdvisor;
import com.bmc.thirdparty.org.springframework.aop.target.EmptyTargetSource;
import com.bmc.thirdparty.org.springframework.aop.target.SingletonTargetSource;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AdvisedSupport
extends ProxyConfig
implements Advised {
    public static final TargetSource EMPTY_TARGET_SOURCE = EmptyTargetSource.INSTANCE;
    private transient List listeners = new LinkedList();
    TargetSource targetSource = EMPTY_TARGET_SOURCE;
    transient AdvisorChainFactory advisorChainFactory;
    private List advisors = new LinkedList();
    private Advisor[] advisorArray = new Advisor[0];
    private List interfaces = new ArrayList();
    private transient boolean isActive;
    static /* synthetic */ Class class$org$springframework$aop$framework$AdvisedSupport;

    public AdvisedSupport() {
        this.initDefaultAdvisorChainFactory();
    }

    public AdvisedSupport(Class[] interfaces) {
        this();
        this.setInterfaces(interfaces);
    }

    private void initDefaultAdvisorChainFactory() {
        this.setAdvisorChainFactory(new HashMapCachingAdvisorChainFactory());
    }

    public void addListener(AdvisedSupportListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(AdvisedSupportListener listener) {
        this.listeners.remove(listener);
    }

    public void setTarget(Object target) {
        this.setTargetSource(new SingletonTargetSource(target));
    }

    public void setTargetSource(TargetSource targetSource) {
        if (this.isActive() && this.isOptimize()) {
            throw new AopConfigException("Can't change target with an optimized CGLIB proxy: it has its own target");
        }
        this.targetSource = targetSource != null ? targetSource : EMPTY_TARGET_SOURCE;
    }

    public TargetSource getTargetSource() {
        return this.targetSource;
    }

    public void setAdvisorChainFactory(AdvisorChainFactory advisorChainFactory) {
        this.advisorChainFactory = advisorChainFactory;
        this.addListener(advisorChainFactory);
    }

    public AdvisorChainFactory getAdvisorChainFactory() {
        return this.advisorChainFactory;
    }

    protected void copyConfigurationFrom(AdvisedSupport other) {
        this.copyConfigurationFrom(other, other.targetSource, other.advisors);
    }

    protected void copyConfigurationFrom(AdvisedSupport other, TargetSource ts, List pAdvisors) {
        this.copyFrom(other);
        this.targetSource = ts;
        this.setInterfaces(other.interfaces.toArray(new Class[other.interfaces.size()]));
        this.advisors = new LinkedList();
        for (int i2 = 0; i2 < pAdvisors.size(); ++i2) {
            Advisor advice = (Advisor)pAdvisors.get(i2);
            this.addAdvisor(advice);
        }
    }

    public void setInterfaces(Class[] interfaces) {
        Assert.notNull(interfaces, "Interfaces must not be null");
        this.interfaces.clear();
        for (int i2 = 0; i2 < interfaces.length; ++i2) {
            this.addInterface(interfaces[i2]);
        }
    }

    public void addInterface(Class newInterface) {
        Assert.notNull(newInterface, "Interface must not be null");
        if (!newInterface.isInterface()) {
            throw new IllegalArgumentException("[" + newInterface.getName() + "] is not an interface");
        }
        if (!this.interfaces.contains(newInterface)) {
            this.interfaces.add(newInterface);
            this.adviceChanged();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Added new aspect interface: " + newInterface.getName());
            }
        }
    }

    public Class[] getProxiedInterfaces() {
        return this.interfaces.toArray(new Class[this.interfaces.size()]);
    }

    public boolean removeInterface(Class intf) {
        return this.interfaces.remove(intf);
    }

    public void addAdvice(Advice advice) throws AopConfigException {
        int pos = this.advisors != null ? this.advisors.size() : 0;
        this.addAdvice(pos, advice);
    }

    public boolean isInterfaceProxied(Class intf) {
        Iterator it = this.interfaces.iterator();
        while (it.hasNext()) {
            Class proxyIntf = (Class)it.next();
            if (!intf.isAssignableFrom(proxyIntf)) continue;
            return true;
        }
        return false;
    }

    public void addAdvice(int pos, Advice advice) throws AopConfigException {
        if (advice instanceof Interceptor && !(advice instanceof MethodInterceptor)) {
            throw new AopConfigException(this.getClass().getName() + " only handles AOP Alliance MethodInterceptors");
        }
        if (advice instanceof IntroductionInfo) {
            this.addAdvisor(pos, new DefaultIntroductionAdvisor(advice, (IntroductionInfo)((Object)advice)));
        } else {
            if (advice instanceof DynamicIntroductionAdvice) {
                throw new AopConfigException("DynamicIntroductionAdvice may only be added as part of IntroductionAdvisor");
            }
            this.addAdvisor(pos, new DefaultPointcutAdvisor(advice));
        }
    }

    public final boolean removeAdvice(Advice advice) throws AopConfigException {
        int index = this.indexOf(advice);
        if (index == -1) {
            return false;
        }
        this.removeAdvisor(index);
        return true;
    }

    public int indexOf(Advice advice) {
        for (int i2 = 0; i2 < this.advisors.size(); ++i2) {
            Advisor advisor = (Advisor)this.advisors.get(i2);
            if (advisor.getAdvice() != advice) continue;
            return i2;
        }
        return -1;
    }

    public int indexOf(Advisor advisor) {
        return this.advisors.indexOf(advisor);
    }

    public final boolean removeAdvisor(Advisor advisor) {
        int index = this.indexOf(advisor);
        if (index == -1) {
            return false;
        }
        this.removeAdvisor(index);
        return true;
    }

    public void removeAdvisor(int index) throws AopConfigException {
        if (this.isFrozen()) {
            throw new AopConfigException("Cannot remove Advisor: config is frozen");
        }
        if (index < 0 || index > this.advisors.size() - 1) {
            throw new AopConfigException("Advisor index " + index + " is out of bounds: " + "Only have " + this.advisors.size() + " advisors");
        }
        Advisor advisor = (Advisor)this.advisors.get(index);
        if (advisor instanceof IntroductionAdvisor) {
            IntroductionAdvisor ia = (IntroductionAdvisor)advisor;
            for (int j2 = 0; j2 < ia.getInterfaces().length; ++j2) {
                this.removeInterface(ia.getInterfaces()[j2]);
            }
        }
        this.advisors.remove(index);
        this.updateAdvisorArray();
        this.adviceChanged();
    }

    private void addAdvisorInternal(int pos, Advisor advice) throws AopConfigException {
        if (this.isFrozen()) {
            throw new AopConfigException("Cannot add advisor: config is frozen");
        }
        if (pos > this.advisors.size()) {
            throw new IllegalArgumentException("Illegal position " + pos + " in advisor list with size " + this.advisors.size());
        }
        this.advisors.add(pos, advice);
        this.updateAdvisorArray();
        this.adviceChanged();
    }

    public void addAdvisor(int pos, IntroductionAdvisor advisor) throws AopConfigException {
        advisor.validateInterfaces();
        for (int i2 = 0; i2 < advisor.getInterfaces().length; ++i2) {
            this.addInterface(advisor.getInterfaces()[i2]);
        }
        this.addAdvisorInternal(pos, advisor);
    }

    public void addAdvisor(int pos, Advisor advisor) throws AopConfigException {
        if (advisor instanceof IntroductionAdvisor) {
            this.addAdvisor(pos, (IntroductionAdvisor)advisor);
        } else {
            this.addAdvisorInternal(pos, advisor);
        }
    }

    public void addAdvisor(Advisor advisor) {
        int pos = this.advisors.size();
        this.addAdvisor(pos, advisor);
    }

    public void addAllAdvisors(Advisor[] advisors) {
        for (int i2 = 0; i2 < advisors.length; ++i2) {
            Advisor advisor = advisors[i2];
            this.advisors.add(advisor);
        }
        this.updateAdvisorArray();
        this.adviceChanged();
    }

    protected final void updateAdvisorArray() {
        this.advisorArray = this.advisors.toArray(new Advisor[this.advisors.size()]);
    }

    public final Advisor[] getAdvisors() {
        return this.advisorArray;
    }

    protected final List getAdvisorsInternal() {
        return this.advisors;
    }

    public final boolean replaceAdvisor(Advisor a2, Advisor b2) throws AopConfigException {
        int index = this.indexOf(a2);
        if (index == -1 || b2 == null) {
            return false;
        }
        this.removeAdvisor(index);
        this.addAdvisor(index, b2);
        return true;
    }

    public final boolean adviceIncluded(Advice advice) {
        if (this.advisors.size() == 0) {
            return false;
        }
        for (int i2 = 0; i2 < this.advisors.size(); ++i2) {
            Advisor advisor = (Advisor)this.advisors.get(i2);
            if (advisor.getAdvice() != advice) continue;
            return true;
        }
        return false;
    }

    public final int countAdvicesOfType(Class interceptorClass) {
        if (this.advisors.size() == 0) {
            return 0;
        }
        int count = 0;
        for (int i2 = 0; i2 < this.advisors.size(); ++i2) {
            Advisor advisor = (Advisor)this.advisors.get(i2);
            if (!interceptorClass.isAssignableFrom(advisor.getAdvice().getClass())) continue;
            ++count;
        }
        return count;
    }

    protected final synchronized void adviceChanged() {
        if (this.isActive) {
            for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
                ((AdvisedSupportListener)this.listeners.get(i2)).adviceChanged(this);
            }
        }
    }

    private void activate() {
        this.isActive = true;
        for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
            ((AdvisedSupportListener)this.listeners.get(i2)).activated(this);
        }
    }

    protected synchronized AopProxy createAopProxy() {
        if (!this.isActive) {
            this.activate();
        }
        return this.getAopProxyFactory().createAopProxy(this);
    }

    protected final boolean isActive() {
        return this.isActive;
    }

    protected Object writeReplace() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Disconnecting " + this);
        }
        AdvisedSupport copy = this;
        if (!this.getClass().equals(class$org$springframework$aop$framework$AdvisedSupport == null ? (class$org$springframework$aop$framework$AdvisedSupport = AdvisedSupport.class$("com.bmc.thirdparty.org.springframework.aop.framework.AdvisedSupport")) : class$org$springframework$aop$framework$AdvisedSupport)) {
            copy = new AdvisedSupport();
            copy.copyConfigurationFrom(this);
        }
        return copy;
    }

    private Object readResolve() {
        this.logger = LogFactory.getLog(this.getClass());
        this.isActive = true;
        this.listeners = new LinkedList();
        this.initDefaultAdvisorChainFactory();
        return this;
    }

    public String toProxyConfigString() {
        return this.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName() + ": ");
        sb.append(this.interfaces.size()).append(" interfaces ");
        sb.append(ClassUtils.classNamesToString(this.interfaces)).append("; ");
        sb.append(this.advisors.size()).append(" advisors ");
        sb.append(this.advisors).append("; ");
        sb.append("targetSource [").append(this.targetSource).append("]; ");
        sb.append("advisorChainFactory [").append(this.advisorChainFactory);
        sb.append("]; ").append(super.toString());
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

