/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.core.io.support;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.core.io.Resource;
import com.bmc.thirdparty.org.springframework.util.CollectionUtils;
import com.bmc.thirdparty.org.springframework.util.DefaultPropertiesPersister;
import com.bmc.thirdparty.org.springframework.util.PropertiesPersister;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public abstract class PropertiesLoaderSupport {
    public static final String XML_FILE_EXTENSION = ".xml";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Properties[] localProperties;
    private Resource[] locations;
    private boolean localOverride = false;
    private boolean ignoreResourceNotFound = false;
    private String fileEncoding;
    private PropertiesPersister propertiesPersister = new DefaultPropertiesPersister();

    public void setProperties(Properties properties) {
        this.localProperties = new Properties[]{properties};
    }

    public void setPropertiesArray(Properties[] propertiesArray) {
        this.localProperties = propertiesArray;
    }

    public void setLocation(Resource location) {
        this.locations = new Resource[]{location};
    }

    public void setLocations(Resource[] locations) {
        this.locations = locations;
    }

    public void setLocalOverride(boolean localOverride) {
        this.localOverride = localOverride;
    }

    public void setIgnoreResourceNotFound(boolean ignoreResourceNotFound) {
        this.ignoreResourceNotFound = ignoreResourceNotFound;
    }

    public void setFileEncoding(String encoding) {
        this.fileEncoding = encoding;
    }

    public void setPropertiesPersister(PropertiesPersister propertiesPersister) {
        this.propertiesPersister = propertiesPersister != null ? propertiesPersister : new DefaultPropertiesPersister();
    }

    protected Properties mergeProperties() throws IOException {
        Properties result = new Properties();
        if (this.localOverride) {
            this.loadProperties(result);
        }
        if (this.localProperties != null) {
            for (int i2 = 0; i2 < this.localProperties.length; ++i2) {
                CollectionUtils.mergePropertiesIntoMap(this.localProperties[i2], result);
            }
        }
        if (!this.localOverride) {
            this.loadProperties(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProperties(Properties props) throws IOException {
        if (this.locations != null) {
            for (int i2 = 0; i2 < this.locations.length; ++i2) {
                Resource location = this.locations[i2];
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Loading properties file from " + location);
                }
                InputStream is = null;
                try {
                    is = location.getInputStream();
                    if (location.getFilename().endsWith(XML_FILE_EXTENSION)) {
                        this.propertiesPersister.loadFromXml(props, is);
                        continue;
                    }
                    if (this.fileEncoding != null) {
                        this.propertiesPersister.load(props, new InputStreamReader(is, this.fileEncoding));
                        continue;
                    }
                    this.propertiesPersister.load(props, is);
                    continue;
                }
                catch (IOException ex) {
                    if (this.ignoreResourceNotFound) {
                        if (!this.logger.isWarnEnabled()) continue;
                        this.logger.warn("Could not load properties from " + location + ": " + ex.getMessage());
                        continue;
                    }
                    throw ex;
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
        }
    }
}

