/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.servlet.i18n;

import com.bmc.thirdparty.org.springframework.util.StringUtils;
import com.bmc.thirdparty.org.springframework.web.servlet.LocaleResolver;
import com.bmc.thirdparty.org.springframework.web.util.CookieGenerator;
import com.bmc.thirdparty.org.springframework.web.util.WebUtils;
import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieLocaleResolver
extends CookieGenerator
implements LocaleResolver {
    public static final String LOCALE_REQUEST_ATTRIBUTE_NAME = (class$org$springframework$web$servlet$i18n$CookieLocaleResolver == null ? (class$org$springframework$web$servlet$i18n$CookieLocaleResolver = CookieLocaleResolver.class$("com.bmc.thirdparty.org.springframework.web.servlet.i18n.CookieLocaleResolver")) : class$org$springframework$web$servlet$i18n$CookieLocaleResolver).getName() + ".LOCALE";
    public static final String DEFAULT_COOKIE_NAME = (class$org$springframework$web$servlet$i18n$CookieLocaleResolver == null ? (class$org$springframework$web$servlet$i18n$CookieLocaleResolver = CookieLocaleResolver.class$("com.bmc.thirdparty.org.springframework.web.servlet.i18n.CookieLocaleResolver")) : class$org$springframework$web$servlet$i18n$CookieLocaleResolver).getName() + ".LOCALE";
    private Locale defaultLocale;
    static /* synthetic */ Class class$org$springframework$web$servlet$i18n$CookieLocaleResolver;

    public CookieLocaleResolver() {
        this.setCookieName(DEFAULT_COOKIE_NAME);
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    protected Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public Locale resolveLocale(HttpServletRequest request) {
        Locale locale = (Locale)request.getAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME);
        if (locale != null) {
            return locale;
        }
        Cookie cookie = WebUtils.getCookie(request, this.getCookieName());
        if (cookie != null) {
            locale = StringUtils.parseLocaleString(cookie.getValue());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Parsed cookie value [" + cookie.getValue() + "] into locale '" + locale + "'");
            }
            if (locale != null) {
                request.setAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME, (Object)locale);
                return locale;
            }
        }
        return this.determineDefaultLocale(request);
    }

    protected Locale determineDefaultLocale(HttpServletRequest request) {
        Locale defaultLocale = this.getDefaultLocale();
        if (defaultLocale == null) {
            defaultLocale = request.getLocale();
        }
        return defaultLocale;
    }

    public void setLocale(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        if (locale != null) {
            request.setAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME, (Object)locale);
            this.addCookie(response, locale.toString());
        } else {
            request.setAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME, (Object)request.getLocale());
            this.removeCookie(response);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

