/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.core.enums;

import com.bmc.thirdparty.org.springframework.core.enums.AbstractLabeledEnum;
import com.bmc.thirdparty.org.springframework.core.enums.StaticLabeledEnumResolver;

public abstract class StaticLabeledEnum
extends AbstractLabeledEnum {
    private final Short code;
    private final transient String label;

    protected StaticLabeledEnum(int code, String label) {
        this.code = new Short((short)code);
        this.label = label != null ? label : this.code.toString();
    }

    public Comparable getCode() {
        return this.code;
    }

    public String getLabel() {
        return this.label;
    }

    public short shortValue() {
        return ((Number)((Object)this.getCode())).shortValue();
    }

    protected Object readResolve() {
        return StaticLabeledEnumResolver.instance().getLabeledEnumByCode(this.getType(), this.getCode());
    }
}

