/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import org.acplt.oncrpc.ArRpcBindHelper;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcDumpResult;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcGetPortResult;
import org.acplt.oncrpc.OncRpcProgramNotRegisteredException;
import org.acplt.oncrpc.OncRpcServerIdent;
import org.acplt.oncrpc.OncRpcTcpClient;
import org.acplt.oncrpc.OncRpcUdpClient;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrBoolean;
import org.acplt.oncrpc.XdrString;
import org.acplt.oncrpc.XdrVoid;

public class OncRpcPortmapClient {
    public static final int PMAP_PORT = 111;
    public static final int PMAP_PROGRAM = 100000;
    public static final int PMAP_VERSION = 2;
    protected OncRpcClient portmapClient;

    public OncRpcPortmapClient(InetAddress inetAddress) throws OncRpcException, IOException {
        this(inetAddress, 17, 0);
    }

    public OncRpcPortmapClient(InetAddress inetAddress, int n) throws OncRpcException, IOException {
        this(inetAddress, n, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OncRpcPortmapClient(InetAddress inetAddress, int n, int n2) throws OncRpcException, IOException {
        int n3 = 2;
        String string = "";
        if (inetAddress instanceof Inet6Address) {
            n3 = 4;
            string = "6";
        }
        int n4 = n3;
        int n5 = ArRpcBindHelper.getRpcBindTryStopVersion(n3);
        block4 : switch (n) {
            case 17: {
                while (n4 >= n5) {
                    if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
                        System.out.println("creating rpcbind udp" + string + " client v" + n4 + ", the fall back rpcbind will be ver:" + n5);
                    }
                    boolean bl = false;
                    try {
                        this.portmapClient = new OncRpcUdpClient(inetAddress, 100000, n4, 111);
                        bl = true;
                        if (!ArRpcBindHelper.rpcbind_client_debug.booleanValue()) continue;
                        System.out.println("created rpcbind udp" + string + " client v" + n4);
                    }
                    catch (OncRpcException oncRpcException) {
                        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
                            System.out.println("rpcbind udp" + string + " client v" + n4 + " failed ");
                        }
                        if (n4 != n5) continue;
                        throw oncRpcException;
                    }
                    finally {
                        if (bl) break block4;
                        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
                            System.out.println("rpcbind udp" + string + " client v" + n4 + " failed ");
                        }
                        --n4;
                    }
                }
                break;
            }
            case 6: {
                while (n4 >= n5) {
                    if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
                        System.out.println("creating rpcbind tcp" + string + " client v" + n4 + ", the fall back rpcbind will be ver:" + n5);
                    }
                    boolean bl = false;
                    try {
                        this.portmapClient = new OncRpcTcpClient(inetAddress, 100000, n4, 111, 0, n2);
                        bl = true;
                        if (!ArRpcBindHelper.rpcbind_client_debug.booleanValue()) break block4;
                        System.out.println("created rpcbind tcp" + string + " client v" + n4);
                        break block4;
                    }
                    catch (OncRpcException oncRpcException) {
                        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
                            System.out.println("rpcbind tcp" + string + " client v" + n4 + " failed ");
                        }
                        if (n4 != n5) continue;
                        throw oncRpcException;
                    }
                    finally {
                        if (bl) break block4;
                        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
                            System.out.println("rpcbind tcp" + string + " client v" + n4 + " failed ");
                        }
                        --n4;
                    }
                }
                break;
            }
            default: {
                throw new OncRpcException(17);
            }
        }
    }

    public void close() throws OncRpcException {
        this.portmapClient.close();
    }

    public OncRpcClient getOncRpcClient() {
        return this.portmapClient;
    }

    public int getPort(int n, int n2, int n3) throws OncRpcException {
        XdrAble xdrAble = ArRpcBindHelper.getRpcBindRequestParams(this.portmapClient.host, 3, n, n2, n3, 0);
        XdrAble xdrAble2 = ArRpcBindHelper.getRpcBindResponseParams(this.portmapClient.host, 3, false);
        try {
            this.portmapClient.call(3, xdrAble, xdrAble2);
        }
        catch (OncRpcException oncRpcException) {
            throw new OncRpcException(14);
        }
        int n4 = 0;
        if (this.portmapClient.host instanceof Inet6Address) {
            String string = ((XdrString)xdrAble2).stringValue();
            if (string != null && string.length() > 0) {
                n4 = ArRpcBindHelper.getPort(string);
            }
        } else {
            n4 = ((OncRpcGetPortResult)xdrAble2).port;
        }
        if (n4 == 0) {
            if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
                System.out.println("rpcbind getPort did not get port back ");
            }
            throw new OncRpcProgramNotRegisteredException();
        }
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("rpcbind getPort = " + n4);
        }
        return n4;
    }

    public boolean setPort(int n, int n2, int n3, int n4) throws OncRpcException {
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("rpcbind setPort ... " + n4);
        }
        XdrAble xdrAble = ArRpcBindHelper.getRpcBindRequestParams(this.portmapClient.host, 1, n, n2, n3, n4);
        XdrAble xdrAble2 = ArRpcBindHelper.getRpcBindResponseParams(this.portmapClient.host, 1, false);
        try {
            this.portmapClient.call(1, xdrAble, xdrAble2);
        }
        catch (OncRpcException oncRpcException) {
            throw new OncRpcException(14);
        }
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("rpcbind setPort returns boolean: " + ((XdrBoolean)xdrAble2).booleanValue());
        }
        return ((XdrBoolean)xdrAble2).booleanValue();
    }

    public boolean unsetPort(int n, int n2) throws OncRpcException {
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("rpcbind unsetPort ... ");
        }
        XdrAble xdrAble = ArRpcBindHelper.getRpcBindRequestParams(this.portmapClient.host, 2, n, n2, 0, 0);
        XdrAble xdrAble2 = ArRpcBindHelper.getRpcBindResponseParams(this.portmapClient.host, 2, false);
        try {
            this.portmapClient.call(2, xdrAble, xdrAble2);
        }
        catch (OncRpcException oncRpcException) {
            throw new OncRpcException(14);
        }
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("rpcbind unsetPort returns boolean: " + ((XdrBoolean)xdrAble2).booleanValue());
        }
        return ((XdrBoolean)xdrAble2).booleanValue();
    }

    public OncRpcServerIdent[] listServers() throws OncRpcException {
        OncRpcDumpResult oncRpcDumpResult = new OncRpcDumpResult();
        try {
            this.portmapClient.call(4, XdrVoid.XDR_VOID, oncRpcDumpResult);
        }
        catch (OncRpcException oncRpcException) {
            throw new OncRpcException(14);
        }
        Object[] objectArray = new OncRpcServerIdent[oncRpcDumpResult.servers.size()];
        oncRpcDumpResult.servers.copyInto(objectArray);
        return objectArray;
    }

    public void ping() throws OncRpcException {
        try {
            this.portmapClient.call(0, XdrVoid.XDR_VOID, XdrVoid.XDR_VOID);
        }
        catch (OncRpcException oncRpcException) {
            throw new OncRpcException(14);
        }
    }
}

