/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.dao.annotation;

import com.bmc.thirdparty.org.springframework.aop.framework.Advised;
import com.bmc.thirdparty.org.springframework.aop.framework.ProxyFactory;
import com.bmc.thirdparty.org.springframework.aop.support.AopUtils;
import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanFactoryAware;
import com.bmc.thirdparty.org.springframework.beans.factory.ListableBeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanPostProcessor;
import com.bmc.thirdparty.org.springframework.core.Ordered;
import com.bmc.thirdparty.org.springframework.dao.annotation.PersistenceExceptionTranslationAdvisor;
import com.bmc.thirdparty.org.springframework.dao.support.ChainedPersistenceExceptionTranslator;
import com.bmc.thirdparty.org.springframework.dao.support.PersistenceExceptionTranslator;
import com.bmc.thirdparty.org.springframework.stereotype.Repository;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceExceptionTranslationPostProcessor
implements BeanPostProcessor,
BeanFactoryAware,
Ordered {
    private Class<? extends Annotation> repositoryAnnotationType = Repository.class;
    private PersistenceExceptionTranslationAdvisor persistenceExceptionTranslationAdvisor;

    public void setRepositoryAnnotationType(Class<? extends Annotation> repositoryAnnotationType) {
        Assert.notNull(repositoryAnnotationType, "requiredAnnotationType must not be null");
        this.repositoryAnnotationType = repositoryAnnotationType;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ListableBeanFactory)) {
            throw new IllegalArgumentException("Cannot use " + this.getClass().getSimpleName() + " without ListableBeanFactory");
        }
        ListableBeanFactory lbf = (ListableBeanFactory)beanFactory;
        List<PersistenceExceptionTranslator> pets = new LinkedList<PersistenceExceptionTranslator>();
        for (String petBeanName : lbf.getBeanNamesForType(PersistenceExceptionTranslator.class, false, false)) {
            pets.add((PersistenceExceptionTranslator)lbf.getBean(petBeanName));
        }
        pets = this.validateAndFilter(pets);
        ChainedPersistenceExceptionTranslator cpet = new ChainedPersistenceExceptionTranslator();
        for (PersistenceExceptionTranslator pet : pets) {
            cpet.addDelegate(pet);
        }
        this.persistenceExceptionTranslationAdvisor = new PersistenceExceptionTranslationAdvisor(cpet, this.repositoryAnnotationType);
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class targetClass;
        Advised advised;
        if (bean instanceof Advised) {
            advised = (Advised)bean;
            targetClass = advised.getTargetSource().getTargetClass();
        } else {
            targetClass = bean.getClass();
        }
        if (targetClass == null) {
            return bean;
        }
        if (AopUtils.canApply(this.persistenceExceptionTranslationAdvisor, targetClass)) {
            if (bean instanceof Advised) {
                advised = (Advised)bean;
                advised.addAdvisor(this.persistenceExceptionTranslationAdvisor);
                return bean;
            }
            ProxyFactory pf = new ProxyFactory(bean);
            pf.addAdvisor(this.persistenceExceptionTranslationAdvisor);
            return pf.getProxy();
        }
        return bean;
    }

    protected List<PersistenceExceptionTranslator> validateAndFilter(List<PersistenceExceptionTranslator> allPets) throws IllegalStateException {
        LinkedList<PersistenceExceptionTranslator> filteredPets = new LinkedList<PersistenceExceptionTranslator>();
        for (PersistenceExceptionTranslator pet : allPets) {
            filteredPets.add(pet);
        }
        if (filteredPets.isEmpty()) {
            throw new IllegalStateException("No persistence exception translators found. Cannot translate. Remove this PostProcessor");
        }
        return filteredPets;
    }
}

