/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.transaction.jta;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.FactoryBean;
import com.bmc.thirdparty.org.springframework.transaction.TransactionSystemException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.transaction.TransactionManager;

public class WebSphereTransactionManagerFactoryBean
implements FactoryBean {
    private static final String FACTORY_CLASS_5_1 = "com.ibm.ws.Transaction.TransactionManagerFactory";
    private static final String FACTORY_CLASS_5_0 = "com.ibm.ejs.jts.jta.TransactionManagerFactory";
    private static final String FACTORY_CLASS_4 = "com.ibm.ejs.jts.jta.JTSXA";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final TransactionManager transactionManager;

    public WebSphereTransactionManagerFactoryBean() throws TransactionSystemException {
        Class<?> clazz;
        try {
            this.logger.debug("Trying WebSphere 5.1+: com.ibm.ws.Transaction.TransactionManagerFactory");
            clazz = Class.forName(FACTORY_CLASS_5_1);
            this.logger.info("Found WebSphere 5.1+: com.ibm.ws.Transaction.TransactionManagerFactory");
        }
        catch (ClassNotFoundException ex) {
            this.logger.debug("Could not find WebSphere 5.1/6.0 TransactionManager factory class", ex);
            try {
                this.logger.debug("Trying WebSphere 5.0: com.ibm.ejs.jts.jta.TransactionManagerFactory");
                clazz = Class.forName(FACTORY_CLASS_5_0);
                this.logger.info("Found WebSphere 5.0: com.ibm.ejs.jts.jta.TransactionManagerFactory");
            }
            catch (ClassNotFoundException ex2) {
                this.logger.debug("Could not find WebSphere 5.0 TransactionManager factory class", ex2);
                try {
                    this.logger.debug("Trying WebSphere 4: com.ibm.ejs.jts.jta.JTSXA");
                    clazz = Class.forName(FACTORY_CLASS_4);
                    this.logger.info("Found WebSphere 4: com.ibm.ejs.jts.jta.JTSXA");
                }
                catch (ClassNotFoundException ex3) {
                    this.logger.debug("Could not find WebSphere 4 TransactionManager factory class", ex3);
                    throw new TransactionSystemException("Could not find any WebSphere TransactionManager factory class, neither for WebSphere version 5.1+ nor 5.0 nor 4");
                }
            }
        }
        try {
            Method method = clazz.getMethod("getTransactionManager", null);
            this.transactionManager = (TransactionManager)method.invoke(null, (Object[])null);
        }
        catch (InvocationTargetException ex) {
            throw new TransactionSystemException("WebSphere's TransactionManagerFactory.getTransactionManager method failed", ex.getTargetException());
        }
        catch (Exception ex) {
            throw new TransactionSystemException("Could not access WebSphere's TransactionManagerFactory.getTransactionManager method", ex);
        }
    }

    public Object getObject() {
        return this.transactionManager;
    }

    public Class getObjectType() {
        return this.transactionManager.getClass();
    }

    public boolean isSingleton() {
        return true;
    }
}

