/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.logging;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogConfigurationException;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public abstract class LogFactory {
    public static final String PRIORITY_KEY = "priority";
    public static final String TCCL_KEY = "use_tccl";
    public static final String FACTORY_PROPERTY = "com.bmc.thirdparty.org.apache.commons.logging.LogFactory";
    public static final String FACTORY_DEFAULT = "com.bmc.thirdparty.org.apache.commons.logging.impl.LogFactoryImpl";
    public static final String FACTORY_PROPERTIES = "commons-logging.properties";
    protected static final String SERVICE_ID = "META-INF/services/org.apache.commons.logging.LogFactory";
    public static final String DIAGNOSTICS_DEST_PROPERTY = "com.bmc.thirdparty.org.apache.commons.logging.diagnostics.dest";
    private static PrintStream diagnosticsStream = null;
    private static String diagnosticPrefix;
    public static final String HASHTABLE_IMPLEMENTATION_PROPERTY = "com.bmc.thirdparty.org.apache.commons.logging.LogFactory.HashtableImpl";
    private static final String WEAK_HASHTABLE_CLASSNAME = "com.bmc.thirdparty.org.apache.commons.logging.impl.WeakHashtable";
    private static ClassLoader thisClassLoader;
    protected static Hashtable factories;
    protected static LogFactory nullClassLoaderFactory;
    static /* synthetic */ Class class$org$apache$commons$logging$LogFactory;
    static /* synthetic */ Class class$java$lang$Thread;

    static {
        factories = null;
        nullClassLoaderFactory = null;
        thisClassLoader = LogFactory.getClassLoader(class$org$apache$commons$logging$LogFactory != null ? class$org$apache$commons$logging$LogFactory : (class$org$apache$commons$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY)));
        LogFactory.initDiagnostics();
        LogFactory.logClassLoaderEnvironment(class$org$apache$commons$logging$LogFactory != null ? class$org$apache$commons$logging$LogFactory : (class$org$apache$commons$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY)));
        factories = LogFactory.createFactoryStore();
        if (LogFactory.isDiagnosticsEnabled()) {
            LogFactory.logDiagnostic("BOOTSTRAP COMPLETED");
        }
    }

    protected LogFactory() {
    }

    private static void cacheFactory(ClassLoader classLoader, LogFactory factory) {
        if (factory != null) {
            if (classLoader == null) {
                nullClassLoaderFactory = factory;
            } else {
                factories.put(classLoader, factory);
            }
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected static Object createFactory(String factoryClass, ClassLoader classLoader) {
        Class<?> logFactoryClass = null;
        try {
            block19: {
                if (classLoader != null) {
                    try {
                        logFactoryClass = classLoader.loadClass(factoryClass);
                        if ((class$org$apache$commons$logging$LogFactory != null ? class$org$apache$commons$logging$LogFactory : (class$org$apache$commons$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY))).isAssignableFrom(logFactoryClass)) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.logDiagnostic("Loaded class " + logFactoryClass.getName() + " from classloader " + LogFactory.objectId(classLoader));
                            }
                        } else if (LogFactory.isDiagnosticsEnabled()) {
                            LogFactory.logDiagnostic("Factory class " + logFactoryClass.getName() + " loaded from classloader " + LogFactory.objectId(logFactoryClass.getClassLoader()) + " does not extend '" + (class$org$apache$commons$logging$LogFactory != null ? class$org$apache$commons$logging$LogFactory : (class$org$apache$commons$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY))).getName() + "' as loaded by this classloader.");
                            LogFactory.logHierarchy("[BAD CL TREE] ", classLoader);
                        }
                        return (LogFactory)logFactoryClass.newInstance();
                    }
                    catch (ClassNotFoundException ex) {
                        if (classLoader == thisClassLoader) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.logDiagnostic("Unable to locate any class called '" + factoryClass + "' via classloader " + LogFactory.objectId(classLoader));
                            }
                            throw ex;
                        }
                    }
                    catch (NoClassDefFoundError e2) {
                        if (classLoader == thisClassLoader) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.logDiagnostic("Class '" + factoryClass + "' cannot be loaded" + " via classloader " + LogFactory.objectId(classLoader) + " - it depends on some other class that cannot" + " be found.");
                            }
                            throw e2;
                        }
                    }
                    catch (ClassCastException classCastException) {
                        if (classLoader != thisClassLoader) break block19;
                        boolean implementsLogFactory = LogFactory.implementsLogFactory(logFactoryClass);
                        String msg = "The application has specified that a custom LogFactory implementation should be used but Class '" + factoryClass + "' cannot be converted to '" + (class$org$apache$commons$logging$LogFactory != null ? class$org$apache$commons$logging$LogFactory : (class$org$apache$commons$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY))).getName() + "'. ";
                        msg = implementsLogFactory ? String.valueOf(msg) + "The conflict is caused by the presence of multiple LogFactory classes in incompatible classloaders. " + "Background can be found in http://jakarta.apache.org/commons/logging/tech.html. " + "If you have not explicitly specified a custom LogFactory then it is likely that " + "the container has set one without your knowledge. " + "In this case, consider using the commons-logging-adapters.jar file or " + "specifying the standard LogFactory from the command line. " : String.valueOf(msg) + "Please check the custom implementation. ";
                        msg = String.valueOf(msg) + "Help can be found @http://jakarta.apache.org/commons/logging/troubleshooting.html.";
                        if (LogFactory.isDiagnosticsEnabled()) {
                            LogFactory.logDiagnostic(msg);
                        }
                        ClassCastException ex = new ClassCastException(msg);
                        throw ex;
                    }
                }
            }
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("Unable to load factory class via classloader " + LogFactory.objectId(classLoader) + " - trying the classloader associated with this LogFactory.");
            }
            logFactoryClass = Class.forName(factoryClass);
            return (LogFactory)logFactoryClass.newInstance();
        }
        catch (Exception e3) {
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("Unable to create LogFactory instance.");
            }
            if (logFactoryClass != null && !(class$org$apache$commons$logging$LogFactory != null ? class$org$apache$commons$logging$LogFactory : (class$org$apache$commons$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY))).isAssignableFrom(logFactoryClass)) {
                return new LogConfigurationException("The chosen LogFactory implementation does not extend LogFactory. Please check your configuration.", e3);
            }
            return new LogConfigurationException(e3);
        }
    }

    private static final Hashtable createFactoryStore() {
        Hashtable result;
        block5: {
            result = null;
            String storeImplementationClass = System.getProperty(HASHTABLE_IMPLEMENTATION_PROPERTY);
            if (storeImplementationClass == null) {
                storeImplementationClass = WEAK_HASHTABLE_CLASSNAME;
            }
            try {
                Class<?> implementationClass = Class.forName(storeImplementationClass);
                result = (Hashtable)implementationClass.newInstance();
            }
            catch (Throwable throwable) {
                if (WEAK_HASHTABLE_CLASSNAME.equals(storeImplementationClass)) break block5;
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic("[ERROR] LogFactory: Load of custom hashtable failed");
                }
                System.err.println("[ERROR] LogFactory: Load of custom hashtable failed");
            }
        }
        if (result == null) {
            result = new Hashtable();
        }
        return result;
    }

    protected static ClassLoader directGetContextClassLoader() throws LogConfigurationException {
        ClassLoader classLoader = null;
        try {
            Method method = (class$java$lang$Thread != null ? class$java$lang$Thread : (class$java$lang$Thread = LogFactory.class$("java.lang.Thread"))).getMethod("getContextClassLoader", null);
            try {
                classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), null);
            }
            catch (IllegalAccessException e2) {
                throw new LogConfigurationException("Unexpected IllegalAccessException", e2);
            }
            catch (InvocationTargetException e3) {
                if (!(e3.getTargetException() instanceof SecurityException)) {
                    throw new LogConfigurationException("Unexpected InvocationTargetException", e3.getTargetException());
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            classLoader = LogFactory.getClassLoader(class$org$apache$commons$logging$LogFactory != null ? class$org$apache$commons$logging$LogFactory : (class$org$apache$commons$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY)));
        }
        return classLoader;
    }

    public abstract Object getAttribute(String var1);

    public abstract String[] getAttributeNames();

    private static LogFactory getCachedFactory(ClassLoader contextClassLoader) {
        LogFactory factory = null;
        factory = contextClassLoader == null ? nullClassLoaderFactory : (LogFactory)factories.get(contextClassLoader);
        return factory;
    }

    protected static ClassLoader getClassLoader(Class clazz) {
        try {
            return clazz.getClassLoader();
        }
        catch (SecurityException ex) {
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("Unable to get classloader for class '" + clazz + "' due to security restrictions - " + ex.getMessage());
            }
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final Properties getConfigurationFile(ClassLoader classLoader, String fileName) {
        URL propsUrl;
        Properties props;
        block10: {
            props = null;
            double priority = 0.0;
            propsUrl = null;
            try {
                Enumeration urls = LogFactory.getResources(classLoader, fileName);
                if (urls == null) {
                    return null;
                }
                while (urls.hasMoreElements()) {
                    URL url = (URL)urls.nextElement();
                    Properties newProps = LogFactory.getProperties(url);
                    if (newProps == null) continue;
                    if (props == null) {
                        propsUrl = url;
                        props = newProps;
                        String priorityStr = props.getProperty(PRIORITY_KEY);
                        priority = 0.0;
                        if (priorityStr != null) {
                            priority = Double.parseDouble(priorityStr);
                        }
                        if (!LogFactory.isDiagnosticsEnabled()) continue;
                        LogFactory.logDiagnostic("[LOOKUP] Properties file found at '" + url + "'" + " with priority " + priority);
                        continue;
                    }
                    String newPriorityStr = newProps.getProperty(PRIORITY_KEY);
                    double newPriority = 0.0;
                    if (newPriorityStr != null) {
                        newPriority = Double.parseDouble(newPriorityStr);
                    }
                    if (newPriority > priority) {
                        if (LogFactory.isDiagnosticsEnabled()) {
                            LogFactory.logDiagnostic("[LOOKUP] Properties file at '" + url + "'" + " with priority " + newPriority + " overrides file at '" + propsUrl + "'" + " with priority " + priority);
                        }
                        propsUrl = url;
                        props = newProps;
                        priority = newPriority;
                        continue;
                    }
                    if (!LogFactory.isDiagnosticsEnabled()) continue;
                    LogFactory.logDiagnostic("[LOOKUP] Properties file at '" + url + "'" + " with priority " + newPriority + " does not override file at '" + propsUrl + "'" + " with priority " + priority);
                }
            }
            catch (SecurityException securityException) {
                if (!LogFactory.isDiagnosticsEnabled()) break block10;
                LogFactory.logDiagnostic("SecurityException thrown while trying to find/read config files.");
            }
        }
        if (!LogFactory.isDiagnosticsEnabled()) return props;
        if (props == null) {
            LogFactory.logDiagnostic("[LOOKUP] No properties file of name '" + fileName + "' found.");
            return props;
        }
        LogFactory.logDiagnostic("[LOOKUP] Properties file of name '" + fileName + "' found at '" + propsUrl + '\"');
        return props;
    }

    protected static ClassLoader getContextClassLoader() throws LogConfigurationException {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return LogFactory.directGetContextClassLoader();
            }
        });
    }

    public static LogFactory getFactory() throws LogConfigurationException {
        String factoryClass;
        ClassLoader baseClassLoader;
        Properties props;
        LogFactory factory;
        ClassLoader contextClassLoader;
        block38: {
            String useTCCLStr;
            contextClassLoader = LogFactory.getContextClassLoader();
            if (contextClassLoader == null && LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("Context classloader is null.");
            }
            if ((factory = LogFactory.getCachedFactory(contextClassLoader)) != null) {
                return factory;
            }
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("[LOOKUP] LogFactory implementation requested for the first time for context classloader " + LogFactory.objectId(contextClassLoader));
                LogFactory.logHierarchy("[LOOKUP] ", contextClassLoader);
            }
            props = LogFactory.getConfigurationFile(contextClassLoader, FACTORY_PROPERTIES);
            baseClassLoader = contextClassLoader;
            if (props != null && (useTCCLStr = props.getProperty(TCCL_KEY)) != null && !Boolean.valueOf(useTCCLStr).booleanValue()) {
                baseClassLoader = thisClassLoader;
            }
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("[LOOKUP] Looking for system property [org.apache.commons.logging.LogFactory] to define the LogFactory subclass to use...");
            }
            try {
                factoryClass = System.getProperty(FACTORY_PROPERTY);
                if (factoryClass != null) {
                    if (LogFactory.isDiagnosticsEnabled()) {
                        LogFactory.logDiagnostic("[LOOKUP] Creating an instance of LogFactory class '" + factoryClass + "' as specified by system property " + FACTORY_PROPERTY);
                    }
                    factory = LogFactory.newFactory(factoryClass, baseClassLoader, contextClassLoader);
                } else if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic("[LOOKUP] No system property [org.apache.commons.logging.LogFactory] defined.");
                }
            }
            catch (SecurityException e2) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic("[LOOKUP] A security exception occurred while trying to create an instance of the custom factory class: [" + e2.getMessage().trim() + "]. Trying alternative implementations...");
                }
            }
            catch (RuntimeException e3) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic("[LOOKUP] An exception occurred while trying to create an instance of the custom factory class: [" + e3.getMessage().trim() + "] as specified by a system property.");
                }
                throw e3;
            }
            if (factory == null) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic("[LOOKUP] Looking for a resource file of name [META-INF/services/org.apache.commons.logging.LogFactory] to define the LogFactory subclass to use...");
                }
                try {
                    InputStream is = LogFactory.getResourceAsStream(contextClassLoader, SERVICE_ID);
                    if (is != null) {
                        BufferedReader rd;
                        try {
                            rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            rd = new BufferedReader(new InputStreamReader(is));
                        }
                        String factoryClassName = rd.readLine();
                        rd.close();
                        if (factoryClassName != null && !"".equals(factoryClassName)) {
                            if (LogFactory.isDiagnosticsEnabled()) {
                                LogFactory.logDiagnostic("[LOOKUP]  Creating an instance of LogFactory class " + factoryClassName + " as specified by file '" + SERVICE_ID + "' which was present in the path of the context" + " classloader.");
                            }
                            factory = LogFactory.newFactory(factoryClassName, baseClassLoader, contextClassLoader);
                        }
                        break block38;
                    }
                    if (LogFactory.isDiagnosticsEnabled()) {
                        LogFactory.logDiagnostic("[LOOKUP] No resource file with name 'META-INF/services/org.apache.commons.logging.LogFactory' found.");
                    }
                }
                catch (Exception ex) {
                    if (!LogFactory.isDiagnosticsEnabled()) break block38;
                    LogFactory.logDiagnostic("[LOOKUP] A security exception occurred while trying to create an instance of the custom factory class: [" + ex.getMessage().trim() + "]. Trying alternative implementations...");
                }
            }
        }
        if (factory == null) {
            if (props != null) {
                if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic("[LOOKUP] Looking in properties file for entry with key 'org.apache.commons.logging.LogFactory' to define the LogFactory subclass to use...");
                }
                if ((factoryClass = props.getProperty(FACTORY_PROPERTY)) != null) {
                    if (LogFactory.isDiagnosticsEnabled()) {
                        LogFactory.logDiagnostic("[LOOKUP] Properties file specifies LogFactory subclass '" + factoryClass + "'");
                    }
                    factory = LogFactory.newFactory(factoryClass, baseClassLoader, contextClassLoader);
                } else if (LogFactory.isDiagnosticsEnabled()) {
                    LogFactory.logDiagnostic("[LOOKUP] Properties file has no entry specifying LogFactory subclass.");
                }
            } else if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("[LOOKUP] No properties file available to determine LogFactory subclass from..");
            }
        }
        if (factory == null) {
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("[LOOKUP] Loading the default LogFactory implementation 'org.apache.commons.logging.impl.LogFactoryImpl' via the same classloader that loaded this LogFactory class (ie not looking in the context classloader).");
            }
            factory = LogFactory.newFactory(FACTORY_DEFAULT, thisClassLoader, contextClassLoader);
        }
        if (factory != null) {
            LogFactory.cacheFactory(contextClassLoader, factory);
            if (props != null) {
                Enumeration<?> names = props.propertyNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    String value = props.getProperty(name);
                    factory.setAttribute(name, value);
                }
            }
        }
        return factory;
    }

    public abstract Log getInstance(Class var1) throws LogConfigurationException;

    public abstract Log getInstance(String var1) throws LogConfigurationException;

    public static Log getLog(Class clazz) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(clazz);
    }

    public static Log getLog(String name) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(name);
    }

    private static Properties getProperties(final URL url) {
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                block3: {
                    try {
                        InputStream stream = url.openStream();
                        if (stream != null) {
                            Properties props = new Properties();
                            props.load(stream);
                            stream.close();
                            return props;
                        }
                    }
                    catch (IOException iOException) {
                        if (!LogFactory.isDiagnosticsEnabled()) break block3;
                        LogFactory.logDiagnostic("Unable to read URL " + url);
                    }
                }
                return null;
            }
        };
        return (Properties)AccessController.doPrivileged(action);
    }

    private static InputStream getResourceAsStream(final ClassLoader loader, final String name) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (loader != null) {
                    return loader.getResourceAsStream(name);
                }
                return ClassLoader.getSystemResourceAsStream(name);
            }
        });
    }

    private static Enumeration getResources(final ClassLoader loader, final String name) {
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                try {
                    if (loader != null) {
                        return loader.getResources(name);
                    }
                    return ClassLoader.getSystemResources(name);
                }
                catch (IOException e2) {
                    if (LogFactory.isDiagnosticsEnabled()) {
                        LogFactory.logDiagnostic("Exception while trying to find configuration file " + name + ":" + e2.getMessage());
                    }
                    return null;
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    return null;
                }
            }
        };
        Object result = AccessController.doPrivileged(action);
        return (Enumeration)result;
    }

    private static boolean implementsLogFactory(Class logFactoryClass) {
        boolean implementsLogFactory;
        block6: {
            implementsLogFactory = false;
            if (logFactoryClass == null) break block6;
            try {
                ClassLoader logFactoryClassLoader = logFactoryClass.getClassLoader();
                if (logFactoryClassLoader == null) {
                    LogFactory.logDiagnostic("[CUSTOM LOG FACTORY] was loaded by the boot classloader");
                    break block6;
                }
                LogFactory.logHierarchy("[CUSTOM LOG FACTORY] ", logFactoryClassLoader);
                Class<?> factoryFromCustomLoader = Class.forName(FACTORY_PROPERTY, false, logFactoryClassLoader);
                implementsLogFactory = factoryFromCustomLoader.isAssignableFrom(logFactoryClass);
                if (implementsLogFactory) {
                    LogFactory.logDiagnostic("[CUSTOM LOG FACTORY] " + logFactoryClass.getName() + " implements LogFactory but was loaded by an incompatible classloader.");
                    break block6;
                }
                LogFactory.logDiagnostic("[CUSTOM LOG FACTORY] " + logFactoryClass.getName() + " does not implement LogFactory.");
            }
            catch (SecurityException e2) {
                LogFactory.logDiagnostic("[CUSTOM LOG FACTORY] SecurityException thrown whilst trying to determine whether the compatibility was caused by a classloader conflict: " + e2.getMessage());
            }
            catch (LinkageError e3) {
                LogFactory.logDiagnostic("[CUSTOM LOG FACTORY] LinkageError thrown whilst trying to determine whether the compatibility was caused by a classloader conflict: " + e3.getMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                LogFactory.logDiagnostic("[CUSTOM LOG FACTORY] LogFactory class cannot be loaded by classloader which loaded the custom LogFactory implementation. Is the custom factory in the right classloader?");
            }
        }
        return implementsLogFactory;
    }

    private static void initDiagnostics() {
        String classLoaderName;
        String dest;
        try {
            dest = System.getProperty(DIAGNOSTICS_DEST_PROPERTY);
            if (dest == null) {
                return;
            }
        }
        catch (SecurityException securityException) {
            return;
        }
        if (dest.equals("STDOUT")) {
            diagnosticsStream = System.out;
        } else if (dest.equals("STDERR")) {
            diagnosticsStream = System.err;
        } else {
            try {
                FileOutputStream fos = new FileOutputStream(dest, true);
                diagnosticsStream = new PrintStream(fos);
            }
            catch (IOException iOException) {
                return;
            }
        }
        try {
            ClassLoader classLoader = thisClassLoader;
            classLoaderName = thisClassLoader == null ? "BOOTLOADER" : LogFactory.objectId(classLoader);
        }
        catch (SecurityException securityException) {
            classLoaderName = "UNKNOWN";
        }
        diagnosticPrefix = "[LogFactory from " + classLoaderName + "] ";
    }

    protected static boolean isDiagnosticsEnabled() {
        return diagnosticsStream != null;
    }

    private static void logClassLoaderEnvironment(Class clazz) {
        ClassLoader classLoader;
        if (!LogFactory.isDiagnosticsEnabled()) {
            return;
        }
        try {
            LogFactory.logDiagnostic("[ENV] Extension directories (java.ext.dir): " + System.getProperty("java.ext.dir"));
            LogFactory.logDiagnostic("[ENV] Application classpath (java.class.path): " + System.getProperty("java.class.path"));
        }
        catch (SecurityException securityException) {
            LogFactory.logDiagnostic("[ENV] Security setting prevent interrogation of system classpaths.");
        }
        String className = clazz.getName();
        try {
            classLoader = LogFactory.getClassLoader(clazz);
        }
        catch (SecurityException securityException) {
            LogFactory.logDiagnostic("[ENV] Security forbids determining the classloader for " + className);
            return;
        }
        LogFactory.logDiagnostic("[ENV] Class " + className + " was loaded via classloader " + LogFactory.objectId(classLoader));
        LogFactory.logHierarchy("[ENV] Ancestry of classloader which loaded " + className + " is ", classLoader);
    }

    private static final void logDiagnostic(String msg) {
        if (diagnosticsStream != null) {
            diagnosticsStream.print(diagnosticPrefix);
            diagnosticsStream.println(msg);
            diagnosticsStream.flush();
        }
    }

    private static void logHierarchy(String prefix, ClassLoader classLoader) {
        ClassLoader systemClassLoader;
        if (!LogFactory.isDiagnosticsEnabled()) {
            return;
        }
        if (classLoader != null) {
            String classLoaderString = classLoader.toString();
            LogFactory.logDiagnostic(String.valueOf(prefix) + LogFactory.objectId(classLoader) + " == '" + classLoaderString + "'");
        }
        try {
            systemClassLoader = ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException securityException) {
            LogFactory.logDiagnostic(String.valueOf(prefix) + "Security forbids determining the system classloader.");
            return;
        }
        if (classLoader != null) {
            StringBuffer buf;
            block9: {
                buf = new StringBuffer(String.valueOf(prefix) + "ClassLoader tree:");
                do {
                    buf.append(LogFactory.objectId(classLoader));
                    if (classLoader == systemClassLoader) {
                        buf.append(" (SYSTEM) ");
                    }
                    try {
                        classLoader = classLoader.getParent();
                    }
                    catch (SecurityException securityException) {
                        buf.append(" --> SECRET");
                        break block9;
                    }
                    buf.append(" --> ");
                } while (classLoader != null);
                buf.append("BOOT");
            }
            LogFactory.logDiagnostic(buf.toString());
        }
    }

    protected static final void logRawDiagnostic(String msg) {
        if (diagnosticsStream != null) {
            diagnosticsStream.println(msg);
            diagnosticsStream.flush();
        }
    }

    protected static LogFactory newFactory(String factoryClass, ClassLoader classLoader) {
        return LogFactory.newFactory(factoryClass, classLoader, null);
    }

    protected static LogFactory newFactory(final String factoryClass, final ClassLoader classLoader, ClassLoader contextClassLoader) throws LogConfigurationException {
        Object result = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return LogFactory.createFactory(factoryClass, classLoader);
            }
        });
        if (result instanceof LogConfigurationException) {
            LogConfigurationException ex = (LogConfigurationException)result;
            if (LogFactory.isDiagnosticsEnabled()) {
                LogFactory.logDiagnostic("An error occurred while loading the factory class:" + ex.getMessage());
            }
            throw ex;
        }
        if (LogFactory.isDiagnosticsEnabled()) {
            LogFactory.logDiagnostic("Created object " + LogFactory.objectId(result) + " to manage classloader " + LogFactory.objectId(contextClassLoader));
        }
        return (LogFactory)result;
    }

    public static String objectId(Object o2) {
        if (o2 == null) {
            return "null";
        }
        return String.valueOf(o2.getClass().getName()) + "@" + System.identityHashCode(o2);
    }

    public abstract void release();

    public static void release(ClassLoader classLoader) {
        if (LogFactory.isDiagnosticsEnabled()) {
            LogFactory.logDiagnostic("Releasing factory for classloader " + LogFactory.objectId(classLoader));
        }
        Hashtable hashtable = factories;
        synchronized (hashtable) {
            if (classLoader == null) {
                if (nullClassLoaderFactory != null) {
                    nullClassLoaderFactory.release();
                    nullClassLoaderFactory = null;
                }
            } else {
                LogFactory factory = (LogFactory)factories.get(classLoader);
                if (factory != null) {
                    factory.release();
                    factories.remove(classLoader);
                }
            }
        }
    }

    public static void releaseAll() {
        if (LogFactory.isDiagnosticsEnabled()) {
            LogFactory.logDiagnostic("Releasing factory for all classloaders.");
        }
        Hashtable hashtable = factories;
        synchronized (hashtable) {
            Enumeration elements = factories.elements();
            while (elements.hasMoreElements()) {
                LogFactory element = (LogFactory)elements.nextElement();
                element.release();
            }
            factories.clear();
            if (nullClassLoaderFactory != null) {
                nullClassLoaderFactory.release();
                nullClassLoaderFactory = null;
            }
        }
    }

    public abstract void removeAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2);
}

