/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.context.support;

import com.bmc.thirdparty.org.springframework.context.ApplicationContext;
import com.bmc.thirdparty.org.springframework.context.support.ApplicationObjectSupport;
import com.bmc.thirdparty.org.springframework.web.context.ServletContextAware;
import com.bmc.thirdparty.org.springframework.web.context.WebApplicationContext;
import com.bmc.thirdparty.org.springframework.web.util.WebUtils;
import java.io.File;
import javax.servlet.ServletContext;

public abstract class WebApplicationObjectSupport
extends ApplicationObjectSupport
implements ServletContextAware {
    private ServletContext servletContext;

    public final void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected boolean isContextRequired() {
        return true;
    }

    protected final WebApplicationContext getWebApplicationContext() throws IllegalStateException {
        ApplicationContext ctx = this.getApplicationContext();
        if (!(ctx instanceof WebApplicationContext)) {
            throw new IllegalStateException("WebApplicationObjectSupport instance [" + this + "] does not run in a WebApplicationContext but in: " + ctx);
        }
        return (WebApplicationContext)this.getApplicationContext();
    }

    protected final ServletContext getServletContext() throws IllegalStateException {
        if (this.servletContext != null) {
            return this.servletContext;
        }
        return this.getWebApplicationContext().getServletContext();
    }

    protected final File getTempDir() throws IllegalStateException {
        return WebUtils.getTempDir(this.getServletContext());
    }
}

