/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.transaction.jta;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.transaction.jta.UserTransactionAdapter;
import com.bmc.thirdparty.org.springframework.transaction.support.TransactionSynchronization;
import com.bmc.thirdparty.org.springframework.transaction.support.TransactionSynchronizationManager;
import com.bmc.thirdparty.org.springframework.util.Assert;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public class SpringJtaSynchronizationAdapter
implements Synchronization {
    protected static final Log logger = LogFactory.getLog(class$org$springframework$transaction$jta$SpringJtaSynchronizationAdapter == null ? (class$org$springframework$transaction$jta$SpringJtaSynchronizationAdapter = SpringJtaSynchronizationAdapter.class$("com.bmc.thirdparty.org.springframework.transaction.jta.SpringJtaSynchronizationAdapter")) : class$org$springframework$transaction$jta$SpringJtaSynchronizationAdapter);
    private final TransactionSynchronization springSynchronization;
    private UserTransaction jtaTransaction;
    private boolean beforeCompletionCalled = false;
    static /* synthetic */ Class class$org$springframework$transaction$jta$SpringJtaSynchronizationAdapter;

    public SpringJtaSynchronizationAdapter(TransactionSynchronization springSynchronization, UserTransaction jtaUserTransaction) {
        Assert.notNull(springSynchronization, "TransactionSynchronization must not be null");
        this.springSynchronization = springSynchronization;
        this.jtaTransaction = jtaUserTransaction;
    }

    public SpringJtaSynchronizationAdapter(TransactionSynchronization springSynchronization, TransactionManager jtaTransactionManager) {
        this(springSynchronization, jtaTransactionManager != null ? new UserTransactionAdapter(jtaTransactionManager) : null);
    }

    public void beforeCompletion() {
        try {
            boolean readOnly = TransactionSynchronizationManager.isCurrentTransactionReadOnly();
            this.springSynchronization.beforeCommit(readOnly);
        }
        catch (RuntimeException ex) {
            this.setRollbackOnlyIfPossible();
            throw ex;
        }
        catch (Error err) {
            this.setRollbackOnlyIfPossible();
            throw err;
        }
        finally {
            this.beforeCompletionCalled = true;
            this.springSynchronization.beforeCompletion();
        }
    }

    private void setRollbackOnlyIfPossible() {
        if (this.jtaTransaction != null) {
            try {
                this.jtaTransaction.setRollbackOnly();
            }
            catch (SystemException ex) {
                logger.error("Could not set JTA transaction rollback-only", ex);
            }
        }
    }

    public void afterCompletion(int status) {
        if (!this.beforeCompletionCalled) {
            this.springSynchronization.beforeCompletion();
        }
        switch (status) {
            case 3: {
                this.springSynchronization.afterCompletion(0);
                break;
            }
            case 4: {
                this.springSynchronization.afterCompletion(1);
                break;
            }
            default: {
                this.springSynchronization.afterCompletion(2);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

