/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans.factory.config;

import com.bmc.thirdparty.org.springframework.beans.MutablePropertyValues;
import com.bmc.thirdparty.org.springframework.beans.PropertyValue;
import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanDefinitionHolder;
import com.bmc.thirdparty.org.springframework.beans.factory.config.ConstructorArgumentValues;
import com.bmc.thirdparty.org.springframework.beans.factory.config.RuntimeBeanReference;
import com.bmc.thirdparty.org.springframework.beans.factory.config.TypedStringValue;
import com.bmc.thirdparty.org.springframework.util.ObjectUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BeanDefinitionVisitor {
    public void visitBeanDefinition(BeanDefinition beanDefinition) {
        MutablePropertyValues pvs = beanDefinition.getPropertyValues();
        this.visitBeanClassName(beanDefinition);
        this.visitPropertyValues(pvs);
        ConstructorArgumentValues cas = beanDefinition.getConstructorArgumentValues();
        this.visitIndexedArgumentValues(cas.getIndexedArgumentValues());
        this.visitGenericArgumentValues(cas.getGenericArgumentValues());
    }

    protected void visitBeanClassName(BeanDefinition beanDefinition) {
        String resolvedName;
        String beanClassName = beanDefinition.getBeanClassName();
        if (beanClassName != null && !beanClassName.equals(resolvedName = this.resolveStringValue(beanClassName))) {
            beanDefinition.setBeanClassName(resolvedName);
        }
    }

    protected void visitPropertyValues(MutablePropertyValues pvs) {
        PropertyValue[] pvArray = pvs.getPropertyValues();
        for (int i2 = 0; i2 < pvArray.length; ++i2) {
            PropertyValue pv = pvArray[i2];
            Object newVal = this.resolveValue(pv.getValue());
            if (ObjectUtils.nullSafeEquals(newVal, pv.getValue())) continue;
            pvs.addPropertyValue(pv.getName(), newVal);
        }
    }

    protected void visitIndexedArgumentValues(Map ias) {
        Iterator it = ias.values().iterator();
        while (it.hasNext()) {
            ConstructorArgumentValues.ValueHolder valueHolder = (ConstructorArgumentValues.ValueHolder)it.next();
            Object newVal = this.resolveValue(valueHolder.getValue());
            if (ObjectUtils.nullSafeEquals(newVal, valueHolder.getValue())) continue;
            valueHolder.setValue(newVal);
        }
    }

    protected void visitGenericArgumentValues(List gas) {
        Iterator it = gas.iterator();
        while (it.hasNext()) {
            ConstructorArgumentValues.ValueHolder valueHolder = (ConstructorArgumentValues.ValueHolder)it.next();
            Object newVal = this.resolveValue(valueHolder.getValue());
            if (ObjectUtils.nullSafeEquals(newVal, valueHolder.getValue())) continue;
            valueHolder.setValue(newVal);
        }
    }

    protected Object resolveValue(Object value) {
        if (value instanceof BeanDefinition) {
            this.visitBeanDefinition((BeanDefinition)value);
        } else if (value instanceof BeanDefinitionHolder) {
            this.visitBeanDefinition(((BeanDefinitionHolder)value).getBeanDefinition());
        } else if (value instanceof RuntimeBeanReference) {
            RuntimeBeanReference ref = (RuntimeBeanReference)value;
            String newBeanName = this.resolveStringValue(ref.getBeanName());
            if (!newBeanName.equals(ref.getBeanName())) {
                return new RuntimeBeanReference(newBeanName);
            }
        } else if (value instanceof List) {
            this.visitList((List)value);
        } else if (value instanceof Set) {
            this.visitSet((Set)value);
        } else if (value instanceof Map) {
            this.visitMap((Map)value);
        } else if (value instanceof TypedStringValue) {
            TypedStringValue typedStringValue = (TypedStringValue)value;
            String visitdString = this.resolveStringValue(typedStringValue.getValue());
            typedStringValue.setValue(visitdString);
        } else if (value instanceof String) {
            return this.resolveStringValue((String)value);
        }
        return value;
    }

    protected void visitList(List listVal) {
        for (int i2 = 0; i2 < listVal.size(); ++i2) {
            Object elem = listVal.get(i2);
            Object newVal = this.resolveValue(elem);
            if (ObjectUtils.nullSafeEquals(newVal, elem)) continue;
            listVal.set(i2, newVal);
        }
    }

    protected void visitSet(Set setVal) {
        Iterator it = new HashSet(setVal).iterator();
        while (it.hasNext()) {
            Object elem = it.next();
            Object newVal = this.resolveValue(elem);
            if (ObjectUtils.nullSafeEquals(newVal, elem)) continue;
            setVal.remove(elem);
            setVal.add(newVal);
        }
    }

    protected void visitMap(Map mapVal) {
        Iterator it = new HashMap(mapVal).entrySet().iterator();
        while (it.hasNext()) {
            Object newKey;
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            boolean isNewKey = !ObjectUtils.nullSafeEquals(key, newKey = this.resolveValue(key));
            Object val = entry.getValue();
            Object newVal = this.resolveValue(val);
            if (isNewKey) {
                mapVal.remove(key);
            }
            if (!isNewKey && ObjectUtils.nullSafeEquals(newVal, val)) continue;
            mapVal.put(newKey, newVal);
        }
    }

    protected abstract String resolveStringValue(String var1);
}

