/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.context.support;

import com.bmc.thirdparty.org.springframework.context.ApplicationEvent;

public class RequestHandledEvent
extends ApplicationEvent {
    private String sessionId;
    private String userName;
    private final long processingTimeMillis;
    private Throwable failureCause;

    public RequestHandledEvent(Object source, String sessionId, String userName, long processingTimeMillis) {
        super(source);
        this.sessionId = sessionId;
        this.userName = userName;
        this.processingTimeMillis = processingTimeMillis;
    }

    public RequestHandledEvent(Object source, String sessionId, String userName, long processingTimeMillis, Throwable failureCause) {
        this(source, sessionId, userName, processingTimeMillis);
        this.failureCause = failureCause;
    }

    public long getProcessingTimeMillis() {
        return this.processingTimeMillis;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean wasFailure() {
        return this.failureCause != null;
    }

    public Throwable getFailureCause() {
        return this.failureCause;
    }

    public String getShortDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("session=[").append(this.sessionId).append("]; ");
        sb.append("user=[").append(this.userName).append("]; ");
        return sb.toString();
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("session=[").append(this.sessionId).append("]; ");
        sb.append("user=[").append(this.userName).append("]; ");
        sb.append("time=[").append(this.processingTimeMillis).append("ms]; ");
        sb.append("status=[");
        if (!this.wasFailure()) {
            sb.append("OK");
        } else {
            sb.append("failed: ").append(this.failureCause);
        }
        sb.append(']');
        return sb.toString();
    }

    public String toString() {
        return "RequestHandledEvent: " + this.getDescription();
    }
}

