/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.remoting.support;

import com.bmc.thirdparty.org.aopalliance.intercept.MethodInterceptor;
import com.bmc.thirdparty.org.aopalliance.intercept.MethodInvocation;
import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import java.lang.reflect.Method;

public class RemoteInvocationTraceInterceptor
implements MethodInterceptor {
    protected static final Log logger = LogFactory.getLog(class$org$springframework$remoting$support$RemoteInvocationTraceInterceptor == null ? (class$org$springframework$remoting$support$RemoteInvocationTraceInterceptor = RemoteInvocationTraceInterceptor.class$("com.bmc.thirdparty.org.springframework.remoting.support.RemoteInvocationTraceInterceptor")) : class$org$springframework$remoting$support$RemoteInvocationTraceInterceptor);
    private final String exporterName;
    static /* synthetic */ Class class$org$springframework$remoting$support$RemoteInvocationTraceInterceptor;

    public RemoteInvocationTraceInterceptor(String protocolName) {
        this.exporterName = protocolName;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (logger.isDebugEnabled()) {
            logger.debug("Incoming " + this.exporterName + " remote call: " + ClassUtils.getQualifiedMethodName(method));
        }
        try {
            Object retVal = invocation.proceed();
            if (logger.isDebugEnabled()) {
                logger.debug("Finished processing of " + this.exporterName + " remote call: " + ClassUtils.getQualifiedMethodName(method));
            }
            return retVal;
        }
        catch (Throwable ex) {
            if (ex instanceof RuntimeException || ex instanceof Error) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Processing of " + this.exporterName + " remote call resulted in fatal exception: " + ClassUtils.getQualifiedMethodName(method), ex);
                }
            } else if (logger.isInfoEnabled()) {
                logger.info("Processing of " + this.exporterName + " remote call resulted in exception: " + ClassUtils.getQualifiedMethodName(method), ex);
            }
            throw ex;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

