/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans.factory.xml;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanDefinitionHolder;
import com.bmc.thirdparty.org.springframework.beans.factory.parsing.BeanComponentDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import com.bmc.thirdparty.org.springframework.beans.factory.xml.BeanDefinitionDocumentReader;
import com.bmc.thirdparty.org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import com.bmc.thirdparty.org.springframework.beans.factory.xml.XmlReaderContext;
import com.bmc.thirdparty.org.springframework.core.io.Resource;
import com.bmc.thirdparty.org.springframework.core.io.support.ResourcePatternUtils;
import com.bmc.thirdparty.org.springframework.util.SystemPropertyUtils;
import com.bmc.thirdparty.org.springframework.util.xml.DomUtils;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultBeanDefinitionDocumentReader
implements BeanDefinitionDocumentReader {
    public static final String BEAN_ELEMENT = "bean";
    public static final String ALIAS_ELEMENT = "alias";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String ALIAS_ATTRIBUTE = "alias";
    public static final String IMPORT_ELEMENT = "import";
    public static final String RESOURCE_ATTRIBUTE = "resource";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private XmlReaderContext readerContext;

    public void registerBeanDefinitions(Document doc, XmlReaderContext readerContext) {
        this.readerContext = readerContext;
        this.logger.debug("Loading bean definitions");
        Element root = doc.getDocumentElement();
        BeanDefinitionParserDelegate delegate = this.createHelper(readerContext, root);
        this.preProcessXml(root);
        this.parseBeanDefinitions(root, delegate);
        this.postProcessXml(root);
    }

    protected BeanDefinitionParserDelegate createHelper(XmlReaderContext readerContext, Element root) {
        BeanDefinitionParserDelegate delegate = new BeanDefinitionParserDelegate(readerContext);
        delegate.initDefaults(root);
        return delegate;
    }

    protected final XmlReaderContext getReaderContext() {
        return this.readerContext;
    }

    protected Object extractSource(Element ele) {
        return this.getReaderContext().extractSource(ele);
    }

    protected void preProcessXml(Element root) {
    }

    protected void parseBeanDefinitions(Element root, BeanDefinitionParserDelegate delegate) {
        if (delegate.isDefaultNamespace(root.getNamespaceURI())) {
            NodeList nl = root.getChildNodes();
            for (int i2 = 0; i2 < nl.getLength(); ++i2) {
                Node node = nl.item(i2);
                if (!(node instanceof Element)) continue;
                Element ele = (Element)node;
                String namespaceUri = ele.getNamespaceURI();
                if (delegate.isDefaultNamespace(namespaceUri)) {
                    this.parseDefaultElement(ele, delegate);
                    continue;
                }
                delegate.parseCustomElement(ele);
            }
        } else {
            delegate.parseCustomElement(root);
        }
    }

    private void parseDefaultElement(Element ele, BeanDefinitionParserDelegate delegate) {
        BeanDefinitionHolder bdHolder;
        if (DomUtils.nodeNameEquals(ele, IMPORT_ELEMENT)) {
            this.importBeanDefinitionResource(ele);
        } else if (DomUtils.nodeNameEquals(ele, "alias")) {
            String name = ele.getAttribute(NAME_ATTRIBUTE);
            String alias = ele.getAttribute("alias");
            this.getReaderContext().getReader().getBeanFactory().registerAlias(name, alias);
            this.getReaderContext().fireAliasRegistered(name, alias, this.extractSource(ele));
        } else if (DomUtils.nodeNameEquals(ele, BEAN_ELEMENT) && (bdHolder = delegate.parseBeanDefinitionElement(ele)) != null) {
            bdHolder = delegate.decorateBeanDefinitionIfRequired(ele, bdHolder);
            BeanDefinitionReaderUtils.registerBeanDefinition(bdHolder, this.getReaderContext().getRegistry());
            this.getReaderContext().fireComponentRegistered(new BeanComponentDefinition(bdHolder));
        }
    }

    protected void importBeanDefinitionResource(Element ele) {
        String location = ele.getAttribute(RESOURCE_ATTRIBUTE);
        if (ResourcePatternUtils.isUrl(location = SystemPropertyUtils.resolvePlaceholders(location))) {
            int importCount = this.getReaderContext().getReader().loadBeanDefinitions(location);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Imported " + importCount + " bean definitions from URL location [" + location + "]");
            }
        } else {
            try {
                Resource relativeResource = this.getReaderContext().getResource().createRelative(location);
                int importCount = this.getReaderContext().getReader().loadBeanDefinitions(relativeResource);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Imported " + importCount + " bean definitions from relative location [" + location + "]");
                }
            }
            catch (IOException ex) {
                this.getReaderContext().error("Invalid relative resource location [" + location + "] to import bean definitions from", ele, null, ex);
            }
        }
        this.getReaderContext().fireImportProcessed(location, this.extractSource(ele));
    }

    protected void postProcessXml(Element root) {
    }
}

