/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans.factory.config;

import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.beans.PropertyEditorRegistrar;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanClassLoaderAware;
import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import com.bmc.thirdparty.org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import com.bmc.thirdparty.org.springframework.core.Ordered;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import java.beans.PropertyEditor;
import java.util.Iterator;
import java.util.Map;

public class CustomEditorConfigurer
implements BeanFactoryPostProcessor,
BeanClassLoaderAware,
Ordered {
    private int order = Integer.MAX_VALUE;
    private PropertyEditorRegistrar[] propertyEditorRegistrars;
    private Map customEditors;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    static /* synthetic */ Class class$java$beans$PropertyEditor;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setPropertyEditorRegistrars(PropertyEditorRegistrar[] propertyEditorRegistrars) {
        this.propertyEditorRegistrars = propertyEditorRegistrars;
    }

    public void setCustomEditors(Map customEditors) {
        this.customEditors = customEditors;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.propertyEditorRegistrars != null) {
            for (int i2 = 0; i2 < this.propertyEditorRegistrars.length; ++i2) {
                beanFactory.addPropertyEditorRegistrar(this.propertyEditorRegistrars[i2]);
            }
        }
        if (this.customEditors != null) {
            Iterator it = this.customEditors.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object key = entry.getKey();
                Class requiredType = null;
                if (key instanceof Class) {
                    requiredType = (Class)key;
                } else if (key instanceof String) {
                    String className = (String)key;
                    requiredType = ClassUtils.resolveClassName(className, this.beanClassLoader);
                } else {
                    throw new IllegalArgumentException("Invalid key [" + key + "] for custom editor: needs to be Class or String");
                }
                Object value = entry.getValue();
                if (!(value instanceof PropertyEditor)) {
                    throw new IllegalArgumentException("Mapped value [" + value + "] for custom editor key [" + key + "] is not of required type [" + (class$java$beans$PropertyEditor == null ? (class$java$beans$PropertyEditor = CustomEditorConfigurer.class$("java.beans.PropertyEditor")) : class$java$beans$PropertyEditor).getName() + "]");
                }
                beanFactory.registerCustomEditor(requiredType, (PropertyEditor)value);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

