/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.context.support;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.web.context.ServletContextAware;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;

public class ServletContextAttributeExporter
implements ServletContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Map attributes;

    public void setAttributes(Map attributes) {
        this.attributes = attributes;
    }

    public void setServletContext(ServletContext servletContext) {
        Iterator it = this.attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String attributeName = (String)entry.getKey();
            if (this.logger.isWarnEnabled() && servletContext.getAttribute(attributeName) != null) {
                this.logger.warn("Overwriting existing ServletContext attribute with name '" + attributeName + "'");
            }
            servletContext.setAttribute(attributeName, entry.getValue());
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info("Exported ServletContext attribute with name '" + attributeName + "'");
        }
    }
}

