/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.mail.javamail;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.mail.MailAuthenticationException;
import com.bmc.thirdparty.org.springframework.mail.MailException;
import com.bmc.thirdparty.org.springframework.mail.MailParseException;
import com.bmc.thirdparty.org.springframework.mail.MailPreparationException;
import com.bmc.thirdparty.org.springframework.mail.MailSendException;
import com.bmc.thirdparty.org.springframework.mail.SimpleMailMessage;
import com.bmc.thirdparty.org.springframework.mail.javamail.ConfigurableMimeFileTypeMap;
import com.bmc.thirdparty.org.springframework.mail.javamail.JavaMailSender;
import com.bmc.thirdparty.org.springframework.mail.javamail.MimeMailMessage;
import com.bmc.thirdparty.org.springframework.mail.javamail.MimeMessagePreparator;
import com.bmc.thirdparty.org.springframework.mail.javamail.SmartMimeMessage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.activation.FileTypeMap;
import javax.mail.AuthenticationFailedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;

public class JavaMailSenderImpl
implements JavaMailSender {
    public static final String DEFAULT_PROTOCOL = "smtp";
    public static final int DEFAULT_PORT = -1;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Session session = Session.getInstance((Properties)new Properties(), null);
    private String protocol = "smtp";
    private String host;
    private int port = -1;
    private String username;
    private String password;
    private String defaultEncoding;
    private FileTypeMap defaultFileTypeMap;

    public JavaMailSenderImpl() {
        ConfigurableMimeFileTypeMap fileTypeMap = new ConfigurableMimeFileTypeMap();
        fileTypeMap.afterPropertiesSet();
        this.defaultFileTypeMap = fileTypeMap;
    }

    public void setJavaMailProperties(Properties javaMailProperties) {
        this.session = Session.getInstance((Properties)javaMailProperties, null);
    }

    public void setSession(Session session) {
        if (session == null) {
            throw new IllegalArgumentException("Cannot work with a null Session");
        }
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setDefaultFileTypeMap(FileTypeMap defaultFileTypeMap) {
        this.defaultFileTypeMap = defaultFileTypeMap;
    }

    public FileTypeMap getDefaultFileTypeMap() {
        return this.defaultFileTypeMap;
    }

    public void send(SimpleMailMessage simpleMessage) throws MailException {
        this.send(new SimpleMailMessage[]{simpleMessage});
    }

    public void send(SimpleMailMessage[] simpleMessages) throws MailException {
        ArrayList<MimeMessage> mimeMessages = new ArrayList<MimeMessage>(simpleMessages.length);
        for (int i2 = 0; i2 < simpleMessages.length; ++i2) {
            SimpleMailMessage simpleMessage = simpleMessages[i2];
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Creating new MIME message using the following mail properties: " + simpleMessage);
            }
            MimeMailMessage message = new MimeMailMessage(this.createMimeMessage());
            simpleMessage.copyTo(message);
            mimeMessages.add(message.getMimeMessage());
        }
        this.doSend(mimeMessages.toArray(new MimeMessage[mimeMessages.size()]), simpleMessages);
    }

    public MimeMessage createMimeMessage() {
        return new SmartMimeMessage(this.getSession(), this.getDefaultEncoding(), this.getDefaultFileTypeMap());
    }

    public MimeMessage createMimeMessage(InputStream contentStream) throws MailException {
        try {
            return new MimeMessage(this.getSession(), contentStream);
        }
        catch (MessagingException ex) {
            throw new MailParseException("Could not parse raw MIME content", ex);
        }
    }

    public void send(MimeMessage mimeMessage) throws MailException {
        this.send(new MimeMessage[]{mimeMessage});
    }

    public void send(MimeMessage[] mimeMessages) throws MailException {
        this.doSend(mimeMessages, null);
    }

    public void send(MimeMessagePreparator mimeMessagePreparator) throws MailException {
        this.send(new MimeMessagePreparator[]{mimeMessagePreparator});
    }

    public void send(MimeMessagePreparator[] mimeMessagePreparators) throws MailException {
        try {
            ArrayList<MimeMessage> mimeMessages = new ArrayList<MimeMessage>(mimeMessagePreparators.length);
            for (int i2 = 0; i2 < mimeMessagePreparators.length; ++i2) {
                MimeMessage mimeMessage = this.createMimeMessage();
                mimeMessagePreparators[i2].prepare(mimeMessage);
                mimeMessages.add(mimeMessage);
            }
            this.send(mimeMessages.toArray(new MimeMessage[mimeMessages.size()]));
        }
        catch (MailException ex) {
            throw ex;
        }
        catch (MessagingException ex) {
            throw new MailParseException(ex);
        }
        catch (IOException ex) {
            throw new MailPreparationException(ex);
        }
        catch (Exception ex) {
            throw new MailPreparationException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSend(MimeMessage[] mimeMessages, Object[] originalMessages) throws MailException {
        HashMap<MimeMessage, MessagingException> failedMessages = new HashMap<MimeMessage, MessagingException>();
        try {
            Transport transport = this.getTransport(this.getSession());
            transport.connect(this.getHost(), this.getPort(), this.getUsername(), this.getPassword());
            try {
                for (int i2 = 0; i2 < mimeMessages.length; ++i2) {
                    MimeMessage mimeMessage = mimeMessages[i2];
                    try {
                        if (mimeMessage.getSentDate() == null) {
                            mimeMessage.setSentDate(new Date());
                        }
                        mimeMessage.saveChanges();
                        transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
                        continue;
                    }
                    catch (MessagingException ex) {
                        MimeMessage original = originalMessages != null ? originalMessages[i2] : mimeMessage;
                        failedMessages.put(original, ex);
                    }
                }
            }
            finally {
                transport.close();
            }
        }
        catch (AuthenticationFailedException ex) {
            throw new MailAuthenticationException(ex);
        }
        catch (MessagingException ex) {
            throw new MailSendException("Mail server connection failed", ex);
        }
        if (!failedMessages.isEmpty()) {
            throw new MailSendException(failedMessages);
        }
    }

    protected Transport getTransport(Session session) throws NoSuchProviderException {
        return session.getTransport(this.getProtocol());
    }
}

