/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.javadriver;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ByteListValue;
import com.bmc.arsys.api.Container;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DisplayInstanceMap;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.Image;
import com.bmc.arsys.api.ImageCriteria;
import com.bmc.arsys.api.ImageData;
import com.bmc.arsys.api.PropertyMap;
import com.bmc.arsys.api.Reference;
import com.bmc.arsys.api.ReferenceType;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.View;
import com.bmc.arsys.api.ViewCriteria;
import com.bmc.arsys.api.ViewDisplayPropertyMap;
import com.bmc.arsys.demo.javadriver.InputReader;
import com.bmc.arsys.demo.javadriver.JavaDriver;
import com.bmc.arsys.demo.javadriver.OutputWriter;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.Adler32;
import java.util.zip.Checksum;

public class ImageExtractor
extends JavaDriver {
    static OutputWriter outputWriter = new OutputWriter();
    ARServerUser arServerUser;
    int totalImages;
    int totalDistinctImages;
    long memorySaving;
    long totalDistinctImageSize;
    ArrayList<String> schemaNames;
    HashMap<Long, String> imageMap;
    Checksum checksumEngine;
    long curImageChecksum;
    int imageChunkSize;

    public ImageExtractor() {
        this.initThreadControlBlockPtr();
        this.schemaNames = new ArrayList();
        this.imageMap = new HashMap();
        this.totalImages = 0;
        this.totalDistinctImages = 0;
        this.checksumEngine = new Adler32();
        this.curImageChecksum = 0L;
        this.memorySaving = 0L;
        this.totalDistinctImageSize = 0L;
        String chunkStr = System.getProperty("ImageChunkSize");
        if (chunkStr == null) {
            this.imageChunkSize = 20;
        } else {
            Integer myInt = new Integer(chunkStr);
            this.imageChunkSize = myInt;
        }
    }

    public long getTotalImageSize() {
        return this.totalDistinctImageSize;
    }

    public long getMemorySaving() {
        return this.memorySaving;
    }

    public int getTotalImageCount() {
        return this.totalImages;
    }

    public int getDistinctImageCount() {
        return this.totalDistinctImages;
    }

    public int getSchemaCount() {
        return this.schemaNames.size();
    }

    long calculateChecksum(byte[] inByte) {
        this.checksumEngine.reset();
        this.checksumEngine.update(inByte, 0, inByte.length);
        return this.checksumEngine.getValue();
    }

    void populateImageList() throws ARException {
        outputWriter.printHeader("", "Using image chunk value : " + this.imageChunkSize + ".", "\n");
        List<String> imageNames = null;
        imageNames = this.arServerUser.getListImage();
        if (imageNames == null) {
            return;
        }
        int imagesInServer = imageNames.size();
        outputWriter.printHeader("", "There are  " + imagesInServer + " images in the system.", "\n");
        int numCompleteChunks = imagesInServer / this.imageChunkSize;
        int partialChunksize = imagesInServer % this.imageChunkSize;
        int curIndex = 0;
        for (int i = 0; i < numCompleteChunks; ++i) {
            this.processExistingImages(imageNames.subList(curIndex, curIndex + this.imageChunkSize));
            curIndex += this.imageChunkSize;
        }
        this.processExistingImages(imageNames.subList(curIndex, curIndex + partialChunksize));
    }

    private void processExistingImages(List<String> imageNames) throws ARException {
        List<Image> imageList = null;
        ImageCriteria criteria = new ImageCriteria();
        criteria.setRetrieveAll(true);
        imageList = this.arServerUser.getListImageObjects(imageNames, criteria);
        if (imageList == null) {
            return;
        }
        Adler32 checksumEngine = new Adler32();
        for (int i = 0; i < imageList.size(); ++i) {
            Image curImage = imageList.get(i);
            byte[] bytes = curImage.getImageData().getValue();
            this.totalDistinctImageSize += (long)bytes.length;
            checksumEngine.update(bytes, 0, bytes.length);
            long checksum = checksumEngine.getValue();
            this.imageMap.put(new Long(checksum), curImage.getName());
            checksumEngine.reset();
        }
    }

    void readSchemaNames(String fileName, boolean useApplication) throws ARException, FileNotFoundException, IOException {
        if (fileName == null || fileName.length() == 0) {
            this.schemaNames = (ArrayList)this.arServerUser.getListForm(0L);
        } else if (useApplication) {
            this.populateSchemaNamesUsingApplicationNames(fileName);
        } else {
            this.populateSchemaNamesFromFile(fileName);
        }
    }

    private void populateSchemaNamesFromFile(String fileName) throws FileNotFoundException, IOException {
        JavaDriver.getThreadControlBlockPtr().setCurrentInputFile(fileName);
        String inputLine = null;
        BufferedReader currentInputFile = JavaDriver.getThreadControlBlockPtr().getCurrentInputFile();
        inputLine = currentInputFile.readLine();
        while (inputLine != null) {
            int index = 0;
            for (index = inputLine.length() - 1; index >= 0 && inputLine.charAt(index) == ' ' && inputLine.charAt(index) == '\t' && inputLine.charAt(index) == '\n'; --index) {
            }
            if (inputLine.length() >= 1 && inputLine.charAt(0) == '#') continue;
            this.schemaNames.add(inputLine);
            inputLine = currentInputFile.readLine();
        }
        JavaDriver.getThreadControlBlockPtr().closeCurrentInputFile();
    }

    private void populateSchemaNamesUsingApplicationNames(String fileName) throws ARException, FileNotFoundException, IOException {
        JavaDriver.getThreadControlBlockPtr().setCurrentInputFile(fileName);
        String inputLine = null;
        BufferedReader currentInputFile = JavaDriver.getThreadControlBlockPtr().getCurrentInputFile();
        inputLine = currentInputFile.readLine();
        while (inputLine != null) {
            int index = 0;
            for (index = inputLine.length() - 1; index >= 0 && inputLine.charAt(index) == ' ' && inputLine.charAt(index) == '\t' && inputLine.charAt(index) == '\n'; --index) {
            }
            if (inputLine.length() >= 1 && inputLine.charAt(0) == '#') continue;
            Container application = this.arServerUser.getContainer(inputLine);
            List<Reference> references = application.getReferences();
            for (int i = 0; i < references.size(); ++i) {
                if (references.get(i).getReferenceType() != ReferenceType.APPLICATION_FORMS || references.get(++i).getReferenceType() != ReferenceType.SCHEMA) continue;
                this.schemaNames.add(references.get(i).getName());
            }
            inputLine = currentInputFile.readLine();
        }
        JavaDriver.getThreadControlBlockPtr().closeCurrentInputFile();
    }

    boolean isUniqueImageObject(byte[] imageContent) {
        this.curImageChecksum = this.calculateChecksum(imageContent);
        if (this.imageMap.get(new Long(this.curImageChecksum)) == null) {
            this.totalDistinctImageSize += (long)imageContent.length;
            return true;
        }
        this.memorySaving += (long)imageContent.length;
        return false;
    }

    void processNewImageObject(String imageName, byte[] imageContent) throws ARException {
        Image newImage = new Image(imageName);
        ImageData imageData = new ImageData(imageContent);
        newImage.setImageData(imageData);
        newImage.setType("jpg");
        newImage.setDescription("Extracted by Image Utility version 1.0");
        newImage.setOwner(this.arServerUser.getUser());
        this.arServerUser.createImage(newImage);
    }

    void processSchemaList() {
        String curSchema = null;
        for (int i = 0; i < this.schemaNames.size(); ++i) {
            curSchema = this.schemaNames.get(i);
            if (curSchema == null) continue;
            outputWriter.printHeader("", "Currently processing Form " + curSchema + "...", "\n");
            try {
                this.processViews(curSchema);
                this.processFields(curSchema);
                continue;
            }
            catch (ARException ex) {
                outputWriter.printHeader("", "Error while processing schema " + curSchema + ".", "\n");
                outputWriter.printHeader("", "Error message " + ex.getMessage() + ".", "\n");
            }
        }
    }

    private void processViews(String schemaName) throws ARException {
        ViewCriteria criteria = new ViewCriteria();
        criteria.setPropertiesToRetrieve(ViewCriteria.PROPERTY_LIST);
        List<View> viewList = this.arServerUser.getListViewObjects(schemaName, 0L, criteria);
        if (viewList == null) {
            return;
        }
        for (int vuiIndex = 0; vuiIndex < viewList.size(); ++vuiIndex) {
            String containerName;
            boolean propMapChanged;
            ViewDisplayPropertyMap dispProp;
            View currentView = viewList.get(vuiIndex);
            if (currentView == null || (dispProp = currentView.getDisplayProperties()) == null || !(propMapChanged = this.processPropertyMap(containerName = schemaName + "_" + currentView.getName(), dispProp))) continue;
            currentView.setDisplayProperties(dispProp);
            this.arServerUser.setView(currentView);
        }
    }

    private boolean processPropertyMap(String containerName, PropertyMap propMap) throws ARException {
        boolean didPropMapChange = false;
        for (Map.Entry entry : propMap.entrySet()) {
            Value curValue = (Value)entry.getValue();
            DataType type = curValue.getDataType();
            if (type == null || type.toInt() != 9) continue;
            String imageName = null;
            ByteListValue byteListValue = (ByteListValue)curValue.getValue();
            byte[] imageContent = byteListValue.getValue();
            if (this.isUniqueImageObject(imageContent)) {
                ++this.totalDistinctImages;
                imageName = containerName + "_" + this.curImageChecksum;
                String finalImage = imageName.replace(':', '_');
                this.processNewImageObject(finalImage, imageContent);
                this.imageMap.put(new Long(this.curImageChecksum), finalImage);
                imageName = finalImage;
            } else {
                imageName = this.imageMap.get(new Long(this.curImageChecksum));
            }
            if (imageName == null) continue;
            Value newValue = new Value(imageName, DataType.CHAR);
            entry.setValue(newValue);
            didPropMapChange = true;
            ++this.totalImages;
        }
        return didPropMapChange;
    }

    private void processFields(String schemaName) throws ARException {
        List<Field> fieldList = null;
        try {
            fieldList = this.arServerUser.getListFieldObjects(schemaName);
        }
        catch (IllegalArgumentException ex) {
            System.out.println("Error while processing fields on the form " + schemaName);
            return;
        }
        if (fieldList == null) {
            return;
        }
        String containerName = null;
        for (int fieldIndex = 0; fieldIndex < fieldList.size(); ++fieldIndex) {
            boolean propMapChanged = false;
            Field currentField = fieldList.get(fieldIndex);
            if (currentField == null) continue;
            containerName = schemaName + "_" + currentField.getName();
            DisplayInstanceMap diMap = currentField.getDisplayInstance();
            if (diMap == null) continue;
            PropertyMap diProp = null;
            for (Integer diMapKey : diMap.keySet()) {
                diProp = (PropertyMap)diMap.get((int)diMapKey);
                if (diProp == null) continue;
                propMapChanged = this.processPropertyMap(containerName, diProp);
            }
            if (!propMapChanged) continue;
            currentField.setDisplayInstance(diMap);
            this.arServerUser.setField(currentField);
        }
    }

    void verifyImages() {
        outputWriter.printHeader("", "\nVerifying the extracted image name references, Please wait....", "\n");
        for (int i = 0; i < this.schemaNames.size(); ++i) {
            try {
                outputWriter.printHeader("", "\nVerifying the image name references in schema : " + this.schemaNames.get(i), "");
                ViewCriteria criteria = new ViewCriteria();
                criteria.setPropertiesToRetrieve(ViewCriteria.PROPERTY_LIST);
                List<View> viewList = this.arServerUser.getListViewObjects(this.schemaNames.get(i), 0L, criteria);
                for (int vuiIndex = 0; vuiIndex < viewList.size(); ++vuiIndex) {
                    View currentView = viewList.get(vuiIndex);
                    ViewDisplayPropertyMap dispProp = currentView.getDisplayProperties();
                    for (Integer j : dispProp.keySet()) {
                        String imageName;
                        int prop = j;
                        Value curValue = (Value)dispProp.get(prop);
                        if (prop != 100 && prop != 101 && prop != 167 && prop != 200 || curValue.getDataType().toInt() != 4 || this.isImagePresentInServer(imageName = curValue.getValue().toString())) continue;
                        outputWriter.printHeader("", "\nImage : " + imageName, " is associated with View : " + currentView.getName() + " couldn't not be verified");
                    }
                }
                List<Field> fieldList = this.arServerUser.getListFieldObjects(this.schemaNames.get(i));
                for (int fieldIndex = 0; fieldIndex < fieldList.size(); ++fieldIndex) {
                    DisplayInstanceMap diMap;
                    Field currentField = fieldList.get(fieldIndex);
                    if (currentField == null || (diMap = currentField.getDisplayInstance()) == null) continue;
                    PropertyMap diProp = null;
                    for (Integer diMapKey : diMap.keySet()) {
                        diProp = (PropertyMap)diMap.get((int)diMapKey);
                        if (diProp == null) continue;
                        for (Integer mapKey : diProp.keySet()) {
                            String imageName;
                            Value curValue = (Value)diProp.get((int)mapKey);
                            DataType type = curValue.getDataType();
                            if (type == null || mapKey != 100 && mapKey != 101 && mapKey != 167 && mapKey != 200 || curValue.getDataType().toInt() != 4 || this.isImagePresentInServer(imageName = curValue.getValue().toString())) continue;
                            outputWriter.printHeader("", "\nImage : " + imageName, " is associated with Field : " + currentField.getName() + " couldn't not be verified");
                        }
                    }
                }
                continue;
            }
            catch (Exception e2) {
                outputWriter.printString("\nError : " + e2.toString() + "verifying schema " + this.schemaNames.get(i));
            }
        }
        outputWriter.printHeader("\n", "\nCompleted verification of extracted images.", "\n");
    }

    boolean isImagePresentInServer(String imageName) throws ARException {
        List<Image> imageList = null;
        ArrayList<String> imageNames = new ArrayList<String>();
        if (imageName.length() == 0) {
            return false;
        }
        imageNames.add(imageName);
        ImageCriteria criteria = new ImageCriteria();
        criteria.setRetrieveAll(true);
        try {
            imageList = this.arServerUser.getListImageObjects(imageNames, criteria);
            if (imageList == null) {
                outputWriter.printHeader("\n", "\nCouldn't find image " + imageName + " in server.", "\n");
                return false;
            }
        }
        catch (ARException e2) {
            outputWriter.printHeader("\n", "\nError" + e2.toString() + " getting image " + imageName + " from server.", "\n");
            return false;
        }
        for (int i = 0; i < imageList.size(); ++i) {
            Image curImage = imageList.get(i);
            if (curImage.getImageData().getValue().length != 0) continue;
            outputWriter.printHeader("\n", "\nImage " + imageName + " contains zero byte.", "\n");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        ImageExtractor imageExtractor = null;
        boolean useApplication = true;
        try {
            imageExtractor = new ImageExtractor();
            JavaDriver.getThreadControlBlockPtr().setPrimaryThread(true);
            JavaDriver.getThreadControlBlockPtr().setCurrentInputToStdIn();
            JavaDriver.getThreadControlBlockPtr().setOutputToStdOut();
            String serverName = InputReader.getString("Server Host:", "localhost");
            int serverPort = InputReader.getInt("Server Port:", 0);
            String userName = InputReader.getString("User Name:", "Demo");
            String password = InputReader.getString("Password:", "");
            String locale = null;
            InputReader.setNullPromptOption(true);
            String useAppStr = InputReader.getString("Would you like to use application names(Yes/No)?", "Yes");
            useApplication = useAppStr.equals("Yes") || useAppStr.equals("yes");
            String fileName = null;
            fileName = useApplication ? InputReader.getString("Input File containing the application names :", "") : InputReader.getString("Input File containing the form names :", "");
            imageExtractor.arServerUser = new ARServerUser(userName, password, locale, serverName, serverPort);
            imageExtractor.arServerUser.login();
            Calendar now = Calendar.getInstance();
            long startTime = now.getTimeInMillis();
            imageExtractor.populateImageList();
            imageExtractor.readSchemaNames(fileName, useApplication);
            if (useApplication) {
                outputWriter.printHeader("", "Processing " + imageExtractor.getSchemaCount() + " forms belonging to specified application(s).", "\n");
            } else {
                outputWriter.printHeader("", "Processing " + imageExtractor.getSchemaCount() + " Forms.", "\n");
            }
            imageExtractor.processSchemaList();
            imageExtractor.verifyImages();
            now = Calendar.getInstance();
            long endTime = now.getTimeInMillis();
            long elapsedTime = (endTime - startTime) / 1000L;
            outputWriter.printHeader("", "\n", "\n");
            outputWriter.printHeader("", "Current Run Report         \n", "\n");
            outputWriter.printHeader("", "==========================================", "\n");
            outputWriter.printHeader("", "Total Images                 : " + imageExtractor.getTotalImageCount(), "\n");
            outputWriter.printHeader("", "Distinct Images              : " + imageExtractor.getDistinctImageCount(), "\n");
            outputWriter.printHeader("", "Total Saving     ( In bytes) : " + imageExtractor.getMemorySaving(), "\n");
            outputWriter.printHeader("", "Processing Completed in " + elapsedTime + " seconds.", "\n");
            outputWriter.printHeader("", "==========================================", "\n");
            return;
        }
        catch (Exception e2) {
            outputWriter.printString("Error in executing the command\n");
            e2.printStackTrace();
            return;
        }
        finally {
            try {
                imageExtractor.arServerUser.logout();
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
            finally {
                System.exit(0);
            }
        }
    }
}

