/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.DiaryItem;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.utils.CatalogReader;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class DiaryListValue
extends ArrayList<DiaryItem>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -351544304667070934L;
    private static Logger a = Logger.getLogger(DiaryListValue.class);
    private String appendedText;
    public static final String AR_DEFN_DIARY_SEP = new String(new char[]{'\u0003'});
    public static final String AR_DEFN_DIARY_COMMA = new String(new char[]{'\u0004'});

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DiaryListValue)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        DiaryListValue diaryListValue = (DiaryListValue)object;
        return new EqualsBuilder().appendSuper(super.equals(object)).append(this.appendedText, diaryListValue.appendedText).isEquals();
    }

    public static DiaryListValue decode(String string) throws ARException {
        DiaryListValue diaryListValue = new DiaryListValue();
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(AR_DEFN_DIARY_SEP)) {
                if (string2.length() == 0) continue;
                String[] stringArray2 = string2.split(AR_DEFN_DIARY_COMMA);
                if (stringArray2.length >= 3) {
                    String string3;
                    String string4 = stringArray2[0];
                    long l2 = 0L;
                    try {
                        l2 = Long.parseLong(string4);
                    }
                    catch (Exception exception) {
                        string3 = CatalogReader.getInstance().getMessage(339);
                        a.warn(string3 + " for timestamp " + string2);
                    }
                    String string5 = stringArray2[1];
                    string3 = stringArray2[2];
                    int n2 = stringArray2.length;
                    for (int i2 = 3; i2 < n2; ++i2) {
                        string3 = string3 + AR_DEFN_DIARY_COMMA + stringArray2[i2];
                    }
                    DiaryItem diaryItem = new DiaryItem(string5, string3, new Timestamp(l2));
                    diaryListValue.add(diaryItem);
                    continue;
                }
                throw new ARException(2, 339, string);
            }
        }
        return diaryListValue;
    }

    public String encode() {
        StringBuilder stringBuilder = new StringBuilder();
        for (DiaryItem diaryItem : this) {
            if (diaryItem != null) {
                stringBuilder.append(new Long(diaryItem.getTimestamp().getValue()).toString());
                stringBuilder.append(AR_DEFN_DIARY_COMMA);
                stringBuilder.append(diaryItem.getUser());
                if (diaryItem.getText() != null) {
                    stringBuilder.append(AR_DEFN_DIARY_COMMA);
                    stringBuilder.append(diaryItem.getText());
                }
            }
            stringBuilder.append(AR_DEFN_DIARY_SEP);
        }
        return stringBuilder.toString();
    }

    @Override
    public Object clone() {
        DiaryListValue diaryListValue = new DiaryListValue();
        try {
            for (DiaryItem diaryItem : this) {
                diaryListValue.add((DiaryItem)diaryItem.clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return diaryListValue;
    }

    Object toVariant(ARServerUser aRServerUser) {
        if (this.appendedText != null) {
            return this.appendedText;
        }
        return this.encode();
    }

    public String getAppendedText() {
        return this.appendedText;
    }

    public void setAppendedText(String string) {
        this.appendedText = string;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("Appended Text", this.appendedText).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.appendedText).toHashCode();
    }
}

