/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.servlet.handler;

import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.core.Ordered;
import com.bmc.thirdparty.org.springframework.web.context.request.WebRequestInterceptor;
import com.bmc.thirdparty.org.springframework.web.context.support.WebApplicationObjectSupport;
import com.bmc.thirdparty.org.springframework.web.servlet.HandlerExecutionChain;
import com.bmc.thirdparty.org.springframework.web.servlet.HandlerInterceptor;
import com.bmc.thirdparty.org.springframework.web.servlet.HandlerMapping;
import com.bmc.thirdparty.org.springframework.web.servlet.handler.WebRequestHandlerInterceptorAdapter;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractHandlerMapping
extends WebApplicationObjectSupport
implements HandlerMapping,
Ordered {
    private int order = Integer.MAX_VALUE;
    private Object defaultHandler;
    private Object[] interceptors;
    private HandlerInterceptor[] adaptedInterceptors;

    public final void setOrder(int order) {
        this.order = order;
    }

    public final int getOrder() {
        return this.order;
    }

    public final void setDefaultHandler(Object defaultHandler) {
        this.defaultHandler = defaultHandler;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Default mapping to handler [" + this.defaultHandler + "]");
        }
    }

    protected final Object getDefaultHandler() {
        return this.defaultHandler;
    }

    public final void setInterceptors(Object[] interceptors) {
        this.interceptors = interceptors;
    }

    protected void initApplicationContext() throws BeansException {
        this.initInterceptors();
    }

    protected void initInterceptors() {
        if (this.interceptors != null) {
            this.adaptedInterceptors = new HandlerInterceptor[this.interceptors.length];
            for (int i2 = 0; i2 < this.interceptors.length; ++i2) {
                if (this.interceptors[i2] == null) {
                    throw new IllegalArgumentException("Entry number " + i2 + " in interceptors array is null");
                }
                this.adaptedInterceptors[i2] = this.adaptInterceptor(this.interceptors[i2]);
            }
        }
    }

    protected HandlerInterceptor adaptInterceptor(Object interceptor) {
        if (interceptor instanceof HandlerInterceptor) {
            return (HandlerInterceptor)interceptor;
        }
        if (interceptor instanceof WebRequestInterceptor) {
            return new WebRequestHandlerInterceptorAdapter((WebRequestInterceptor)interceptor);
        }
        throw new IllegalArgumentException("Interceptor type not supported: " + interceptor.getClass().getName());
    }

    public final HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
        Object handler = this.getHandlerInternal(request);
        if (handler == null) {
            handler = this.defaultHandler;
        }
        if (handler == null) {
            return null;
        }
        if (handler instanceof String) {
            String handlerName = (String)handler;
            handler = this.getApplicationContext().getBean(handlerName);
        }
        return new HandlerExecutionChain(handler, this.adaptedInterceptors);
    }

    protected abstract Object getHandlerInternal(HttpServletRequest var1) throws Exception;
}

