/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.orm.toplink.support;

import com.bmc.thirdparty.org.springframework.dao.DataAccessException;
import com.bmc.thirdparty.org.springframework.dao.DataAccessResourceFailureException;
import com.bmc.thirdparty.org.springframework.dao.support.DaoSupport;
import com.bmc.thirdparty.org.springframework.orm.toplink.SessionFactory;
import com.bmc.thirdparty.org.springframework.orm.toplink.SessionFactoryUtils;
import com.bmc.thirdparty.org.springframework.orm.toplink.TopLinkTemplate;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.sessions.Session;

public abstract class TopLinkDaoSupport
extends DaoSupport {
    private TopLinkTemplate topLinkTemplate;

    public final void setSessionFactory(SessionFactory sessionFactory) {
        this.topLinkTemplate = this.createTopLinkTemplate(sessionFactory);
    }

    protected TopLinkTemplate createTopLinkTemplate(SessionFactory sessionFactory) {
        return new TopLinkTemplate(sessionFactory);
    }

    public final SessionFactory getSessionFactory() {
        return this.topLinkTemplate != null ? this.topLinkTemplate.getSessionFactory() : null;
    }

    public final void setTopLinkTemplate(TopLinkTemplate topLinkTemplate) {
        this.topLinkTemplate = topLinkTemplate;
    }

    public final TopLinkTemplate getTopLinkTemplate() {
        return this.topLinkTemplate;
    }

    protected final void checkDaoConfig() {
        if (this.topLinkTemplate == null) {
            throw new IllegalArgumentException("sessionFactory or topLinkTemplate is required");
        }
    }

    protected final Session getSession() throws DataAccessResourceFailureException, IllegalStateException {
        return this.getSession(this.topLinkTemplate.isAllowCreate());
    }

    protected final Session getSession(boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        return SessionFactoryUtils.getSession(this.getSessionFactory(), allowCreate);
    }

    protected final DataAccessException convertTopLinkAccessException(TopLinkException ex) {
        return this.topLinkTemplate.convertTopLinkAccessException(ex);
    }

    protected final void releaseSession(Session session) {
        SessionFactoryUtils.releaseSession(session, this.getSessionFactory());
    }
}

