/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcClientCallMessage;
import org.acplt.oncrpc.OncRpcClientReplyMessage;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcTimeoutException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrBufferEncodingStream;
import org.acplt.oncrpc.XdrHttpDecodingStream;
import org.acplt.oncrpc.web.Base64;
import org.acplt.oncrpc.web.HttpClientConnection;

public class OncRpcHttpClient
extends OncRpcClient {
    private String hostname;
    private int httpPort;
    private String cgiHandlerPath;
    private String oncrpcHostname;
    private int oncrpcProtocol;
    private HttpClientConnection httpClient;
    private XdrBufferEncodingStream sendingXdr;
    private XdrHttpDecodingStream receivingXdr;

    public OncRpcHttpClient(String string, String string2, String string3, int n, int n2, int n3) throws OncRpcException, IOException {
        this(string, 80, string2, string3, n, n2, n3, 6);
    }

    public OncRpcHttpClient(String string, String string2, String string3, int n, int n2, int n3, int n4) throws OncRpcException, IOException {
        this(string, 80, string2, string3, n, n2, n3, n4);
    }

    public OncRpcHttpClient(String string, int n, String string2, String string3, int n2, int n3, int n4, int n5) throws OncRpcException, IOException {
        super(null, n2, n3, -1, -42);
        this.httpPort = n;
        this.cgiHandlerPath = string2;
        this.oncrpcHostname = string3;
        this.oncrpcProtocol = n5;
        this.port = n4;
        this.hostname = string;
        this.httpClient = new HttpClientConnection(string, n);
        this.sendingXdr = new XdrBufferEncodingStream(8192);
        this.receivingXdr = new XdrHttpDecodingStream(this.httpClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws OncRpcException {
        if (this.httpClient != null) {
            this.httpClient.close();
            this.httpClient = null;
        }
        if (this.sendingXdr != null) {
            try {
                this.sendingXdr.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.sendingXdr = null;
            }
        }
        if (this.receivingXdr != null) {
            try {
                this.receivingXdr.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.receivingXdr = null;
            }
        }
    }

    @Override
    public synchronized void call(int n, int n2, XdrAble xdrAble, XdrAble xdrAble2) throws OncRpcException {
        for (int i = 1; i >= 0; --i) {
            int n3;
            this.nextXid();
            OncRpcClientCallMessage oncRpcClientCallMessage = new OncRpcClientCallMessage(this.xid, this.program, n2, n, this.auth);
            OncRpcClientReplyMessage oncRpcClientReplyMessage = new OncRpcClientReplyMessage(this.auth);
            try {
                this.sendingXdr.beginEncoding(null, 0);
                oncRpcClientCallMessage.xdrEncode(this.sendingXdr);
                xdrAble.xdrEncode(this.sendingXdr);
                this.sendingXdr.endEncoding();
            }
            catch (IOException iOException) {
                throw new OncRpcException(3, iOException.getLocalizedMessage());
            }
            StringBuffer stringBuffer = new StringBuffer(512);
            stringBuffer.append("CALL ");
            stringBuffer.append(this.oncrpcHostname);
            if (this.port > 0) {
                stringBuffer.append(":");
                stringBuffer.append(this.port);
            }
            stringBuffer.append(" ");
            stringBuffer.append(this.oncrpcProtocol);
            stringBuffer.append(" ");
            stringBuffer.append("TEA/1.0");
            stringBuffer.append("\r\n");
            stringBuffer.append("\r\n");
            int n4 = (n3 + 47) / 48;
            int n5 = stringBuffer.length() + (n3 + 2) / 3 * 4 + n4 * 2;
            byte[] byArray = this.sendingXdr.getXdrData();
            try {
                this.httpClient.beginPostRequest(this.cgiHandlerPath, "text/plain", n5);
                String string = stringBuffer.toString();
                this.httpClient.writeContentBytes(string.getBytes(), 0, string.length());
                byte[] byArray2 = new byte[6600];
                int n6 = 0;
                int n7 = 0;
                for (n3 = this.sendingXdr.getXdrLength(); n3 >= 48; n3 -= 48) {
                    if (n7 >= 6600) {
                        this.httpClient.writeContentBytes(byArray2, 0, n7);
                        n7 = 0;
                    }
                    n7 += Base64.encode((byte[])byArray, (int)n6, (int)48, (byte[])byArray2, (int)n7);
                    byArray2[n7++] = 13;
                    byArray2[n7++] = 10;
                    n6 += 48;
                }
                if (n3 > 0) {
                    if (n7 >= 6600) {
                        this.httpClient.writeContentBytes(byArray2, 0, n7);
                        n7 = 0;
                    }
                    n7 += Base64.encode((byte[])byArray, (int)n6, (int)n3, (byte[])byArray2, (int)n7);
                    byArray2[n7++] = 13;
                    byArray2[n7++] = 10;
                }
                if (n7 > 0) {
                    this.httpClient.writeContentBytes(byArray2, 0, n7);
                }
                this.httpClient.endPostRequest();
            }
            catch (IOException iOException) {
                throw new OncRpcException(3, iOException.getLocalizedMessage());
            }
            try {
                this.receivingXdr.beginDecoding();
                int n8 = this.httpClient.getResponseCode();
                if (n8 < 200 || n8 >= 300) {
                    throw new OncRpcException(16, "HTTP tunnel response error " + n8);
                }
                oncRpcClientReplyMessage.xdrDecode(this.receivingXdr);
                if (oncRpcClientReplyMessage.messageId != oncRpcClientCallMessage.messageId) {
                    this.receivingXdr.endDecoding();
                    throw new OncRpcException(44);
                }
                if (!oncRpcClientReplyMessage.successfullyAccepted()) {
                    this.receivingXdr.endDecoding();
                    if (i > 0 && oncRpcClientReplyMessage.replyStatus == 1 && oncRpcClientReplyMessage.rejectStatus == 1 && this.auth.canRefreshCred()) continue;
                    throw oncRpcClientReplyMessage.newException();
                }
                xdrAble2.xdrDecode(this.receivingXdr);
                this.receivingXdr.endDecoding();
                return;
            }
            catch (InterruptedIOException interruptedIOException) {
                throw new OncRpcTimeoutException();
            }
            catch (IOException iOException) {
                throw new OncRpcException(4, iOException.getLocalizedMessage());
            }
        }
    }

    @Override
    public void setCharacterEncoding(String string) {
        this.sendingXdr.setCharacterEncoding(string);
        this.receivingXdr.setCharacterEncoding(string);
    }

    @Override
    public String getCharacterEncoding() {
        return this.receivingXdr.getCharacterEncoding();
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getHttpPort() {
        return this.httpPort;
    }
}

