/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.NoSuchElementException;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcPortmapClient;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.XdrEncodingStream;
import org.acplt.oncrpc.server.OncRpcCallInformation;
import org.acplt.oncrpc.server.OncRpcDispatchable;
import org.acplt.oncrpc.server.OncRpcServerReplyMessage;
import org.acplt.oncrpc.server.OncRpcServerTransport;
import org.acplt.oncrpc.server.OncRpcServerTransportRegistrationInfo;
import org.acplt.oncrpc.server.OncRpcTcpConnectionServerTransport;

public class OncRpcTcpServerTransport
extends OncRpcServerTransport {
    private ServerSocket socket;
    private int bufferSize;
    private TransportList openTransports = new TransportList();
    protected int transmissionTimeout = 30000;
    private String characterEncoding = null;

    public OncRpcTcpServerTransport(OncRpcDispatchable dispatcher, int port, int program, int version, int bufferSize) throws OncRpcException, IOException {
        this(dispatcher, port, new OncRpcServerTransportRegistrationInfo[]{new OncRpcServerTransportRegistrationInfo(program, version)}, bufferSize);
    }

    public OncRpcTcpServerTransport(OncRpcDispatchable dispatcher, int port, OncRpcServerTransportRegistrationInfo[] info, int bufferSize) throws OncRpcException, IOException {
        this(dispatcher, null, port, info, bufferSize);
    }

    public OncRpcTcpServerTransport(OncRpcDispatchable dispatcher, InetAddress bindAddr, int port, OncRpcServerTransportRegistrationInfo[] info, int bufferSize) throws OncRpcException, IOException {
        super(dispatcher, port, info);
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        this.bufferSize = bufferSize;
        this.socket = new ServerSocket(port, 0, bindAddr);
        if (port == 0) {
            this.port = this.socket.getLocalPort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.socket != null) {
            ServerSocket deadSocket = this.socket;
            this.socket = null;
            try {
                deadSocket.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        TransportList transportList = this.openTransports;
        synchronized (transportList) {
            while (this.openTransports.size() > 0) {
                OncRpcTcpConnectionServerTransport transport = (OncRpcTcpConnectionServerTransport)this.openTransports.removeFirst();
                transport.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTransport(OncRpcTcpConnectionServerTransport transport) {
        TransportList transportList = this.openTransports;
        synchronized (transportList) {
            this.openTransports.remove(transport);
        }
    }

    @Override
    public void register() throws OncRpcException {
        try {
            OncRpcPortmapClient portmapper = new OncRpcPortmapClient(InetAddress.getByName("127.0.0.1"));
            int size = this.info.length;
            for (int idx = 0; idx < size; ++idx) {
                if (portmapper.setPort(this.info[idx].program, this.info[idx].version, 6, this.port)) continue;
                throw new OncRpcException(45);
            }
        }
        catch (IOException e2) {
            throw new OncRpcException(16);
        }
    }

    @Override
    public void retrieveCall(XdrAble call) throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.retrieveCall() is abstract and can not be called.");
    }

    @Override
    protected XdrDecodingStream getXdrDecodingStream() {
        throw new Error("OncRpcTcpServerTransport.getXdrDecodingStream() is abstract and can not be called.");
    }

    @Override
    protected void endDecoding() throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.endDecoding() is abstract and can not be called.");
    }

    @Override
    protected XdrEncodingStream getXdrEncodingStream() {
        throw new Error("OncRpcTcpServerTransport.getXdrEncodingStream() is abstract and can not be called.");
    }

    @Override
    protected void beginEncoding(OncRpcCallInformation callInfo, OncRpcServerReplyMessage state) throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.beginEncoding() is abstract and can not be called.");
    }

    @Override
    protected void endEncoding() throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.endEncoding() is abstract and can not be called.");
    }

    @Override
    protected void reply(OncRpcCallInformation callInfo, OncRpcServerReplyMessage state, XdrAble reply) throws OncRpcException, IOException {
        throw new Error("OncRpcTcpServerTransport.reply() is abstract and can not be called.");
    }

    @Override
    public void listen() {
        Thread listenThread = new Thread("TCP server transport listener thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        ServerSocket myServerSocket;
                        while ((myServerSocket = OncRpcTcpServerTransport.this.socket) != null) {
                            Socket newSocket = myServerSocket.accept();
                            OncRpcTcpConnectionServerTransport transport = new OncRpcTcpConnectionServerTransport(OncRpcTcpServerTransport.this.dispatcher, newSocket, OncRpcTcpServerTransport.this.info, OncRpcTcpServerTransport.this.bufferSize, OncRpcTcpServerTransport.this, OncRpcTcpServerTransport.this.transmissionTimeout);
                            TransportList transportList = OncRpcTcpServerTransport.this.openTransports;
                            synchronized (transportList) {
                                OncRpcTcpServerTransport.this.openTransports.add(transport);
                            }
                            transport.listen();
                        }
                        return;
                    }
                    catch (OncRpcException e2) {
                        continue;
                    }
                    catch (IOException e3) {
                        if (OncRpcTcpServerTransport.this.socket == null) return;
                        continue;
                    }
                    break;
                }
            }
        };
        listenThread.setDaemon(true);
        listenThread.start();
    }

    public void setTransmissionTimeout(int milliseconds) {
        if (milliseconds <= 0) {
            throw new IllegalArgumentException("transmission timeout must be > 0");
        }
        this.transmissionTimeout = milliseconds;
    }

    public int getTransmissionTimeout() {
        return this.transmissionTimeout;
    }

    @Override
    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    @Override
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    protected OncRpcTcpConnectionServerTransport getTCPConnectionServerTransport(Socket newSocket, int bufSize) throws IOException, OncRpcException {
        return new OncRpcTcpConnectionServerTransport(this.dispatcher, newSocket, this.info, bufSize, this, this.transmissionTimeout);
    }

    private class TransportList {
        private Node head = new Node(null);
        private int size = 0;

        public TransportList() {
            this.head.next = this.head;
            this.head.prev = this.head;
        }

        public void add(Object o2) {
            Node node = new Node(o2);
            node.next = this.head.next;
            this.head.next = node;
            node.prev = this.head;
            node.next.prev = node;
            ++this.size;
        }

        public boolean remove(Object o2) {
            Node node = this.head.next;
            while (node != this.head) {
                if (node.item == o2) {
                    node.prev.next = node.next;
                    node.next.prev = node.prev;
                    --this.size;
                    return true;
                }
                node = node.next;
            }
            return false;
        }

        public Object removeFirst() {
            if (this.size == 0) {
                throw new NoSuchElementException();
            }
            Node node = this.head.next;
            this.head.next = node.next;
            node.next.prev = this.head;
            --this.size;
            return node.item;
        }

        public int size() {
            return this.size;
        }

        private class Node {
            Node next;
            Node prev;
            Object item;

            public Node(Object item) {
                this.item = item;
            }
        }
    }
}

