/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.framework.adapter;

import com.bmc.thirdparty.org.aopalliance.aop.Advice;
import com.bmc.thirdparty.org.aopalliance.intercept.Interceptor;
import com.bmc.thirdparty.org.springframework.aop.Advisor;
import com.bmc.thirdparty.org.springframework.aop.framework.adapter.AdvisorAdapter;
import com.bmc.thirdparty.org.springframework.aop.framework.adapter.AdvisorAdapterRegistry;
import com.bmc.thirdparty.org.springframework.aop.framework.adapter.AfterReturningAdviceAdapter;
import com.bmc.thirdparty.org.springframework.aop.framework.adapter.BeforeAdviceAdapter;
import com.bmc.thirdparty.org.springframework.aop.framework.adapter.ThrowsAdviceAdapter;
import com.bmc.thirdparty.org.springframework.aop.framework.adapter.UnknownAdviceTypeException;
import com.bmc.thirdparty.org.springframework.aop.support.DefaultPointcutAdvisor;
import java.util.ArrayList;
import java.util.List;

public class DefaultAdvisorAdapterRegistry
implements AdvisorAdapterRegistry {
    private final List adapters = new ArrayList(3);

    public DefaultAdvisorAdapterRegistry() {
        this.registerAdvisorAdapter(new BeforeAdviceAdapter());
        this.registerAdvisorAdapter(new AfterReturningAdviceAdapter());
        this.registerAdvisorAdapter(new ThrowsAdviceAdapter());
    }

    public Advisor wrap(Object adviceObject) throws UnknownAdviceTypeException {
        if (adviceObject instanceof Advisor) {
            return (Advisor)adviceObject;
        }
        if (!(adviceObject instanceof Advice)) {
            throw new UnknownAdviceTypeException(adviceObject);
        }
        Advice advice = (Advice)adviceObject;
        if (advice instanceof Interceptor) {
            return new DefaultPointcutAdvisor(advice);
        }
        for (int i2 = 0; i2 < this.adapters.size(); ++i2) {
            AdvisorAdapter adapter = (AdvisorAdapter)this.adapters.get(i2);
            if (!adapter.supportsAdvice(advice)) continue;
            return new DefaultPointcutAdvisor(advice);
        }
        throw new UnknownAdviceTypeException(advice);
    }

    public Interceptor[] getInterceptors(Advisor advisor) throws UnknownAdviceTypeException {
        ArrayList<Advice> interceptors = new ArrayList<Advice>(3);
        Advice advice = advisor.getAdvice();
        if (advice instanceof Interceptor) {
            interceptors.add(advice);
        }
        for (int i2 = 0; i2 < this.adapters.size(); ++i2) {
            AdvisorAdapter adapter = (AdvisorAdapter)this.adapters.get(i2);
            if (!adapter.supportsAdvice(advice)) continue;
            interceptors.add(adapter.getInterceptor(advisor));
        }
        if (interceptors.isEmpty()) {
            throw new UnknownAdviceTypeException(advisor.getAdvice());
        }
        return interceptors.toArray(new Interceptor[interceptors.size()]);
    }

    public void registerAdvisorAdapter(AdvisorAdapter adapter) {
        this.adapters.add(adapter);
    }
}

