/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jdbc.support.incrementer;

import com.bmc.thirdparty.org.springframework.beans.factory.InitializingBean;
import com.bmc.thirdparty.org.springframework.dao.DataAccessException;
import com.bmc.thirdparty.org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import javax.sql.DataSource;

public abstract class AbstractDataFieldMaxValueIncrementer
implements DataFieldMaxValueIncrementer,
InitializingBean {
    private DataSource dataSource;
    private String incrementerName;
    protected int paddingLength = 0;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setIncrementerName(String incrementerName) {
        this.incrementerName = incrementerName;
    }

    public String getIncrementerName() {
        return this.incrementerName;
    }

    public void setPaddingLength(int paddingLength) {
        this.paddingLength = paddingLength;
    }

    public int getPaddingLength() {
        return this.paddingLength;
    }

    public void afterPropertiesSet() {
        if (this.dataSource == null) {
            throw new IllegalArgumentException("dataSource is required");
        }
        if (this.incrementerName == null) {
            throw new IllegalArgumentException("incrementerName is required");
        }
    }

    public int nextIntValue() throws DataAccessException {
        return (int)this.getNextKey();
    }

    public long nextLongValue() throws DataAccessException {
        return this.getNextKey();
    }

    public String nextStringValue() throws DataAccessException {
        String s = Long.toString(this.getNextKey());
        int len = s.length();
        if (len < this.paddingLength) {
            StringBuffer buf = new StringBuffer(this.paddingLength);
            for (int i2 = 0; i2 < this.paddingLength - len; ++i2) {
                buf.append('0');
            }
            buf.append(s);
            s = buf.toString();
        }
        return s;
    }

    protected abstract long getNextKey();
}

