/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.context.access;

import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.beans.factory.access.BeanFactoryLocator;
import com.bmc.thirdparty.org.springframework.beans.factory.access.BeanFactoryReference;
import com.bmc.thirdparty.org.springframework.beans.factory.access.BootstrapException;
import com.bmc.thirdparty.org.springframework.context.ApplicationContext;
import com.bmc.thirdparty.org.springframework.context.access.ContextBeanFactoryReference;
import com.bmc.thirdparty.org.springframework.context.support.ClassPathXmlApplicationContext;
import com.bmc.thirdparty.org.springframework.jndi.JndiLocatorSupport;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import javax.naming.NamingException;

public class ContextJndiBeanFactoryLocator
extends JndiLocatorSupport
implements BeanFactoryLocator {
    public static final String BEAN_FACTORY_PATH_DELIMITERS = ",; \t\n";
    static /* synthetic */ Class class$java$lang$String;

    public BeanFactoryReference useBeanFactory(String factoryKey) throws BeansException {
        try {
            String beanFactoryPath = (String)this.lookup(factoryKey, class$java$lang$String == null ? (class$java$lang$String = ContextJndiBeanFactoryLocator.class$("java.lang.String")) : class$java$lang$String);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Bean factory path from JNDI environment variable [" + factoryKey + "] is: " + beanFactoryPath);
            }
            String[] paths = StringUtils.tokenizeToStringArray(beanFactoryPath, BEAN_FACTORY_PATH_DELIMITERS);
            return this.createBeanFactory(paths);
        }
        catch (NamingException ex) {
            throw new BootstrapException("Define an environment variable [" + factoryKey + "] containing " + "the class path locations of XML bean definition files", ex);
        }
    }

    protected BeanFactoryReference createBeanFactory(String[] resources) throws BeansException {
        ApplicationContext ctx = this.createApplicationContext(resources);
        return new ContextBeanFactoryReference(ctx);
    }

    protected ApplicationContext createApplicationContext(String[] resources) throws BeansException {
        return new ClassPathXmlApplicationContext(resources);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

