/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.plugins;

import com.bmc.arsys.api.ARNativeAuthenticationInfo;
import com.bmc.arsys.api.internal.ARStructMemTypeInfo;
import com.bmc.arsys.api.internal.ARStructTypeInfo;
import com.bmc.arsys.pluginsvr.ARPluginServerConfiguration;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

@ARStructTypeInfo(Name="PluginContext", NumberOfMembers=3)
public class ARPluginContext
implements ARNativeAuthenticationInfo {
    public static final int PLUGIN_LOG_LEVEL_INFO = 0;
    public static final int PLUGIN_LOG_LEVEL_WARNING = 1;
    public static final int PLUGIN_LOG_LEVEL_ERROR = 2;
    public static final int PLUGIN_LOG_LEVEL_FATAL = 3;
    private static String AR_PLUGIN_USER_DEFINED_TAG = "userDefined";
    @ARStructMemTypeInfo(Name="mUserName", Offset=0)
    private String mUserName;
    @ARStructMemTypeInfo(Name="mSessionGUID", Offset=1)
    private String mSessionGUID;
    @ARStructMemTypeInfo(Name="mAuthString", Offset=2)
    private String mAuthString;
    private String[] mArgs;
    private ARPluginInfo mInfo;
    private String remoteHostCharSet;
    public static final int AR_INTERNAL_REQ_CONFIG = 10005;
    private static Logger logger = Logger.getLogger(ARPluginContext.class);
    private final ReentrantLock lock = new ReentrantLock();

    public ARPluginContext(String user, String guid, String authString) {
        this.mUserName = user;
        this.mSessionGUID = guid;
        this.mAuthString = authString;
    }

    public ARPluginContext(String user, String guid, String authString, String[] args, ARPluginInfo info) {
        this.mUserName = user;
        this.mSessionGUID = guid;
        this.mAuthString = authString;
        this.mArgs = args;
        this.setPluginInfo(info);
    }

    public ARPluginContext() {
    }

    public String[] getCmdLineArgs() {
        return this.mArgs;
    }

    void setCmdLineArgs(String[] args) {
        this.mArgs = args;
    }

    public ARPluginInfo getPluginInfo() {
        return this.mInfo;
    }

    void setPluginInfo(ARPluginInfo info) {
        this.mInfo = info;
    }

    public String getUser() {
        return this.mUserName;
    }

    public String getUserSessionGuid() {
        return this.mSessionGUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void logMessage(ARPluginInfo info, int level, String message) {
        this.lock.lock();
        try {
            ARPluginInfo id = info;
            if (id == null) {
                id = this.mInfo;
            }
            String name = id != null ? id.getName() : "";
            switch (level) {
                case 0: {
                    logger.info((Object)("<" + name + ">" + message));
                    return;
                }
                case 1: {
                    logger.warn((Object)("<" + name + ">" + message));
                    return;
                }
                case 2: {
                    logger.error((Object)("<" + name + ">" + message));
                    return;
                }
                case 3: {
                    logger.fatal((Object)("<" + name + ">" + message));
                    return;
                }
                default: {
                    logger.info((Object)("<" + name + ">" + message));
                    return;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void logMessage(int level, String message) {
        this.logMessage(this.mInfo, level, message);
    }

    public String getAuthString() {
        return this.mAuthString;
    }

    public String getConfigItem(ARPluginInfo id, String key) {
        String where = null;
        if (id != null) {
            where = id.getName();
        }
        return ARPluginServerConfiguration.getInstance().getConfigValue(where, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigItem(ARPluginInfo id, String key, String value) {
        if (id != null) {
            this.lock.lock();
            try {
                ARPluginServerConfiguration.getInstance().setConfigValue(id.getName(), key, value);
                ARPluginServerConfiguration.getInstance().saveConfiguration();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public String getConfigItem(String key) {
        String value = null;
        ARPluginInfo id = this.mInfo;
        if (id != null) {
            value = ARPluginServerConfiguration.getInstance().getConfigValue(id.getName(), key);
        }
        return value;
    }

    public void setConfigItem(String key, String value) {
        ARPluginInfo id = this.mInfo;
        if (key == null || key.length() == 0) {
            return;
        }
        StringBuffer newKey = new StringBuffer();
        if (!key.startsWith(AR_PLUGIN_USER_DEFINED_TAG)) {
            newKey.append(AR_PLUGIN_USER_DEFINED_TAG + ".");
            newKey.append(key);
        } else {
            newKey.append(key);
        }
        if (id != null) {
            ARPluginServerConfiguration.getInstance().setConfigValue(id.getName(), newKey.toString(), value);
            ARPluginServerConfiguration.getInstance().saveConfiguration();
        }
    }

    public String getARConfigEntry(String key) {
        String value = "";
        if (key != null) {
            value = ARPluginServerConfiguration.getInstance().getARConfigEntry(key);
        }
        return value;
    }

    public String getRemoteHostCharSet() {
        return this.remoteHostCharSet;
    }

    void setRemoteHostCharSet(String remoteHostCharSet) {
        this.remoteHostCharSet = remoteHostCharSet;
    }
}

