/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.oncrpcext;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.arrpc.nio.ArEncryptionContext;
import com.bmc.arsys.arrpc.nio.ArEncryptionInfoI;
import com.bmc.arsys.arrpc.nio.ArNioXdrTcpEncodingStream;
import com.bmc.arsys.arrpc.rpcext.ArXdrTcpEncodingStream;
import com.bmc.arsys.arthreadlocal.ARThreadLocalStorageBlock;
import com.bmc.arsys.pluginsvr.encrypt.ARPluginServerEncryptionInfo;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.SocketChannel;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrAble;
import org.apache.log4j.Logger;

public class ARPluginSvrXdrTcpEncodingStream
extends ArNioXdrTcpEncodingStream {
    private static Logger log = Logger.getLogger(ARPluginSvrXdrTcpEncodingStream.class);
    private ArEncryptionContext mConnection;
    private ArEncryptionInfoI mEncryptionInfo;

    public ARPluginSvrXdrTcpEncodingStream(ArEncryptionContext conn, SocketChannel streamingSocket, int bufferSize) throws IOException {
        super(streamingSocket, bufferSize);
        this.mConnection = conn;
        try {
            this.mEncryptionInfo = ARPluginServerEncryptionInfo.getInstance();
        }
        catch (ARException e) {
            this.mEncryptionInfo = null;
        }
    }

    public byte[] arEncAfterXdrEncoding(byte[] bufToencode) throws OncRpcException, IOException {
        byte[] encryptedXdrData = null;
        if (this.isDataEncrypted()) {
            this.setArEncryptionOn(true);
            this.setArProcessOn(true);
            try {
                int sessionId = this.mConnection.getCurrentSessionId();
                XdrAble arXdrEnc = this.mEncryptionInfo.encryptAndXdrData(sessionId, bufToencode);
                this.arEncodeEncryptedData(arXdrEnc, (ArXdrTcpEncodingStream)this);
            }
            catch (OncRpcException e) {
                log.error((Object)"Encryption of output failed", (Throwable)e);
                throw e;
            }
        } else {
            this.setArEncryptionOn(false);
            this.setArProcessOn(false);
            encryptedXdrData = bufToencode;
        }
        return encryptedXdrData;
    }

    protected boolean isDataEncrypted() {
        boolean isEncryted = false;
        if (this.mConnection != null && this.mConnection.isCurrentCallEncrypted()) {
            isEncryted = true;
        }
        return isEncryted;
    }

    protected void holdStreamFlush() {
        super.holdStreamFlush();
    }

    public void beginEncoding(InetAddress receiverAddress, int receiverPort) throws OncRpcException, IOException {
        String charSet = ARThreadLocalStorageBlock.getTLB().getRemoteHostCharSet();
        this.setCharacterEncoding(charSet);
        if (log.isTraceEnabled()) {
            String key = ARThreadLocalStorageBlock.getTLB().getCurrentRemoteHostKey();
            log.trace((Object)("+++++++++++++++++ set " + key + " encoding " + charSet));
        }
        super.beginEncoding(receiverAddress, receiverPort);
    }
}

