/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.oncrpcext;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.arrpc.nio.ArEncryptionContext;
import com.bmc.arsys.arrpc.nio.ArEncryptionInfoI;
import com.bmc.arsys.arrpc.nio.ArNioXdrTcpDecodingStream;
import com.bmc.arsys.pluginsvr.encrypt.ARPluginServerEncryptionInfo;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.acplt.oncrpc.OncRpcException;
import org.apache.log4j.Logger;

public class ARPluginSvrXdrTcpDecodingStream
extends ArNioXdrTcpDecodingStream {
    private static Logger log = Logger.getLogger(ARPluginSvrXdrTcpDecodingStream.class);
    private ArEncryptionContext mConnection;
    private ArEncryptionInfoI mEncryptionInfo;

    public ARPluginSvrXdrTcpDecodingStream(ArEncryptionContext conn, SocketChannel streamingSocket, int bufferSize) throws IOException {
        super(streamingSocket, bufferSize);
        this.mConnection = conn;
        try {
            this.mEncryptionInfo = ARPluginServerEncryptionInfo.getInstance();
        }
        catch (ARException e) {
            this.mEncryptionInfo = null;
        }
    }

    public byte[] arEncBeforeUnXdrDecoding(byte[] bufToDecode) throws OncRpcException, IOException {
        byte[] rst = null;
        if (this.isArEncryptionOn() && this.isArProcessOn()) {
            try {
                rst = this.mEncryptionInfo.unXdrAndDecryptData(bufToDecode, this.mConnection);
            }
            catch (OncRpcException e) {
                if ("Rpc encryption error".equals(e.getMessage())) {
                    super.endDecoding();
                    int sessionId = 0;
                    try {
                        sessionId = this.mConnection.getCurrentSessionId();
                    }
                    catch (OncRpcException e1) {
                        log.debug((Object)("sessionId = " + sessionId));
                    }
                    log.error((Object)("Decrypting of the input arguments failed for sessionId: " + sessionId), (Throwable)e);
                    throw new OncRpcException("Rpc decryption error");
                }
                if (e.getReason() != 2 && e.getReason() != 7) {
                    log.error((Object)"Decoding of the input arguments failed", (Throwable)e);
                }
                this.mConnection.setCurrentCallEncryption(false);
                throw e;
            }
        }
        rst = bufToDecode;
        return rst;
    }

    public void resetArFlags() {
        this.setXdrDecodeDone(false);
        this.setDataNotInXdrBuffer(false);
    }

    public boolean isXdrDecodeDone() {
        return super.isXdrDecodeDone();
    }
}

