/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.oncrpcext;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.arrpc.nio.ArConnectionInfo;
import com.bmc.arsys.arrpc.nio.ArEncryptionContext;
import com.bmc.arsys.arrpc.nio.ArRpcCallHandler;
import com.bmc.arsys.arrpc.nio.ArSelectorThread;
import com.bmc.arsys.pluginsvr.ARPluginSvrRemoteHostInfo;
import com.bmc.arsys.pluginsvr.ARPluginSvrThreadLocalStorageBlock;
import com.bmc.arsys.pluginsvr.binding.ARPluginSvrExecutorFactory;
import com.bmc.arsys.pluginsvr.encrypt.ARPluginServerEncryptionInfo;
import com.bmc.arsys.pluginsvr.oncrpcext.ARPluginSvrXdrTcpDecodingStream;
import com.bmc.arsys.pluginsvr.oncrpcext.ARPluginSvrXdrTcpEncodingStream;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.server.OncRpcCallInformation;
import org.acplt.oncrpc.server.OncRpcDispatchable;
import org.apache.log4j.Logger;

public class ARPluginSvrRpcCallHandler
extends ArRpcCallHandler {
    private static Logger LOGGER = Logger.getLogger(ARPluginSvrRpcCallHandler.class);

    public ARPluginSvrRpcCallHandler(ArSelectorThread selectorThread, SocketChannel channel, OncRpcDispatchable dispatcher, int bufferSize, int transmissionTimeout) throws IOException {
        super(selectorThread, channel, dispatcher, bufferSize, transmissionTimeout);
    }

    protected void createXdrTcpEncodingStream(int bufferSize) throws IOException {
        if (this.getXdrEncodingStream() != null) {
            try {
                this.getXdrEncodingStream().close();
            }
            catch (OncRpcException e) {
                LOGGER.debug((Object)("EncodingStream can not be closes." + e.getLocalizedMessage()));
            }
        }
        this.setXdrTcpEncodingStream(new ARPluginSvrXdrTcpEncodingStream((ArEncryptionContext)this, this.getSocketChannel(), bufferSize));
        this.getXdrEncodingStream().setCharacterEncoding(this.getCharacterEncoding());
    }

    protected void createXdrTcpDecodingStream(int bufferSize) throws IOException {
        if (this.getXdrDecodingStream() != null) {
            try {
                this.getXdrDecodingStream().close();
            }
            catch (OncRpcException e) {
                LOGGER.debug((Object)("DecodingStream can not be closes." + e.getLocalizedMessage()));
            }
        }
        this.setXdrTcpDecodingStream(new ARPluginSvrXdrTcpDecodingStream((ArEncryptionContext)this, this.getSocketChannel(), bufferSize));
        this.getXdrDecodingStream().setCharacterEncoding(this.getCharacterEncoding());
    }

    protected void executeProcessor(ArRpcCallHandler.Processor processor) {
        ARPluginSvrExecutorFactory.getRPCCallExecutor().execute((Runnable)processor);
    }

    protected int isEncryptionPolicyValid(boolean encryptedCall, int proc_num) {
        int authStatus = 0;
        if (proc_num != 16) {
            try {
                ARPluginServerEncryptionInfo encryptInfo = ARPluginServerEncryptionInfo.getInstance();
                switch (encryptInfo.getEncryptionSecurityPolicy()) {
                    case 2: {
                        if (!encryptedCall && proc_num != 17 && proc_num != 18) break;
                        authStatus = 1;
                        break;
                    }
                    case 1: {
                        if (encryptedCall || proc_num == 17 || proc_num == 18) break;
                        authStatus = 5;
                        break;
                    }
                }
            }
            catch (ARException e) {
                LOGGER.debug((Object)("check isEncryptionPolicyValid got exception " + e.getLocalizedMessage()));
            }
        }
        return authStatus;
    }

    public void retrieveCall(XdrAble call) throws OncRpcException, IOException {
        if (this.getXdrDecodingStream() instanceof ARPluginSvrXdrTcpDecodingStream) {
            ARPluginSvrXdrTcpDecodingStream receivingXdr = (ARPluginSvrXdrTcpDecodingStream)this.getXdrDecodingStream();
            receivingXdr.resetArFlags();
            receivingXdr.setCharacterEncoding(this.getCharacterEncoding());
            receivingXdr.arExcBeforeUnXdrDecodeParams(call);
            if (!receivingXdr.isXdrDecodeDone()) {
                try {
                    call.xdrDecode((XdrDecodingStream)receivingXdr);
                }
                catch (OutOfMemoryError e) {
                    LOGGER.error((Object)"Decode mapping wrong.");
                    throw new OncRpcException(4);
                }
                if (this.isPendingDecoding()) {
                    this.setPendingDecoding(false);
                    receivingXdr.endDecoding();
                }
            }
        } else {
            super.retrieveCall(call);
        }
    }

    protected String updateRemoteHostCharSet(OncRpcCallInformation callInfo) {
        StringBuffer conKeyBuf = new StringBuffer();
        conKeyBuf.append(callInfo.peerAddress.getHostAddress());
        conKeyBuf.append(":");
        conKeyBuf.append(callInfo.peerPort);
        String key = conKeyBuf.toString();
        this.setRemoteHostKey(key);
        ARPluginSvrThreadLocalStorageBlock.getTLB().setCurrentRemoteHostKey(key);
        String remoteCharSet = ARPluginSvrRemoteHostInfo.getRemoteHostCharSet((String)key);
        ARPluginSvrThreadLocalStorageBlock.getTLB().setRemoteHostCharSet(remoteCharSet);
        this.setCharacterEncoding(remoteCharSet);
        if (LOGGER.isTraceEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("Remote host ").append(conKeyBuf.toString()).append(" uses ");
            if (!ArConnectionInfo.isRemoteHostCodeSetExist()) {
                sb.append(" default ");
            }
            sb.append(" codeset: ").append(remoteCharSet);
            LOGGER.trace((Object)sb.toString());
        }
        return remoteCharSet;
    }

    protected void setRemoteHostCharSetToStreams() {
        String key = ARPluginSvrThreadLocalStorageBlock.getTLB().getCurrentRemoteHostKey();
        String codeSet = ARPluginSvrRemoteHostInfo.getRemoteHostCharSet((String)key);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("set encode/decode streams to handle remote host request charset: " + codeSet));
        }
        this.setRemoteHostCharSet(codeSet);
        super.setRemoteHostCharSetToStreams();
    }
}

