/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.arealdap;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.plugins.arealdap.LDAPProps;
import com.bmc.arsys.pluginsvr.plugins.AREAPlugin;
import com.bmc.arsys.pluginsvr.plugins.AREAResponse;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class AREALdapPlugin
extends AREAPlugin {
    private ARPluginInfo pluginInfo = new ARPluginInfo("AREA.LDAP", this);

    public void initialize(ARPluginContext context) throws ARException {
        context.logMessage(0, "Initialising AREA LDAP plugin.");
    }

    public static void main(String[] args) {
    }

    public boolean areaNeedSync(ARPluginContext context) throws ARException {
        return false;
    }

    public AREAResponse areaVerifyLogin(ARPluginContext pluginContext, String user, String password, String networkAddress, String authString) throws ARException {
        boolean fullAuth = true;
        this.logInfoMessage(pluginContext, "areaVerifyLogin()");
        AREAResponse resp = new AREAResponse();
        LDAPProps configProps = this.initLdapProps(pluginContext);
        if (password == null) {
            fullAuth = false;
        }
        if (this.isEmpty(password) && fullAuth) {
            pluginContext.logMessage(this.pluginInfo, 2, "Password cannot be empty for external authentication");
            return null;
        }
        if (!configProps.getUseSSL()) {
            try {
                Properties env = this.configurePlainLdapProps(configProps);
                this.logInfoMessage(pluginContext, "Connecting to LDAP: " + env);
                InitialDirContext ctx = new InitialDirContext(env);
                if (ctx != null) {
                    this.logInfoMessage(pluginContext, "Successully bound to LDAP Server");
                } else {
                    this.logErrorMessage(pluginContext, "Failed to bind to the ldap");
                }
                this.logInfoMessage(pluginContext, "connect timeout used: " + configProps.getTimeout());
                String search = this.replaceKeywords(configProps.getUserBase(), null, user, authString, networkAddress);
                String filter = this.replaceKeywords(configProps.getUserFilter(), null, user, authString, networkAddress);
                SearchControls constraints = new SearchControls();
                constraints.setSearchScope(2);
                NamingEnumeration results = this.searchLdapServer(ctx, search, constraints, filter, configProps.getChaseReferral());
                String dn = this.populateUserDetails(results, resp, configProps, user, password);
                if (dn != null && configProps.getUseGroups() == 1 && password == null && configProps.getGroupBase() != null && configProps.getGroupFilter() != null) {
                    String groupFilter;
                    String groupName = "cn";
                    String groupBase = this.replaceKeywords(configProps.getGroupBase(), dn, user, authString, networkAddress);
                    NamingEnumeration groupResults = this.searchLdapServer(ctx, groupBase, constraints, groupFilter = this.replaceKeywords(configProps.getGroupFilter(), dn, user, authString, networkAddress), configProps.getChaseReferral());
                    if (groupResults != null) {
                        while (groupResults.hasMoreElements()) {
                            SearchResult currentResult = (SearchResult)results.next();
                            Attribute groups = currentResult.getAttributes().get(groupName);
                            StringBuffer groupsString = new StringBuffer();
                            for (int i = 0; i < groups.size(); ++i) {
                                groupsString.append(";" + groups.get(i));
                            }
                            if (groups.size() > 0) {
                                resp.setGroups(groupsString.toString());
                                continue;
                            }
                            resp.setGroups(configProps.getDefaultGroups());
                        }
                    }
                }
                if (dn != null) {
                    if (password != null) {
                        resp.setLoginStatus(0);
                        resp.setMessageText(null);
                        this.logInfoMessage(pluginContext, "Found valid user : " + user);
                    } else {
                        resp.setLoginStatus(2);
                        resp.setMessageText(null);
                        this.logInfoMessage(pluginContext, "Found user but password is bad");
                    }
                } else {
                    resp.setLoginStatus(1);
                    resp.setMessageText(null);
                    this.logInfoMessage(pluginContext, "We do not know the user");
                }
            }
            catch (NamingException e) {
                System.out.println(e.getMessage());
            }
        }
        return resp;
    }

    private String populateUserDetails(NamingEnumeration results, AREAResponse resp, LDAPProps props, String user, String password) throws NamingException {
        String dn = null;
        if (results != null) {
            while (results.hasMoreElements()) {
                String licenseAppAttribName;
                String licenseRes1AttribName;
                String licenseFTSAttribName;
                String licenseTypeAttribName;
                String licenseMaskAttribName;
                String notifyMethAttribName;
                SearchResult currentResult = (SearchResult)results.next();
                dn = currentResult.getNameInNamespace();
                Properties env = this.configurePlainLdapProps(props);
                env.setProperty("java.naming.security.principal", dn);
                env.setProperty("java.naming.security.credentials", password);
                try {
                    InitialDirContext dnCtx = new InitialDirContext(env);
                }
                catch (NamingException nae) {
                    dn = null;
                    continue;
                }
                Attributes attributes = currentResult.getAttributes();
                String emailAttribName = props.getEmailAttribName();
                if (emailAttribName != null) {
                    String userEmail = (String)attributes.get(emailAttribName).get();
                    if (this.isEmpty(userEmail)) {
                        resp.setEmail(this.replaceKeywords(props.getDefaultEmail(), null, user, null, null));
                    } else {
                        resp.setEmail(userEmail.toUpperCase());
                    }
                }
                int useGroups = props.getUseGroups();
                String rolesAttribName = props.getRolesAttribName();
                if (useGroups == 0 && rolesAttribName != null) {
                    Attribute roles = attributes.get(rolesAttribName);
                    StringBuffer rolesString = new StringBuffer();
                    for (int i = 0; i < roles.size(); ++i) {
                        rolesString.append(";" + roles.get(i));
                    }
                    if (roles.size() > 0) {
                        resp.setGroups(rolesString.toString());
                    } else {
                        resp.setGroups(props.getDefaultRoles());
                    }
                }
                if ((notifyMethAttribName = props.getNotifyMeth()) != null) {
                    try {
                        int notifyMech = Integer.parseInt((String)attributes.get(notifyMethAttribName).get());
                        if (notifyMech < 3) {
                            resp.setNotifyMech(notifyMech);
                        } else {
                            resp.setNotifyMech(0);
                        }
                    }
                    catch (NumberFormatException ne) {
                        resp.setNotifyMech(props.getDefaultNotifyMech());
                    }
                }
                if ((licenseMaskAttribName = props.getLicenseMaskAttribName()) != null) {
                    try {
                        int licenseMask = Integer.parseInt((String)attributes.get(licenseMaskAttribName).get());
                        resp.setLicenseMask(licenseMask);
                    }
                    catch (NumberFormatException ne) {
                        // empty catch block
                    }
                }
                if ((licenseTypeAttribName = props.getLicenseTypeAttribName()) != null) {
                    try {
                        int licenseType = Integer.parseInt((String)attributes.get(licenseTypeAttribName).get());
                        if (licenseType == 3 || licenseType == 2) {
                            resp.setLicenseWrite(licenseType);
                        } else {
                            resp.setLicenseWrite(0);
                        }
                    }
                    catch (NumberFormatException ne) {
                        resp.setLicenseWrite(0);
                    }
                }
                if ((licenseFTSAttribName = props.getLicenseFTSAttribName()) != null) {
                    try {
                        int licenseFTS = Integer.parseInt((String)attributes.get(licenseFTSAttribName).get());
                        if (licenseFTS == 3) {
                            resp.setLicenseFTS(licenseFTS);
                        } else {
                            resp.setLicenseFTS(0);
                        }
                    }
                    catch (NumberFormatException ne) {
                        resp.setLicenseFTS(0);
                    }
                }
                if ((licenseRes1AttribName = props.getLicenseRes1AttribName()) != null) {
                    try {
                        int licenseRes1 = Integer.parseInt((String)attributes.get(licenseRes1AttribName).get());
                        if (licenseRes1 == 3) {
                            resp.setLicenseRes1(licenseRes1);
                        } else {
                            resp.setLicenseRes1(0);
                        }
                    }
                    catch (NumberFormatException ne) {
                        resp.setLicenseRes1(0);
                    }
                }
                if ((licenseAppAttribName = props.getLicenseAppAttribName()) == null) continue;
                String licenseApp = (String)attributes.get(licenseAppAttribName).get();
                resp.setLicenseApps(licenseApp);
            }
        }
        return dn;
    }

    private void logErrorMessage(ARPluginContext pluginContext, String message) {
        pluginContext.logMessage(this.pluginInfo, 2, message);
    }

    private void logInfoMessage(ARPluginContext pluginContext, String message) {
        pluginContext.logMessage(this.pluginInfo, 0, message);
    }

    private Properties configurePlainLdapProps(LDAPProps props) {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", props.getURL());
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", props.getBindUser());
        env.put("java.naming.security.credentials", props.getBindPasswd());
        env.put("com.sun.jndi.ldap.connect.timeout", Integer.toString(props.getTimeout() * 1000));
        return env;
    }

    private LDAPProps initLdapProps(ARPluginContext pluginContext) {
        LDAPProps props = new LDAPProps();
        props.init(pluginContext);
        return props;
    }

    private boolean isEmpty(String password) {
        return password == null || password.equals("");
    }

    private String replaceKeywords(String src, String dn, String user, String authString, String networkAddress) {
        if (dn != null) {
            src = src.replace("$\\DN$", dn);
        }
        if (user != null) {
            src = src.replace("$\\USER$", user);
        }
        if (authString != null) {
            src = src.replace("$\\AUTHSTRING$", authString);
        }
        if (networkAddress != null) {
            src = src.replace("$\\NETWORKADDR$", networkAddress);
        }
        return src;
    }

    private NamingEnumeration searchLdapServer(DirContext ctx, String base, SearchControls scope, String filter, String chaseReferral) throws NamingException {
        NamingEnumeration<SearchResult> results = null;
        if ("F".equalsIgnoreCase(chaseReferral)) {
            results = ctx.search(base, filter, scope);
        }
        return results;
    }
}

