/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.lucene;

import com.bmc.arsys.fts.FTSService;
import com.bmc.arsys.fts.FTSServiceException;
import com.bmc.arsys.fts.impl.FTSConfiguration;
import com.bmc.arsys.fts.impl.lucene.FTSIndexSearcher;
import com.bmc.arsys.fts.impl.lucene.WordIterator;
import com.bmc.arsys.fts.impl.lucene.analyzers.FTSAnalyzer;
import com.bmc.arsys.fts.impl.lucene.analyzers.FTSAnalyzerConfigReader;
import com.bmc.arsys.fts.impl.lucene.query.FTSQueryParser;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.payloads.PayloadHelper;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.MapFieldSelector;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.NullFragmenter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.SimpleSpanFragmenter;
import org.apache.lucene.search.highlight.TokenSources;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneFTSService
implements FTSService {
    private static final Logger LOGGER = Logger.getLogger(LuceneFTSService.class);
    private static LuceneFTSService luceneFTSService = null;
    private static final int kConstantFields = 2;
    private static final int kTotalConstantFields = 5;
    private static final int FT_COMMIT_NO = 0;
    private static final int FT_COMMIT_YES = 1;
    private static final int FT_COMMIT_FIELD_DEFERRED = 2;
    private static final int FT_COMMIT_FIELD_FORCE = 4;
    private static final int kNormal = 0;
    private static final int kNormalCase = 1;
    private static final int kLiteral = 2;
    private static final int kLiteralCasel = 3;
    private static final int kNo = 0;
    private static final int kYes = 1;
    private static final String VERSION_DOCID = "##FTSIndexVersion##";
    private static final String VERSION_VERSION_FIELD = "##Version##";
    private static final String VERSION_DATE_FIELD = "##Date##";
    private static final String VERSION_VERSION = "1.0";
    private boolean caseSensitive;
    private String collectionDir;
    private String configurationDir;
    private String locale;
    private int searchThreshold;
    private static Analyzer ftsAnalyzer;
    private FTSAnalyzerConfigReader.FTSAnalyzerConfig analyzerConfig;
    private boolean isWriter = false;
    public boolean doNormal = false;
    public boolean doNormalCase = false;
    public boolean doLiteral = false;
    public boolean doLiteralCase = false;
    private static Date recentInit;
    private static Hashtable<String, ArrayList<FieldDataHolder>> entryFieldQueue;
    private static int memCheckCount;
    private static int checkCount;
    private static IndexWriter staticIndexWriter;
    private static ArrayList<IndexSearcher> indexSearcherQueue;

    private LuceneFTSService() {
    }

    public static synchronized LuceneFTSService getLuceneFTSService() {
        if (luceneFTSService == null) {
            luceneFTSService = new LuceneFTSService();
        }
        return luceneFTSService;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public int getIndexCount() {
        int nTheCount = 0;
        try {
            nTheCount = this.getIndexSearcher().getIndexReader().numDocs();
        }
        catch (Exception e) {
            LOGGER.error((Object)"FTS: Error getting the index count.", (Throwable)e);
        }
        return nTheCount;
    }

    @Override
    public synchronized void init(FTSConfiguration ftsConfiguration) throws FTSServiceException {
        this.init(ftsConfiguration, true);
    }

    @Override
    public synchronized void init(FTSConfiguration ftsConfiguration, boolean isWriter) throws FTSServiceException {
        this.isWriter = isWriter;
        this.collectionDir = ftsConfiguration.getFullTextCollectionDir();
        this.caseSensitive = ftsConfiguration.isFullTextCaseInSensitive();
        this.locale = ftsConfiguration.getFullTextLocale();
        this.configurationDir = ftsConfiguration.getFullTextConfigurationDir();
        this.searchThreshold = ftsConfiguration.getSearchThreshold() == 0 ? 1000000 : ftsConfiguration.getSearchThreshold();
        this.updateConfiguration();
        this.init(isWriter);
    }

    private boolean initExpired() {
        Boolean bReturn = false;
        Date now = new Date();
        if (now.getTime() - recentInit.getTime() >= 10000L) {
            bReturn = true;
        }
        return bReturn;
    }

    private synchronized void init(boolean isWriter) throws FTSServiceException {
        if (recentInit == null || this.initExpired()) {
            LOGGER.debug((Object)"The init is happening.");
            this.initAnalyzer(this.caseSensitive);
            if (isWriter) {
                IndexWriter indexWriter;
                if (staticIndexWriter != null) {
                    try {
                        staticIndexWriter.close();
                    }
                    catch (CorruptIndexException e) {
                        throw new FTSServiceException(this.getClass().getName() + " init: The index is corrupt", e);
                    }
                    catch (IOException e) {
                        throw new FTSServiceException(this.getClass().getName() + " init: Cannot close index", e);
                    }
                    staticIndexWriter = null;
                }
                if ((indexWriter = this.getIndexWriter(ftsAnalyzer)) != null) {
                    this.checkIndexVersion();
                    this.commit();
                } else {
                    LOGGER.warn((Object)("FTS: Missing IndexWriter for Analyzer '" + ftsAnalyzer + "'"));
                }
            }
            recentInit = new Date();
        } else {
            LOGGER.debug((Object)"Init is skipped due to one happening in last 10 seconds");
        }
    }

    private void checkIndexVersion() throws FTSServiceException {
        Document document = this.getDocumentById(VERSION_DOCID);
        if (document == null) {
            document = new Document();
            Field.Index fieldIndex = Field.Index.NOT_ANALYZED;
            Field.Store fieldStore = Field.Store.YES;
            Field.TermVector termVector = Field.TermVector.NO;
            document.add((Fieldable)new Field("docId", VERSION_DOCID, fieldStore, fieldIndex, termVector));
            fieldIndex = Field.Index.NO;
            document.add((Fieldable)new Field(VERSION_VERSION_FIELD, VERSION_VERSION, fieldStore, fieldIndex, termVector));
            document.add((Fieldable)new Field(VERSION_DATE_FIELD, new Date().toString(), fieldStore, fieldIndex, termVector));
            try {
                staticIndexWriter.addDocument(document);
            }
            catch (IOException e) {
                throw new FTSServiceException(this.getClass().getName() + " checkIndexVersion: Error adding index version", e);
            }
        }
        if (!document.get(VERSION_VERSION_FIELD).equals(VERSION_VERSION)) {
            // empty if block
        }
    }

    @Override
    public void setDocBoost(String schemaId, String entryId, float docBoost) throws FTSServiceException {
        this.notWriterExceptionCheck("setDocBoost");
        if (entryId == null || entryId.equals("0") || entryId.length() == 0) {
            FTSQueryParser ftsQueryParser = new FTSQueryParser((FTSAnalyzer)ftsAnalyzer);
            ArrayList<FTSService.EntryData> entryData = this.getEntryIdsByQuery((Query)ftsQueryParser.schemaQuery((String)schemaId), null, null, (boolean)false, (int)0, null, null, null, null, (int)0, null, null).resultList;
            for (FTSService.EntryData ed : entryData) {
                this.indexEntryFields(schemaId, ed.entryId, docBoost, null, null, null, null, 0);
            }
            this.commit();
        } else {
            this.indexEntryFields(schemaId, entryId, docBoost, null, null, null, null, 1);
        }
    }

    private int getFieldSize(ArrayList<FieldDataHolder> fields) {
        int nReturn = 2;
        for (FieldDataHolder fdh : fields) {
            if (fdh.fieldNames.length == 1) {
                ++nReturn;
                continue;
            }
            nReturn = nReturn + fdh.fieldNames.length - 2;
        }
        return nReturn;
    }

    @Override
    public synchronized void indexEntryFields(String schemaId, String entryId, float docBoost, String[] fieldNames, String[] values, BitSet[] fullTextOptions, float[] fieldBoost, int doCommit) throws FTSServiceException {
        this.notWriterExceptionCheck("indexEntryFields");
        String key = this.buildDocId(schemaId, entryId);
        if (doCommit == 2) {
            if (entryFieldQueue.containsKey(key)) {
                ArrayList<FieldDataHolder> fields = entryFieldQueue.get(key);
                fields.add(new FieldDataHolder(schemaId, entryId, docBoost, fieldNames, values, fullTextOptions, fieldBoost));
            } else {
                ArrayList<FieldDataHolder> fields = new ArrayList<FieldDataHolder>();
                fields.add(new FieldDataHolder(schemaId, entryId, docBoost, fieldNames, values, fullTextOptions, fieldBoost));
                entryFieldQueue.put(key, fields);
            }
        } else if (doCommit > 2) {
            if (entryFieldQueue.containsKey(key)) {
                ArrayList<FieldDataHolder> fields = entryFieldQueue.get(key);
                fields.add(new FieldDataHolder(schemaId, entryId, docBoost, fieldNames, values, fullTextOptions, fieldBoost));
                int size = this.getFieldSize(fields);
                String[] fieldNamesAll = new String[size];
                String[] valuesAll = new String[size];
                BitSet[] fullTextOptionsAll = new BitSet[size];
                float[] fieldBoost2 = new float[size];
                boolean processedkConstantFields = false;
                int count = 0;
                for (FieldDataHolder fdh : fields) {
                    int fieldCount = fdh.fieldNames.length;
                    if (fieldCount > 1 && !processedkConstantFields) {
                        for (int x = 0; x < 2; ++x) {
                            fieldNamesAll[count] = fdh.fieldNames[x];
                            valuesAll[count] = fdh.values[x];
                            fullTextOptionsAll[count] = fdh.fullTextOptions[x];
                            fieldBoost2[count] = fdh.fieldBoost[x];
                            ++count;
                        }
                        processedkConstantFields = true;
                    }
                    int fieldsToProcess = 0;
                    if (fieldCount > 1) {
                        fieldsToProcess = 2;
                    }
                    for (int x = fieldsToProcess; x < fdh.fieldNames.length; ++x) {
                        fieldNamesAll[count] = fdh.fieldNames[x];
                        valuesAll[count] = fdh.values[x];
                        fullTextOptionsAll[count] = fdh.fullTextOptions[x];
                        fieldBoost2[count] = fdh.fieldBoost[x];
                        ++count;
                    }
                }
                this.indexEntryFieldsAll(schemaId, entryId, docBoost, fieldNamesAll, valuesAll, fullTextOptionsAll, fieldBoost2, doCommit);
                entryFieldQueue.remove(key);
            } else {
                this.indexEntryFieldsAll(schemaId, entryId, docBoost, fieldNames, values, fullTextOptions, fieldBoost, doCommit);
            }
        } else {
            this.indexEntryFieldsAll(schemaId, entryId, docBoost, fieldNames, values, fullTextOptions, fieldBoost, doCommit);
        }
    }

    private void freeMemCheck() throws FTSServiceException {
        if (memCheckCount == checkCount) {
            memCheckCount = 0;
            Runtime runtime = Runtime.getRuntime();
            float freeMemory = runtime.freeMemory();
            float totalMemory = runtime.totalMemory();
            float usedMemory = totalMemory - freeMemory;
            float percentMemory = usedMemory / totalMemory;
            LOGGER.debug((Object)("freeMemCheck is checking percent of memory used: " + percentMemory));
            LOGGER.debug((Object)("freeMemCheck is checking percent of memory every: " + checkCount));
            if ((double)percentMemory >= 0.9) {
                checkCount = 1000;
                LOGGER.debug((Object)"freeMemCheck has determined memory is too low and issuing an init to free memory");
                this.init(true);
            } else {
                checkCount = (double)percentMemory >= 0.8 ? 100 : ((double)percentMemory >= 0.7 ? 500 : 1000);
            }
        } else {
            ++memCheckCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexEntryFieldsAll(String schemaId, String entryId, float docBoost, String[] fieldNames, String[] values, BitSet[] fullTextOptions, float[] fieldBoost, int doCommit) throws FTSServiceException {
        try {
            String docId = this.buildDocId(schemaId, entryId);
            Document document = this.getDocumentById(docId, true);
            Analyzer analyzer = ftsAnalyzer;
            if (document == null && fieldNames == null) {
                return;
            }
            if (document == null) {
                IndexWriter indexWriter;
                document = this.createDocument(docId, schemaId, entryId);
                for (int i = 0; i < fieldNames.length; ++i) {
                    if (fieldNames[i] == null || fieldNames[i].startsWith("DEL_")) continue;
                    int len = values[i].length() > 20 ? 20 : values[i].length();
                    LOGGER.info((Object)("FTS: Indexing with " + analyzer.getClass().getSimpleName() + "-> Schema id = " + schemaId + ", Entry id = " + entryId + ", Field id =  " + fieldNames[i] + ", Value(first 20) = " + values[i].substring(0, len) + ", Literal indexing = " + fullTextOptions[i].get(1)));
                    if (fieldNames[i].equals("modifiedTime") || fieldNames[i].equals("createTime")) {
                        Long dateAsLong = Long.parseLong(values[i]);
                        document.add((Fieldable)new NumericField(fieldNames[i], Field.Store.YES, true).setLongValue(dateAsLong.longValue()));
                        continue;
                    }
                    document.add((Fieldable)new Field(fieldNames[i] + "_orig", values[i], Field.Store.YES, Field.Index.NO, Field.TermVector.NO));
                    document.add((Fieldable)new Field(fieldNames[i] + "_bytes", this.setFieldBytes(fullTextOptions[i].get(1)), Field.Store.YES));
                    if (fieldBoost == null || fieldBoost[i] == 1.0f) continue;
                    document.add((Fieldable)new Field(fieldNames[i] + "_fieldBoost", PayloadHelper.encodeFloat((float)fieldBoost[i]), Field.Store.YES));
                }
                List fieldList = document.getFields();
                document = this.createFieldVariations(document, fieldList);
                if (docBoost != 1.0f) {
                    document.setBoost(docBoost);
                }
                if ((indexWriter = this.getIndexWriter(analyzer)) != null) {
                    indexWriter.addDocument(document);
                } else {
                    LOGGER.warn((Object)("FTS: Missing IndexWriter for Analyzer '" + analyzer + "'"));
                }
            } else {
                List fieldList;
                List list = fieldList = document.getFields();
                synchronized (list) {
                    if (fieldNames != null) {
                        String dataName;
                        String origName;
                        int i;
                        for (i = 0; i < fieldNames.length; ++i) {
                            if (fieldNames[i] == null || fieldNames[i].startsWith("DEL_")) continue;
                            int len = values[i].length() > 20 ? 20 : values[i].length();
                            LOGGER.info((Object)("FTS: Updating with " + analyzer.getClass().getSimpleName() + "-> Schema id = " + schemaId + ", Entry id = " + entryId + ", Field id =  " + fieldNames[i] + ", Value(first 20) = " + values[i].substring(0, len) + ", Literal indexing = " + fullTextOptions[i].get(1)));
                            if (fieldNames[i].equals("modifiedTime") || fieldNames[i].equals("createTime")) {
                                document.removeField(fieldNames[i]);
                                Long dateAsLong = Long.parseLong(values[i]);
                                document.add((Fieldable)new NumericField(fieldNames[i], Field.Store.YES, true).setLongValue(dateAsLong.longValue()));
                                continue;
                            }
                            origName = fieldNames[i] + "_orig";
                            dataName = fieldNames[i] + "_bytes";
                            document.removeField(origName);
                            document.removeField(dataName);
                            document.add((Fieldable)new Field(origName, values[i], Field.Store.YES, Field.Index.NO, Field.TermVector.NO));
                            document.add((Fieldable)new Field(dataName, this.setFieldBytes(fullTextOptions[i].get(1)), Field.Store.YES));
                        }
                        for (i = 0; i < fieldNames.length; ++i) {
                            if (fieldNames[i] == null || !fieldNames[i].startsWith("DEL_")) continue;
                            String strFieldName = fieldNames[i].substring(4);
                            origName = strFieldName + "_orig";
                            dataName = strFieldName + "_bytes";
                            document.removeField(origName);
                            document.removeField(dataName);
                        }
                    }
                    document = this.createFieldVariations(document, fieldList);
                    if (docBoost != 1.0f) {
                        document.setBoost(docBoost);
                    }
                }
                if (fieldList.size() > 5) {
                    this.updateByField("docId", docId, document, analyzer);
                } else {
                    this.deleteEntryDocument(docId);
                }
            }
            if (doCommit == 1 || doCommit == 4) {
                this.commit();
            }
        }
        catch (CorruptIndexException e) {
            throw new FTSServiceException(this.getClass().getName() + " init: The index is corrupt", e);
        }
        catch (IOException e) {
            throw new FTSServiceException(this.getClass().getName() + " init: Cannot add to the index or close index", e);
        }
    }

    @Override
    public synchronized void commit() throws FTSServiceException {
        this.notWriterExceptionCheck("commit");
        try {
            staticIndexWriter.commit();
        }
        catch (CorruptIndexException e) {
            throw new FTSServiceException(this.getClass().getName() + " init: The index is corrupt", e);
        }
        catch (IOException e) {
            throw new FTSServiceException(this.getClass().getName() + " init: Cannot add to the index or close index", e);
        }
    }

    private Document createFieldVariations(Document document, List<Field> fieldList) {
        ArrayList<Field> copyList = new ArrayList<Field>(fieldList);
        Field.Index fieldIndex = Field.Index.ANALYZED;
        Field.Store fieldStore = Field.Store.NO;
        Field.TermVector termVector = Field.TermVector.WITH_POSITIONS_OFFSETS;
        for (AbstractField abstractField : copyList) {
            String fieldName = abstractField.name();
            if (!fieldName.endsWith("_orig") || fieldName.startsWith("createTime") || fieldName.startsWith("modifiedTime")) continue;
            String origValue = document.get(fieldName);
            String origFieldName = fieldName.substring(0, fieldName.length() - 5);
            byte[] bytes = document.getBinaryValue(origFieldName + "_bytes");
            byte[] fieldBoost = document.getBinaryValue(origFieldName + "_fieldBoost");
            if (bytes.length != 4) continue;
            if (bytes[0] == 1) {
                document.add((Fieldable)this.boostField(new Field(origFieldName, origValue, fieldStore, fieldIndex, termVector), fieldBoost));
            }
            if (bytes[1] == 1) {
                document.add((Fieldable)this.boostField(new Field(origFieldName + "_case", origValue, fieldStore, fieldIndex, termVector), fieldBoost));
            }
            if (bytes[2] == 1) {
                document.add((Fieldable)this.boostField(new Field(origFieldName + "_literal", origValue.replaceAll("~!~", "\u0015"), fieldStore, fieldIndex, termVector), fieldBoost));
            }
            if (bytes[3] != 1) continue;
            document.add((Fieldable)this.boostField(new Field(origFieldName + "_literalCase", origValue.replaceAll("~!~", "\u0015"), fieldStore, fieldIndex, termVector), fieldBoost));
        }
        return document;
    }

    private Field boostField(Field field, byte[] fieldBoost) {
        if (fieldBoost != null) {
            field.setBoost(PayloadHelper.decodeFloat((byte[])fieldBoost));
        }
        return field;
    }

    private byte[] setFieldBytes(boolean literal) {
        byte[] data = new byte[]{0, 0, 0, 0};
        if (this.doNormal || !this.caseSensitive && !literal) {
            data[0] = 1;
        }
        if (this.doNormalCase || this.caseSensitive && !literal) {
            data[1] = 1;
        }
        if (this.doLiteral || !this.caseSensitive && literal) {
            data[2] = 1;
        }
        if (this.doLiteralCase || this.caseSensitive && literal) {
            data[3] = 1;
        }
        return data;
    }

    private void addFieldToDocument(Document document, String fieldName, Reader reader, BitSet fullTextOption) {
        document.add((Fieldable)new Field(fieldName + "_orig", reader, Field.TermVector.NO));
        document.add((Fieldable)new Field(fieldName + "_bytes", this.setFieldBytes(fullTextOption.get(1)), Field.Store.YES));
        List fieldList = document.getFields();
        document = this.createFieldVariations(document, fieldList);
    }

    @Override
    public void deleteEntryDocument(String schemaId, String entryId) throws FTSServiceException {
        this.notWriterExceptionCheck("deleteEntryDocument");
        LOGGER.info((Object)("FTS: delete from index - Schema id = " + schemaId + ", Entry id = " + entryId));
        String docId = this.buildDocId(schemaId, entryId);
        this.deleteEntryDocument(docId);
    }

    @Override
    public void deleteIndexDir() throws FTSServiceException {
        this.notWriterExceptionCheck("deleteIndexDir");
        LOGGER.info((Object)"FTS: delete index - all document");
        this.close();
        boolean bSuccess = true;
        File indexDir = new File(this.collectionDir);
        File[] indexFiles = indexDir.listFiles();
        if (indexFiles != null) {
            for (int x = 0; x < indexFiles.length; ++x) {
                if (!indexFiles[x].isFile() || indexFiles[x].delete()) continue;
                bSuccess = false;
            }
        }
        if (!bSuccess) {
            throw new FTSServiceException(this.getClass().getName() + " deleteIndexDir: Failed to delete index.");
        }
    }

    @Override
    public synchronized void removeFieldFromDocumentsByQuery(String fieldName, String[] queryFieldNames, String[] queryFieldValues) throws FTSServiceException {
        this.notWriterExceptionCheck("removeFieldFromDocumentsByQuery");
        this.removeFieldFromDocumentsByQuery(fieldName, queryFieldNames, queryFieldValues, 1);
    }

    @Override
    public synchronized void removeFieldFromDocumentsByQuery(String fieldName, String[] queryFieldNames, String[] queryFieldValues, int doCommit) throws FTSServiceException {
        this.notWriterExceptionCheck("removeFieldFromDocumentsByQuery(2)");
        if (doCommit > 1) {
            String schemaId = null;
            String entryId = null;
            for (int x = 0; x < queryFieldNames.length; ++x) {
                if (queryFieldNames[x].equals("schemaId")) {
                    schemaId = queryFieldValues[x];
                    continue;
                }
                if (!queryFieldNames[x].equals("entryId")) continue;
                entryId = queryFieldValues[x];
            }
            if (schemaId != null) {
                String[] fieldNames = new String[]{"DEL_" + fieldName};
                String[] values = new String[]{null};
                BitSet bitSet = new BitSet(1);
                bitSet.set(0);
                BitSet[] fullTextOptions = new BitSet[]{bitSet};
                float[] fieldBoost = new float[]{1.0f};
                this.indexEntryFields(schemaId, entryId, 1.0f, fieldNames, values, fullTextOptions, fieldBoost, doCommit);
            }
        } else {
            FTSQueryParser ftsQueryParser = new FTSQueryParser((FTSAnalyzer)ftsAnalyzer);
            Query query = ftsQueryParser.createDeleteFieldQuery(fieldName, queryFieldNames, queryFieldValues);
            IndexSearcher indexSearcher = this.getIndexSearcher();
            TopDocs matchingDocs = null;
            try {
                matchingDocs = indexSearcher.search(query, 10000);
                ScoreDoc[] hits = matchingDocs.scoreDocs;
                for (int x = 0; x < hits.length; ++x) {
                    Document document = indexSearcher.doc(hits[x].doc);
                    document.removeField(fieldName + "_orig");
                    document.removeField(fieldName + "_bytes");
                    List fieldList = document.getFields();
                    Field docId = document.getField("docId");
                    if (fieldList.size() > 5) {
                        document = this.createFieldVariations(document, fieldList);
                        this.updateByField("docId", docId.stringValue(), document, ftsAnalyzer);
                        continue;
                    }
                    this.deleteEntryDocument(docId.stringValue());
                }
                if (doCommit == 1) {
                    this.commit();
                }
            }
            catch (IOException e) {
                throw new FTSServiceException(this.getClass().getName() + " removeFieldFromDocumentsByQuery: Problem searching the index", e);
            }
        }
    }

    @Override
    public List<FTSService.EntryData> getEntryIdsByQuery(String schemaId, String[] queryFieldNames, String[] queryFieldValues, BitSet[] fullTextOptions) throws FTSServiceException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Search Schema ID: " + schemaId + "; Field and Terms: " + this.getFieldTermsForLogger(queryFieldNames, queryFieldValues)));
        }
        FTSQueryParser ftsQueryParser = new FTSQueryParser((FTSAnalyzer)ftsAnalyzer);
        Query query = ftsQueryParser.createQuery(schemaId, queryFieldNames, queryFieldValues, fullTextOptions, this.caseSensitive);
        return this.getEntryIdsByQuery((Query)query, null, null, (boolean)false, (int)0, null, null, null, null, (int)0, null, null).resultList;
    }

    private String getFieldTermsForLogger(String[] queryFieldNames, String[] queryFieldValues) {
        StringBuffer strBufReturn = new StringBuffer("");
        for (int x = 0; x < queryFieldNames.length; ++x) {
            strBufReturn.append("[" + queryFieldNames[x] + ":" + queryFieldValues[x] + "] ");
        }
        return strBufReturn.toString();
    }

    private String getSchemaFieldsForLogger(ArrayList<FTSService.QuerySchemas> querySchemas) {
        StringBuffer strBufReturn = new StringBuffer("");
        if (querySchemas != null) {
            for (FTSService.QuerySchemas qs : querySchemas) {
                strBufReturn.append("[" + qs.schemaId + ": ");
                for (String field : qs.queryFieldNames) {
                    strBufReturn.append(field + ", ");
                }
                strBufReturn.append("] ");
            }
        }
        return strBufReturn.toString();
    }

    private String getReturnFieldsForLogger(ArrayList<FTSService.ReturnFilterFields> returnFilterFields) {
        StringBuffer strBufReturn = new StringBuffer("");
        if (returnFilterFields != null) {
            for (FTSService.ReturnFilterFields rff : returnFilterFields) {
                strBufReturn.append(rff.filterField + ", ");
            }
        }
        return strBufReturn.toString();
    }

    private boolean isUnqualifiedWildcard(String shouldQueryValue, String mustQueryValue, String notQueryValue) {
        boolean bReturn = false;
        if (shouldQueryValue != null && shouldQueryValue.trim().equals("%")) {
            bReturn = true;
        } else if (mustQueryValue != null && mustQueryValue.trim().equals("%")) {
            bReturn = true;
        } else if (notQueryValue != null && notQueryValue.trim().equals("%")) {
            bReturn = true;
        }
        return bReturn;
    }

    @Override
    public FTSService.FTSResultSet getEntryIdsByGlobalQuery(String shouldQueryValue, String mustQueryValue, String notQueryValue, ArrayList<FTSService.QuerySchemas> querySchemas, String filterQuery, ArrayList<FTSService.ReturnFilterFields> returnFilterFields, String sortOrder, int resultOption, String returnEntries, int maxReturn) throws FTSServiceException {
        return this.getEntryIdsByGlobalQuery(shouldQueryValue, mustQueryValue, notQueryValue, querySchemas, filterQuery, returnFilterFields, sortOrder, resultOption, returnEntries, maxReturn, "[", "]");
    }

    @Override
    public FTSService.FTSResultSet getEntryIdsByGlobalQuery(String shouldQueryValue, String mustQueryValue, String notQueryValue, ArrayList<FTSService.QuerySchemas> querySchemas, String filterQuery, ArrayList<FTSService.ReturnFilterFields> returnFilterFields, String sortOrder, int resultOption, String returnEntries, int maxReturn, String markupLeft, String markupRight) throws FTSServiceException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Threshold set by AR: " + this.searchThreshold));
            LOGGER.debug((Object)("Search Terms - Must: " + mustQueryValue + "; Should: " + shouldQueryValue + "; Must Not: " + notQueryValue));
            LOGGER.debug((Object)("Search Filter Query: " + filterQuery));
            LOGGER.debug((Object)("Search Schema IDs and Fields - " + this.getSchemaFieldsForLogger(querySchemas)));
            LOGGER.debug((Object)("Search Return Fields: " + this.getReturnFieldsForLogger(returnFilterFields)));
            LOGGER.debug((Object)("Search Sort Order: " + sortOrder));
            LOGGER.debug((Object)("Search Result Option: " + resultOption));
            LOGGER.debug((Object)("Search Return Entries: " + returnEntries));
            LOGGER.debug((Object)("Search Max Return: " + maxReturn));
        }
        boolean unqualifiedWildcard = false;
        unqualifiedWildcard = this.isUnqualifiedWildcard(shouldQueryValue, mustQueryValue, notQueryValue);
        if (unqualifiedWildcard && resultOption == 2) {
            resultOption = 1;
        }
        if (shouldQueryValue != null && shouldQueryValue.length() == 1 && shouldQueryValue.codePointAt(0) == 32) {
            shouldQueryValue = null;
        }
        if (mustQueryValue != null && mustQueryValue.length() == 1 && mustQueryValue.codePointAt(0) == 32) {
            mustQueryValue = null;
        }
        if (notQueryValue != null && notQueryValue.length() == 1 && notQueryValue.codePointAt(0) == 32) {
            notQueryValue = null;
        }
        if (filterQuery != null && filterQuery.length() == 1 && filterQuery.codePointAt(0) == 32) {
            filterQuery = null;
        }
        FTSQueryParser ftsQueryParser = new FTSQueryParser((FTSAnalyzer)ftsAnalyzer);
        Query query = null;
        Query queryOld = null;
        Hashtable<String, String> returnEntriesHash = null;
        if (returnEntries != null && returnEntries.length() != 0) {
            returnEntriesHash = this.prepareReturnEntries(returnEntries);
            LOGGER.debug((Object)("Number of entries to fetch for phase 2: " + returnEntriesHash.size()));
            query = ftsQueryParser.docIdQuery(returnEntriesHash);
            queryOld = ftsQueryParser.createGlobalQuery(shouldQueryValue, mustQueryValue, notQueryValue, querySchemas, this.caseSensitive);
        } else {
            query = unqualifiedWildcard ? ftsQueryParser.unqualifiedWildcardQuery(querySchemas) : ftsQueryParser.createGlobalQuery(shouldQueryValue, mustQueryValue, notQueryValue, querySchemas, this.caseSensitive);
        }
        Filter filter = null;
        if (filterQuery != null && (returnEntries == null || returnEntries.length() == 0)) {
            filter = ftsQueryParser.createGlobalFilter(filterQuery, this.caseSensitive);
        }
        String sortOrder2 = sortOrder;
        if (returnEntries != null && sortOrder == null) {
            sortOrder2 = "4;2";
        }
        return this.getEntryIdsByQuery(query, queryOld, filter, true, resultOption, returnFilterFields, querySchemas, sortOrder2, returnEntriesHash, maxReturn, markupLeft, markupRight);
    }

    private Hashtable<String, String> prepareReturnEntries(String returnEntries) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] splitString = returnEntries.split(";");
        for (int x = 0; x < splitString.length; ++x) {
            if (splitString[x] == null || splitString[x].length() == 0) continue;
            String[] xdocid = splitString[x].split("@@");
            hashtable.put(xdocid[0], xdocid[1]);
        }
        return hashtable;
    }

    private FTSService.FTSResultSet getEntryIdsByQuery(Query query, Query queryOld, Filter filter, boolean isGlobal, int resultOption, ArrayList<FTSService.ReturnFilterFields> returnFilterFields, ArrayList<FTSService.QuerySchemas> querySchemas, String sortOrder, Hashtable<String, String> returnEntries, int maxReturn, String markupLeft, String markupRight) throws FTSServiceException {
        Query query2 = null;
        FTSService.FTSResultSet resultSet = new FTSService.FTSResultSet();
        ArrayList<FTSService.GlobalEntryData> returnList = new ArrayList<FTSService.GlobalEntryData>();
        IndexSearcher indexSearcher = this.getIndexSearcher();
        ((FTSIndexSearcher)indexSearcher).setCount(true);
        TopDocs matchingDocs = null;
        int maxToReturn = this.searchThreshold;
        if (maxReturn > 0 && maxReturn < this.searchThreshold) {
            maxToReturn = maxReturn;
        }
        LOGGER.debug((Object)("maxToReturn: " + maxToReturn));
        try {
            LOGGER.debug((Object)"Making initial search request");
            matchingDocs = indexSearcher.search(query, filter, maxToReturn);
            LOGGER.debug((Object)"Completed initial search request");
            resultSet.numMatches = matchingDocs.totalHits;
            if (resultOption != 3) {
                float maxScore = matchingDocs.getMaxScore();
                ScoreDoc[] hits = matchingDocs.scoreDocs;
                if (resultOption == 4) {
                    LOGGER.debug((Object)("Phase 1: Getting Enty ID / Schema data only: " + hits.length));
                } else {
                    LOGGER.debug((Object)("Phase 2:  Getting All column data: " + hits.length));
                }
                MapFieldSelector fieldSelector = null;
                if (!isGlobal || isGlobal && resultOption == 4) {
                    fieldSelector = new MapFieldSelector(this.getFieldsToFetch(sortOrder));
                }
                for (int i = 0; i < hits.length; ++i) {
                    ArrayList<FTSService.ReturnFilterFields> rff = new ArrayList<FTSService.ReturnFilterFields>();
                    Document document = null;
                    document = !isGlobal || isGlobal && resultOption == 4 ? indexSearcher.doc(hits[i].doc, (FieldSelector)fieldSelector) : indexSearcher.doc(hits[i].doc);
                    FTSService.EntryData entryData = isGlobal ? new FTSService.GlobalEntryData() : new FTSService.EntryData();
                    Field schemaField = document.getField("schemaId");
                    Field entryField = document.getField("entryId");
                    entryData.schemaId = schemaField.stringValue();
                    if (entryField == null) continue;
                    entryData.entryId = entryField.stringValue();
                    entryData.score = returnEntries != null ? Float.parseFloat(returnEntries.get(this.buildDocId(entryData.schemaId, entryData.entryId))) : hits[i].score / maxScore * 100.0f;
                    if (isGlobal && resultOption != 4 || isGlobal && sortOrder != null) {
                        if (query2 == null && queryOld == null) {
                            query2 = query.rewrite(indexSearcher.getIndexReader());
                        } else if (query2 == null) {
                            query2 = queryOld.rewrite(indexSearcher.getIndexReader());
                        }
                        Field titleField = document.getField("title_orig");
                        Field createDate = document.getField("createTime");
                        Field modifiedDate = document.getField("modifiedTime");
                        entryData.title = titleField != null ? this.highlightTitleText(indexSearcher.getIndexReader(), hits[i].doc, this.getFieldName(document, "title"), query2, titleField.stringValue(), resultOption, markupLeft, markupRight) : "";
                        if (resultOption != 4) {
                            entryData.excerpt = this.getExcerptText(document, resultOption, query2, indexSearcher.getIndexReader(), hits[i].doc, querySchemas, markupLeft, markupRight);
                        }
                        entryData.createDate = createDate != null ? createDate.stringValue() : "";
                        entryData.modifiedDate = modifiedDate != null ? modifiedDate.stringValue() : "";
                        if (returnFilterFields != null) {
                            for (FTSService.ReturnFilterFields rff2 : returnFilterFields) {
                                Field field = document.getField(rff2.filterField + "_orig");
                                String tempValue = "";
                                if (field != null) {
                                    tempValue = field.stringValue();
                                }
                                rff.add(new FTSService.ReturnFilterFields(rff2.filterField, tempValue));
                            }
                            entryData.returnFilterFields = rff;
                        }
                    }
                    returnList.add((FTSService.GlobalEntryData)entryData);
                }
                if (resultOption == 4) {
                    LOGGER.debug((Object)("Phase 1:  Completed getting Enty ID / Schema data only: " + returnList.size()));
                } else {
                    LOGGER.debug((Object)("Phase 2:  Completed getting All column data: " + returnList.size()));
                }
            }
        }
        catch (CorruptIndexException e) {
            throw new FTSServiceException(this.getClass().getName() + " getEntryIdsByQuery: Problem searching the index: Corrupt Index Exception ", e);
        }
        catch (IOException e) {
            throw new FTSServiceException(this.getClass().getName() + " getEntryIdsByQuery: Problem searching the index: IO Exception ", e);
        }
        finally {
            ((FTSIndexSearcher)indexSearcher).setCount(false);
        }
        if (!isGlobal) {
            Collections.sort(returnList);
        } else if (isGlobal && sortOrder != null) {
            EntryDataSorter entryDataSorter = new EntryDataSorter();
            entryDataSorter.setFieldsToSort(sortOrder);
            EntryDataSorter comparator = entryDataSorter;
            Collections.sort(returnList, comparator);
        }
        resultSet.resultList = returnList;
        LOGGER.debug((Object)("Search results count: " + resultSet.numMatches));
        return resultSet;
    }

    private String[] getFieldsToFetch(String sortOrder) {
        if (sortOrder == null || sortOrder.length() == 0) {
            return new String[]{"schemaId", "entryId"};
        }
        String[] fieldsToSort = sortOrder.split(";");
        ArrayList<String> arrayList = new ArrayList<String>(fieldsToSort.length / 2);
        arrayList.add("schemaId");
        arrayList.add("entryId");
        for (int x = 0; x < fieldsToSort.length; x += 2) {
            if (fieldsToSort[x].equals("0") || fieldsToSort[x].equals("1") || fieldsToSort[x].equals("4")) continue;
            if (fieldsToSort[x].equals("2")) {
                arrayList.add("title");
                continue;
            }
            if (fieldsToSort[x].equals("5")) {
                arrayList.add("createTime");
                continue;
            }
            if (fieldsToSort[x].equals("6")) {
                arrayList.add("modifiedTime");
                continue;
            }
            if (fieldsToSort[x].equals("3")) continue;
            arrayList.add(fieldsToSort[x]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public void deleteDocumentsContainingField(String fieldName, String fieldValue) throws FTSServiceException {
        this.notWriterExceptionCheck("deleteDocumentsContainingField");
        LOGGER.info((Object)("FTS: delete from index - Field = " + fieldName + ", fieldValue = " + fieldValue));
        this.deleteEntryDocument(fieldName, fieldValue, ftsAnalyzer);
        this.deleteEntryDocument(fieldName + "_literal", fieldValue, ftsAnalyzer);
        this.deleteEntryDocument(fieldName + "_literalCase", fieldValue, ftsAnalyzer);
        this.deleteEntryDocument(fieldName + "_case", fieldValue, ftsAnalyzer);
        this.deleteEntryDocument(fieldName + "_noStem", fieldValue, ftsAnalyzer);
        this.deleteEntryDocument(fieldName + "_caseNoStem", fieldValue, ftsAnalyzer);
        this.deleteEntryDocument(fieldName + "_orig", fieldValue, ftsAnalyzer);
        this.deleteEntryDocument(fieldName + "_bytes", fieldValue, ftsAnalyzer);
    }

    @Override
    public void updateConfiguration() throws FTSServiceException {
        try {
            if (ftsAnalyzer != null) {
                ((FTSAnalyzer)ftsAnalyzer).reload(this.caseSensitive);
            }
        }
        catch (Exception e) {
            throw new FTSServiceException(this.getClass().getName() + " updateConfiguration(): Analyzer reload failed", e);
        }
    }

    @Override
    public void close() throws FTSServiceException {
        this.notWriterExceptionCheck("close");
        try {
            if (indexSearcherQueue.size() != 0) {
                Iterator<IndexSearcher> i$ = indexSearcherQueue.iterator();
                while (i$.hasNext()) {
                    IndexSearcher is;
                    IndexSearcher indexSearcher = is = i$.next();
                    IndexReader indexReader = indexSearcher.getIndexReader();
                    indexReader.close();
                    indexSearcher.close();
                    indexReader = null;
                    Object var3_4 = null;
                }
                indexSearcherQueue.clear();
            }
            if (staticIndexWriter != null) {
                staticIndexWriter.close();
                staticIndexWriter = null;
            }
            recentInit = null;
        }
        catch (IOException e) {
            throw new FTSServiceException(this.getClass().getName() + " close: Problem closing the index", e);
        }
    }

    private void initAnalyzer(boolean caseSensitive) {
        LOGGER.info((Object)"FTS: Initialize full text analyzers");
        if (this.configurationDir != null && !this.configurationDir.equals("")) {
            File file = new File(this.configurationDir + "/FTSLocaleConfig.xml");
            if (file.exists()) {
                FTSAnalyzerConfigReader configReader = new FTSAnalyzerConfigReader();
                try {
                    this.analyzerConfig = configReader.readConfig(this.configurationDir, this.locale);
                }
                catch (Exception e) {
                    this.analyzerConfig = this.getDefaultAnalyzerConfig();
                    LOGGER.error((Object)(this.getClass().getName() + "initAnalyser: Failed to read FTSLocaleConfig.xml."), (Throwable)e);
                }
            } else {
                this.analyzerConfig = this.getDefaultAnalyzerConfig();
                LOGGER.warn((Object)(this.getClass().getName() + "initAnalyser: FTSLocaleConfig.xml is not a file."));
            }
        } else {
            this.analyzerConfig = this.getDefaultAnalyzerConfig();
            LOGGER.warn((Object)(this.getClass().getName() + "initAnalyser: Configuration directory does not exist."));
        }
        if (ftsAnalyzer != null) {
            ftsAnalyzer = null;
        }
        ftsAnalyzer = new FTSAnalyzer(this.analyzerConfig, caseSensitive);
    }

    private FTSAnalyzerConfigReader.FTSAnalyzerConfig getDefaultAnalyzerConfig() {
        FTSAnalyzerConfigReader.FTSAnalyzerConfig analyzerConfig = new FTSAnalyzerConfigReader.FTSAnalyzerConfig(new FTSAnalyzerConfigReader());
        analyzerConfig.stemmer = "English";
        return analyzerConfig;
    }

    private Document getDocumentById(String docId) throws FTSServiceException {
        return this.getDocumentById(docId, false);
    }

    private Document getDocumentById(String docId, boolean useWriterReader) throws FTSServiceException {
        Document document = null;
        TopDocs matchingDocs = null;
        try {
            IndexSearcher indexSearcher = this.getIndexSearcher();
            Term term = new Term("docId", docId);
            TermQuery termQuery = new TermQuery(term);
            matchingDocs = indexSearcher.search((Query)termQuery, 1);
            if (matchingDocs.totalHits > 0) {
                ScoreDoc[] hits = matchingDocs.scoreDocs;
                for (int i = 0; i < hits.length; ++i) {
                    document = indexSearcher.doc(hits[0].doc);
                }
            }
        }
        catch (IOException e) {
            throw new FTSServiceException(this.getClass().getName() + " getDocumentById: Failed to retrieve document", e);
        }
        return document;
    }

    private Document createDocument(String docId, String schemaId, String entryId) {
        Document document = new Document();
        Field.Index fieldIndex = Field.Index.NOT_ANALYZED;
        Field.Store fieldStore = Field.Store.YES;
        Field.TermVector termVector = Field.TermVector.YES;
        Field docField = new Field("docId", docId, fieldStore, fieldIndex, termVector);
        Field schemaField = new Field("schemaId", schemaId, fieldStore, fieldIndex, termVector);
        Field entryField = new Field("entryId", entryId, fieldStore, fieldIndex, termVector);
        document.add((Fieldable)docField);
        document.add((Fieldable)schemaField);
        document.add((Fieldable)entryField);
        return document;
    }

    private synchronized void updateByField(String fieldName, String fieldValue, Document doc, Analyzer analyzer) throws FTSServiceException {
        try {
            IndexWriter indexWriter = this.getIndexWriter(analyzer);
            if (indexWriter != null) {
                Term term = new Term(fieldName, fieldValue);
                indexWriter.updateDocument(term, doc);
            } else {
                LOGGER.warn((Object)("FTS: Missing IndexWriter for Analyzer '" + analyzer + "'"));
            }
        }
        catch (IOException e) {
            throw new FTSServiceException(this.getClass().getName() + " updateByField: Error updating documents with field name '" + fieldName + "' and field value '" + fieldValue, e);
        }
    }

    private synchronized void deleteEntryDocument(String docId) throws FTSServiceException {
        try {
            IndexWriter indexWriter = this.getIndexWriter(ftsAnalyzer);
            if (indexWriter != null) {
                Term term = new Term("docId", docId);
                indexWriter.deleteDocuments(term);
                this.commit();
            } else {
                LOGGER.warn((Object)("FTS: Missing IndexWriter for Analyzer '" + ftsAnalyzer + "'"));
            }
        }
        catch (IOException e) {
            throw new FTSServiceException(this.getClass().getName() + " deleteEntryDocument: Error deleting documents with field name '" + "docId" + "' and field data '" + docId, e);
        }
    }

    private synchronized void deleteEntryDocument(String fieldName, String fieldValue, Analyzer analyzer) throws FTSServiceException {
        try {
            IndexWriter indexWriter = this.getIndexWriter(analyzer);
            if (indexWriter != null) {
                indexWriter.deleteDocuments(new Term(fieldName, fieldValue));
                this.commit();
            } else {
                LOGGER.warn((Object)("FTS: Missing IndexWriter for Analyzer '" + analyzer + "'"));
            }
        }
        catch (IOException e) {
            throw new FTSServiceException(this.getClass().getName() + " deleteEntryDocument: Error deleting documents with field name '" + fieldName + "' and field data '" + fieldValue, e);
        }
    }

    private synchronized IndexWriter getIndexWriter(Analyzer analyzer) throws FTSServiceException {
        if (staticIndexWriter == null) {
            try {
                if (IndexWriter.isLocked((String)this.collectionDir)) {
                    FSDirectory fsDir = FSDirectory.getDirectory((String)this.collectionDir);
                    IndexWriter.unlock((Directory)fsDir);
                }
                staticIndexWriter = new IndexWriter(this.collectionDir, analyzer, IndexWriter.MaxFieldLength.UNLIMITED);
                staticIndexWriter.commit();
            }
            catch (IOException e) {
                throw new FTSServiceException(this.getClass().getName() + " getIndexWriter: Error getting index writer", e);
            }
        }
        return staticIndexWriter;
    }

    private synchronized IndexSearcher getIndexSearcher() throws FTSServiceException {
        FTSIndexSearcher returnSearcher = null;
        try {
            if (indexSearcherQueue.size() == 0) {
                IndexReader indexReader = IndexReader.open((String)this.collectionDir);
                returnSearcher = new FTSIndexSearcher(indexReader);
                indexSearcherQueue.add(returnSearcher);
            } else {
                IndexReader indexReader = indexSearcherQueue.get(indexSearcherQueue.size() - 1).getIndexReader();
                if (!indexReader.isCurrent()) {
                    IndexReader irReopen = indexReader.reopen();
                    for (int x = indexSearcherQueue.size() - 1; x > -1; --x) {
                        if (((FTSIndexSearcher)indexSearcherQueue.get(x)).getCount() != 0) continue;
                        IndexSearcher indexSearcher = indexSearcherQueue.get(x);
                        IndexReader indexReader2 = indexSearcher.getIndexReader();
                        indexReader2.close();
                        indexSearcher.close();
                        indexReader = null;
                        indexSearcher = null;
                        indexSearcherQueue.remove(x);
                    }
                    returnSearcher = new FTSIndexSearcher(irReopen);
                    indexSearcherQueue.add(returnSearcher);
                } else {
                    returnSearcher = indexSearcherQueue.get(indexSearcherQueue.size() - 1);
                }
            }
        }
        catch (IOException e) {
            throw new FTSServiceException(this.getClass().getName() + " getIndexSearcher: Error getting index searcher.  Likely cause is index does not exist", e);
        }
        return returnSearcher;
    }

    private String buildDocId(String schemaId, String entryId) {
        return schemaId + "##" + entryId;
    }

    private String getExcerptText(Document document, int excerptOption, Query query, IndexReader indexReader, int docId, ArrayList<FTSService.QuerySchemas> querySchemas, String markupLeft, String markupRight) {
        String strReturn = null;
        switch (excerptOption) {
            case 0: {
                strReturn = "";
                break;
            }
            case 1: {
                strReturn = this.getExcerpt(document, querySchemas);
                break;
            }
            case 2: {
                strReturn = this.getWAH(document, query, indexReader, docId, querySchemas, markupLeft, markupRight);
                if (strReturn != null && strReturn.length() != 0) break;
                strReturn = this.getExcerpt(document, querySchemas);
            }
        }
        boolean leftMarkPH = false;
        String markupLeftPH = "s!_01-$:Lft";
        if (markupLeft != null && markupLeft.length() > 0) {
            strReturn = strReturn.replace(markupLeft, markupLeftPH);
            leftMarkPH = true;
        }
        boolean rightMarkPH = false;
        String markupRightPH = "s!_01-$:Rht";
        if (markupRight != null && markupRight.length() > 0) {
            strReturn = strReturn.replace(markupRight, markupRightPH);
            rightMarkPH = true;
        }
        strReturn = strReturn.replaceAll("(?:\\<.*?\\>)+", " ");
        if (rightMarkPH) {
            strReturn = strReturn.replace(markupRightPH, markupRight);
        }
        if (leftMarkPH) {
            strReturn = strReturn.replace(markupLeftPH, markupLeft);
        }
        return strReturn;
    }

    private String getWAH(Document document, Query query, IndexReader indexReader, int docId, ArrayList<FTSService.QuerySchemas> querySchemas, String markupLeft, String markupRight) {
        List fields = document.getFields();
        Iterator i = fields.iterator();
        StringBuffer finalString = new StringBuffer("");
        LOGGER.debug((Object)("Number of pontential fields in entry to check for WAH: " + fields.size()));
        LOGGER.debug((Object)("Getting WAH data for: " + docId));
        while (i.hasNext()) {
            String strBestText;
            Field field = (Field)i.next();
            if (!field.name().endsWith("_orig") || field.name().equals("title_orig") || field.name().equals("createTime_orig") || field.name().equals("modifiedTime_orig")) continue;
            String strText = field.stringValue();
            String strFieldName = field.name().substring(0, field.name().length() - 5);
            if (!this.userHasRights(strFieldName = this.getFieldName(document, strFieldName), document.getField("schemaId").stringValue(), querySchemas) || (strBestText = this.doHighlight(indexReader, docId, strFieldName, query, strText, false, markupLeft, markupRight)) == null || strBestText.equals("")) continue;
            strBestText.replaceAll("\n", "").replaceAll("\f", "").replaceAll("\r", "").replaceAll("\t", "").trim();
            if (finalString.length() > 0) {
                finalString.append(" *** ");
            }
            finalString.append(strBestText);
        }
        LOGGER.debug((Object)("Completed WAH data for: " + docId));
        return finalString.toString();
    }

    private String getFieldName(Document document, String strFieldName) {
        String strReturn = null;
        byte[] bytes = document.getBinaryValue(strFieldName + "_bytes");
        if (bytes.length == 4) {
            if (bytes[0] == 1) {
                strReturn = strFieldName;
            }
            if (bytes[1] == 1) {
                strReturn = strFieldName + "_case";
            }
            if (bytes[2] == 1) {
                strReturn = strFieldName + "_literal";
            }
            if (bytes[3] == 1) {
                strReturn = strFieldName + "_literalCase";
            }
        }
        return strReturn;
    }

    private String doHighlight(IndexReader indexReader, int docId, String strFieldName, Query query, String strText, boolean isTitle, String markupLeft, String markupRight) {
        String strBestText = null;
        try {
            TokenStream tokenStream = TokenSources.getTokenStream((IndexReader)indexReader, (int)docId, (String)strFieldName);
            QueryScorer scorer = new QueryScorer(query, strFieldName);
            Object fragmenter = null;
            fragmenter = isTitle ? new NullFragmenter() : new SimpleSpanFragmenter(scorer);
            SimpleHTMLFormatter formatter = new SimpleHTMLFormatter(markupLeft, markupRight);
            Highlighter highlighter = new Highlighter((Formatter)formatter, (Scorer)scorer);
            highlighter.setTextFragmenter((Fragmenter)fragmenter);
            strBestText = highlighter.getBestFragment(tokenStream, strText);
        }
        catch (IOException e) {
            LOGGER.error((Object)("IOException when trying to generate Words Around Hits " + e.getLocalizedMessage()));
            return "";
        }
        catch (InvalidTokenOffsetsException e) {
            LOGGER.error((Object)("InvalidTokenOffsetsException when trying to generate Words Around Hits " + e.getLocalizedMessage()));
            return "";
        }
        catch (Exception e) {
            // empty catch block
        }
        return strBestText;
    }

    private String highlightTitleText(IndexReader indexReader, int docId, String strFieldName, Query query, String strText, int resultOption, String markupLeft, String markupRight) {
        String strBestText = null;
        if (strText != null && strText.length() != 0 && resultOption == 2) {
            strBestText = this.doHighlight(indexReader, docId, strFieldName, FTSQueryParser.createTitleQuery(query), strText, true, markupLeft, markupRight);
            if (strBestText == null) {
                strBestText = strText;
            }
        } else {
            strBestText = strText;
        }
        return strBestText;
    }

    private boolean userHasRights(String fieldName, String schemaId, ArrayList<FTSService.QuerySchemas> querySchemas) {
        boolean bReturn = false;
        block0: for (FTSService.QuerySchemas querySchema : querySchemas) {
            if (!schemaId.equals(querySchema.schemaId)) continue;
            Iterator<String> it = querySchema.queryFieldNames.iterator();
            while (it.hasNext()) {
                if (!it.next().equals(fieldName)) continue;
                bReturn = true;
                continue block0;
            }
        }
        return bReturn;
    }

    private String getExcerpt(Document document, ArrayList<FTSService.QuerySchemas> querySchemas) {
        List fields = document.getFields();
        Iterator i = fields.iterator();
        StringBuffer finalString = new StringBuffer("");
        int numWords = 30;
        while (i.hasNext()) {
            String strFieldName;
            Field field = (Field)i.next();
            if (!field.name().endsWith("_orig") || field.name().equals("title_orig") || field.name().equals("createTime_orig") || field.name().equals("modifiedTime_orig") || numWords <= 0 || !this.userHasRights(strFieldName = field.name().substring(0, field.name().length() - 5), document.getField("schemaId").stringValue(), querySchemas)) continue;
            if (numWords != 30) {
                finalString.append(" *** ");
            }
            String strText = field.stringValue();
            numWords = this.getWords(strText, numWords, finalString);
        }
        if (numWords == 0) {
            finalString.append("...");
        }
        return finalString.toString();
    }

    private int getWords(String strText, int nWords, StringBuffer finalString) {
        int last = 0;
        WordIterator iter = new WordIterator(strText);
        while (iter.hasNext()) {
            iter.next();
            if (nWords == 0) break;
            last = iter.getEnd();
            --nWords;
        }
        finalString.append(strText.substring(0, last));
        return nWords;
    }

    private void notWriterExceptionCheck(String method) throws FTSServiceException {
        if (!this.isWriter) {
            throw new FTSServiceException(this.getClass().getName() + " A writing method, " + method + ", was called to a non-writer instance of FTSService.");
        }
    }

    static {
        recentInit = null;
        entryFieldQueue = new Hashtable();
        memCheckCount = 0;
        checkCount = 1000;
        staticIndexWriter = null;
        indexSearcherQueue = new ArrayList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryDataSorter
    implements Comparator<FTSService.GlobalEntryData> {
        private String[] fieldsToSort = null;

        private EntryDataSorter() {
        }

        public void setFieldsToSort(String string) {
            this.fieldsToSort = string.split(";");
        }

        @Override
        public int compare(FTSService.GlobalEntryData globalEntryData1, FTSService.GlobalEntryData globalEntryData2) {
            int bReturn = 0;
            int count = 0;
            boolean processFields = true;
            while (processFields && count < this.fieldsToSort.length) {
                Number minus;
                Object value2;
                Object value1;
                String field = this.fieldsToSort[count];
                if (field.equals("4")) {
                    value1 = Float.valueOf(globalEntryData1.score);
                    value2 = Float.valueOf(globalEntryData2.score);
                    minus = Float.valueOf(((Float)value1).floatValue() - ((Float)value2).floatValue());
                    if (((Float)minus).floatValue() != 0.0f) {
                        bReturn = this.fieldsToSort[count + 1].equals("1") ? ((Float)value1).compareTo((Float)value2) : ((Float)value1).compareTo((Float)value2) * -1;
                        processFields = false;
                        continue;
                    }
                    if (count < this.fieldsToSort.length - 1) {
                        count += 2;
                        continue;
                    }
                    bReturn = 0;
                    continue;
                }
                if (field.equals("5") || field.equals("6")) {
                    value1 = this.getDateFieldData(field, globalEntryData1);
                    value2 = this.getDateFieldData(field, globalEntryData2);
                    minus = (Long)value1 - (Long)value2;
                    if ((Long)minus != 0L) {
                        bReturn = this.fieldsToSort[count + 1].equals("1") ? ((Long)value1).compareTo((Long)value2) : ((Long)value1).compareTo((Long)value2) * -1;
                        processFields = false;
                        continue;
                    }
                    if (count < this.fieldsToSort.length - 1) {
                        count += 2;
                        continue;
                    }
                    bReturn = 0;
                    continue;
                }
                value1 = this.getFieldData(field, globalEntryData1);
                if (!((String)value1).equals(value2 = this.getFieldData(field, globalEntryData2))) {
                    bReturn = this.fieldsToSort[count + 1].equals("1") ? ((String)value1).compareToIgnoreCase((String)value2) : ((String)value1).compareToIgnoreCase((String)value2) * -1;
                    processFields = false;
                    continue;
                }
                if (count < this.fieldsToSort.length - 1) {
                    count += 2;
                    continue;
                }
                bReturn = 0;
                return 0;
            }
            return bReturn;
        }

        private long getDateFieldData(String field, FTSService.GlobalEntryData globalEntryData) {
            long nReturn = 0L;
            nReturn = field.equals("6") ? Long.parseLong(globalEntryData.modifiedDate) : Long.parseLong(globalEntryData.createDate);
            return nReturn;
        }

        private String getFieldData(String field, FTSService.GlobalEntryData globalEntryData) {
            String strReturn = "";
            if (field.equals("0")) {
                strReturn = globalEntryData.schemaId;
            } else if (field.equals("1")) {
                strReturn = globalEntryData.entryId;
            } else if (field.equals("2")) {
                strReturn = globalEntryData.title;
            } else if (field.equals("3")) {
                strReturn = globalEntryData.excerpt;
            } else {
                ArrayList<FTSService.ReturnFilterFields> returnFilterFields = globalEntryData.returnFilterFields;
                for (FTSService.ReturnFilterFields rff : returnFilterFields) {
                    if (!field.equals("\"" + rff.filterField + "\"")) continue;
                    strReturn = rff.value;
                    break;
                }
            }
            return strReturn;
        }
    }

    private class FieldDataHolder {
        public String schemaId;
        public String entryId;
        public float docBoost;
        public String[] fieldNames;
        public String[] values;
        public BitSet[] fullTextOptions;
        public float[] fieldBoost;

        FieldDataHolder(String schemaId, String entryId, float docBoost, String[] fieldNames, String[] values, BitSet[] fullTextOptions, float[] fieldBoost) {
            this.schemaId = schemaId;
            this.entryId = entryId;
            this.docBoost = docBoost;
            this.fieldNames = fieldNames;
            this.values = values;
            this.fullTextOptions = fullTextOptions;
            this.fieldBoost = fieldBoost;
        }
    }
}

