/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.util;

import com.bmc.thirdparty.org.springframework.util.PathMatcher;
import com.bmc.thirdparty.org.springframework.util.StringUtils;

public class AntPathMatcher
implements PathMatcher {
    public static final String DEFAULT_PATH_SEPARATOR = "/";
    private String pathSeparator = "/";

    public void setPathSeparator(String pathSeparator) {
        this.pathSeparator = pathSeparator != null ? pathSeparator : DEFAULT_PATH_SEPARATOR;
    }

    public boolean isPattern(String str) {
        return str.indexOf(42) != -1 || str.indexOf(63) != -1;
    }

    public boolean match(String pattern, String str) {
        String patDir;
        int strIdxStart;
        if (str.startsWith(this.pathSeparator) != pattern.startsWith(this.pathSeparator)) {
            return false;
        }
        String[] patDirs = StringUtils.tokenizeToStringArray(pattern, this.pathSeparator);
        String[] strDirs = StringUtils.tokenizeToStringArray(str, this.pathSeparator);
        int patIdxStart = 0;
        int patIdxEnd = patDirs.length - 1;
        int strIdxEnd = strDirs.length - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = patDirs[patIdxStart]).equals("**"); ++patIdxStart, ++strIdxStart) {
            if (this.matchStrings(patDir, strDirs[strIdxStart])) continue;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            if (patIdxStart == patIdxEnd && patDirs[patIdxStart].equals("*") && str.endsWith(this.pathSeparator)) {
                return true;
            }
            for (int i2 = patIdxStart; i2 <= patIdxEnd; ++i2) {
                if (patDirs[i2].equals("**")) continue;
                return false;
            }
            return true;
        }
        if (patIdxStart > patIdxEnd) {
            return false;
        }
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = patDirs[patIdxEnd]).equals("**")) {
            if (!this.matchStrings(patDir, strDirs[strIdxEnd])) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i3 = patIdxStart; i3 <= patIdxEnd; ++i3) {
                if (patDirs[i3].equals("**")) continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i4 = patIdxStart + 1; i4 <= patIdxEnd; ++i4) {
                if (!patDirs[i4].equals("**")) continue;
                patIdxTmp = i4;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i5 = 0; i5 <= strLength - patLength; ++i5) {
                for (int j2 = 0; j2 < patLength; ++j2) {
                    String subPat = patDirs[patIdxStart + j2 + 1];
                    String subStr = strDirs[strIdxStart + i5 + j2];
                    if (!this.matchStrings(subPat, subStr)) continue block6;
                }
                foundIdx = strIdxStart + i5;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i6 = patIdxStart; i6 <= patIdxEnd; ++i6) {
            if (patDirs[i6].equals("**")) continue;
            return false;
        }
        return true;
    }

    private boolean matchStrings(String pattern, String str) {
        char ch;
        int i2;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (i2 = 0; i2 < patArr.length; ++i2) {
            if (patArr[i2] != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (i2 = 0; i2 <= patIdxEnd; ++i2) {
                char ch2 = patArr[i2];
                if (ch2 == '?' || ch2 == strArr[i2]) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && ch != strArr[strIdxStart]) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (i2 = patIdxStart; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && ch != strArr[strIdxEnd]) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (i2 = patIdxStart; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i3 = patIdxStart + 1; i3 <= patIdxEnd; ++i3) {
                if (patArr[i3] != '*') continue;
                patIdxTmp = i3;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i4 = 0; i4 <= strLength - patLength; ++i4) {
                for (int j2 = 0; j2 < patLength; ++j2) {
                    ch = patArr[patIdxStart + j2 + 1];
                    if (ch != '?' && ch != strArr[strIdxStart + i4 + j2]) continue block8;
                }
                foundIdx = strIdxStart + i4;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (i2 = patIdxStart; i2 <= patIdxEnd; ++i2) {
            if (patArr[i2] == '*') continue;
            return false;
        }
        return true;
    }

    public String extractPathWithinPattern(String pattern, String path) {
        int i2;
        String[] patternParts = StringUtils.tokenizeToStringArray(pattern, this.pathSeparator);
        String[] pathParts = StringUtils.tokenizeToStringArray(path, this.pathSeparator);
        StringBuffer buffer = new StringBuffer();
        int puts = 0;
        for (i2 = 0; i2 < patternParts.length; ++i2) {
            String patternPart = patternParts[i2];
            if (patternPart.indexOf(42) <= -1 && patternPart.indexOf(63) <= -1) continue;
            if (puts != 0) {
                buffer.append(this.pathSeparator);
            }
            if (pathParts.length < i2 + 1) continue;
            buffer.append(pathParts[i2]);
            ++puts;
        }
        for (i2 = patternParts.length; i2 < pathParts.length; ++i2) {
            if (puts > 0 || i2 > 0) {
                buffer.append(this.pathSeparator);
            }
            buffer.append(pathParts[i2]);
        }
        return buffer.toString();
    }
}

