/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.orm.ibatis.support;

import com.bmc.thirdparty.org.springframework.jdbc.support.lob.LobCreator;
import com.bmc.thirdparty.org.springframework.jdbc.support.lob.LobHandler;
import com.bmc.thirdparty.org.springframework.orm.ibatis.support.AbstractLobTypeHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BlobSerializableTypeHandler
extends AbstractLobTypeHandler {
    public BlobSerializableTypeHandler() {
    }

    protected BlobSerializableTypeHandler(LobHandler lobHandler) {
        super(lobHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setParameterInternal(PreparedStatement ps, int index, Object value, String jdbcType, LobCreator lobCreator) throws SQLException, IOException {
        if (value != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                oos.writeObject(value);
                oos.flush();
                lobCreator.setBlobAsBytes(ps, index, baos.toByteArray());
            }
            finally {
                oos.close();
            }
        } else {
            lobCreator.setBlobAsBytes(ps, index, null);
        }
    }

    protected Object getResultInternal(ResultSet rs, int index, LobHandler lobHandler) throws SQLException, IOException {
        InputStream is = lobHandler.getBlobAsBinaryStream(rs, index);
        if (is != null) {
            ObjectInputStream ois = new ObjectInputStream(is);
            try {
                Object object = ois.readObject();
                return object;
            }
            catch (ClassNotFoundException ex) {
                throw new SQLException("Could not deserialize BLOB contents: " + ex.getMessage());
            }
            finally {
                ois.close();
            }
        }
        return null;
    }

    public Object valueOf(String s) {
        return s;
    }
}

