/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.support;

import com.bmc.thirdparty.org.springframework.aop.MethodMatcher;
import com.bmc.thirdparty.org.springframework.aop.Pointcut;
import com.bmc.thirdparty.org.springframework.aop.support.ComposablePointcut;
import com.bmc.thirdparty.org.springframework.aop.support.StaticMethodMatcherPointcut;
import com.bmc.thirdparty.org.springframework.aop.support.UnionPointcut;
import java.io.Serializable;
import java.lang.reflect.Method;

public abstract class Pointcuts {
    public static final Pointcut SETTERS = SetterPointcut.INSTANCE;
    public static final Pointcut GETTERS = GetterPointcut.INSTANCE;

    public static Pointcut union(Pointcut a2, Pointcut b2) {
        return new UnionPointcut(a2, b2);
    }

    public static Pointcut intersection(Pointcut a2, Pointcut b2) {
        return new ComposablePointcut(a2.getClassFilter(), a2.getMethodMatcher()).intersection(b2);
    }

    public static boolean matches(Pointcut pc, Method method, Class targetClass, Object[] arguments) {
        MethodMatcher mm;
        if (pc == Pointcut.TRUE) {
            return true;
        }
        if (pc.getClassFilter().matches(targetClass) && (mm = pc.getMethodMatcher()).matches(method, targetClass)) {
            return mm.isRuntime() ? mm.matches(method, targetClass, arguments) : true;
        }
        return false;
    }

    private static class GetterPointcut
    extends StaticMethodMatcherPointcut
    implements Serializable {
        public static GetterPointcut INSTANCE = new GetterPointcut();

        private GetterPointcut() {
        }

        public boolean matches(Method method, Class targetClass) {
            return method.getName().startsWith("get") && method.getParameterTypes().length == 0;
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static class SetterPointcut
    extends StaticMethodMatcherPointcut
    implements Serializable {
        public static SetterPointcut INSTANCE = new SetterPointcut();

        private SetterPointcut() {
        }

        public boolean matches(Method method, Class targetClass) {
            return method.getName().startsWith("set") && method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE;
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

